/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.utils;

import com.google.common.collect.ImmutableSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class PathMatcher {
    private static final ImmutableSet<Character> REGEXP_SPECIAL_CHARS = (ImmutableSet)"<([{\\^-=$!|]})?*+.>".chars().mapToObj(c -> Character.valueOf((char)c)).collect(ImmutableSet.toImmutableSet());
    private final Pattern regexpPattern;

    private PathMatcher(Pattern regexpPattern) {
        this.regexpPattern = regexpPattern;
    }

    public static PathMatcher createFromGlob(String globPattern) {
        try {
            Pattern regexpPattern = Pattern.compile(PathMatcher.convertGlobToRegexp(globPattern));
            return new PathMatcher(regexpPattern);
        }
        catch (PatternSyntaxException e) {
            throw new GlobPatternSyntaxException(globPattern, e);
        }
    }

    public boolean matches(String input) {
        return this.regexpPattern.matcher(input).matches();
    }

    private static String convertGlobToRegexp(String globPattern) {
        StringBuilder regexpBuilder = new StringBuilder().append('^');
        boolean inGroup = false;
        int openingGroupIdx = 0;
        block10: for (int i = 0; i < globPattern.length(); ++i) {
            switch (globPattern.charAt(i)) {
                case '\\': {
                    if (i == globPattern.length() - 1) {
                        throw new GlobPatternSyntaxException("No character to escape.", globPattern, i);
                    }
                    regexpBuilder.append('\\').append(globPattern.charAt(i + 1));
                    ++i;
                    continue block10;
                }
                case '*': {
                    if (i + 1 < globPattern.length() && globPattern.charAt(i + 1) == '*') {
                        ++i;
                        regexpBuilder.append(".*?");
                        continue block10;
                    }
                    regexpBuilder.append("[^/]*");
                    continue block10;
                }
                case '?': {
                    regexpBuilder.append(".");
                    continue block10;
                }
                case '[': {
                    char currentChar;
                    char nextChar;
                    int openBracketIdx = i++;
                    regexpBuilder.append('[');
                    char c = nextChar = i < globPattern.length() ? globPattern.charAt(i) : (char)'\u0000';
                    if (nextChar == '^') {
                        regexpBuilder.append('\\');
                    } else if (nextChar == '!') {
                        regexpBuilder.append('^');
                    }
                    while (i < globPattern.length() && globPattern.charAt(i) != ']') {
                        currentChar = globPattern.charAt(i);
                        if (currentChar == '/') {
                            throw new GlobPatternSyntaxException("Character '/' is not allowed within a character set", globPattern, i);
                        }
                        regexpBuilder.append(globPattern.charAt(i));
                        ++i;
                    }
                    if (i == globPattern.length()) {
                        throw new GlobPatternSyntaxException("No matching ']' found.", globPattern, openBracketIdx);
                    }
                    if (i == openBracketIdx + 1) {
                        throw new GlobPatternSyntaxException("Empty characters set.", globPattern, openBracketIdx);
                    }
                    regexpBuilder.append(globPattern.charAt(i));
                    continue block10;
                }
                case '{': {
                    if (inGroup) {
                        throw new GlobPatternSyntaxException("Cannot nest groups.", globPattern, i);
                    }
                    openingGroupIdx = i;
                    inGroup = true;
                    regexpBuilder.append("(?:");
                    continue block10;
                }
                case '}': {
                    if (!inGroup) {
                        throw new GlobPatternSyntaxException("No matching '{' found.", globPattern, i);
                    }
                    regexpBuilder.append(')');
                    inGroup = false;
                    continue block10;
                }
                case ']': {
                    throw new GlobPatternSyntaxException("No matching '[' found.", globPattern, i);
                }
                case ',': {
                    if (inGroup) {
                        regexpBuilder.append('|');
                        continue block10;
                    }
                    regexpBuilder.append(',');
                    continue block10;
                }
                default: {
                    char currentChar = globPattern.charAt(i);
                    if (REGEXP_SPECIAL_CHARS.contains((Object)Character.valueOf(currentChar))) {
                        regexpBuilder.append('\\');
                    }
                    regexpBuilder.append(currentChar);
                }
            }
        }
        if (inGroup) {
            throw new GlobPatternSyntaxException("No matching '}' found.", globPattern, openingGroupIdx);
        }
        return regexpBuilder.append('$').toString();
    }

    public static class GlobPatternSyntaxException
    extends RuntimeException {
        private GlobPatternSyntaxException(String message, String globPattern, int index) {
            super(String.format("Unable to parse glob pattern '%s' at character %d. Error: %s", globPattern, index + 1, message));
        }

        private GlobPatternSyntaxException(String globPattern, Throwable cause) {
            super(String.format("Unable to parse glob pattern '%s'.", globPattern), cause);
        }
    }
}

