/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.validation.AssetsTargetingValidator;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.ModuleDependencyValidator;
import com.android.tools.build.bundletool.validation.NativeTargetingValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.zip.ZipFile;

public class AppBundleValidator {
    private static final ImmutableList<SubValidator> BUNDLE_SUB_VALIDATORS = ImmutableList.of((Object)new AssetsTargetingValidator(), (Object)new BundleFilesValidator(), (Object)new ModuleDependencyValidator(), (Object)new NativeTargetingValidator(), (Object)new ResourceTableValidator());

    public AppBundle validate(Path bundleFile) throws IOException {
        AppBundle bundle = AppBundle.buildFromZip(new ZipFile(bundleFile.toFile()));
        new ValidatorRunner(BUNDLE_SUB_VALIDATORS).validate(bundle);
        return bundle;
    }
}

