/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils.zip;

import com.android.tools.build.bundletool.utils.zip.AutoValue_OutputBuilder_Entry;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageLite;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class OutputBuilder {
    protected final Map<Path, Entry> entries = new LinkedHashMap<Path, Entry>();

    public abstract Path writeTo(Path var1) throws IOException;

    public OutputBuilder addFileWithContent(Path toPath, byte[] content, EntryOption ... options) {
        return this.addFile(toPath, () -> new ByteArrayInputStream(content), options);
    }

    public OutputBuilder addFileFromDisk(Path toPath, Path file, EntryOption ... options) {
        Preconditions.checkArgument((boolean)Files.isRegularFile(file, new LinkOption[0]), (String)"Path '%s' does not denote a file.", (Object)file);
        return this.addFile(toPath, () -> new BufferedInputStream(Files.newInputStream(file, new OpenOption[0])), options);
    }

    public OutputBuilder addFileWithProtoContent(Path toPath, MessageLite protoMsg, EntryOption ... options) {
        return this.addFile(toPath, () -> new ByteArrayInputStream(protoMsg.toByteArray()), options);
    }

    public OutputBuilder addFileFromZip(Path toPath, ZipFile fromZipFile, ZipEntry zipEntry, EntryOption ... options) {
        return this.addFile(toPath, () -> fromZipFile.getInputStream(zipEntry), options);
    }

    public OutputBuilder addFile(Path toPath, InputStreamSupplier inputStreamSupplier, EntryOption ... options) {
        Preconditions.checkArgument((!this.entries.containsKey(toPath) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)toPath);
        this.entries.put(toPath, Entry.builder().setIsDirectory(false).setInputStreamSupplier(inputStreamSupplier).setOptions((ImmutableSet<EntryOption>)ImmutableSet.copyOf((Object[])options)).build());
        return this;
    }

    public OutputBuilder addDirectory(Path dir) {
        Preconditions.checkArgument((!this.entries.containsKey(dir) ? 1 : 0) != 0, (String)"Path '%s' is already taken.", (Object)dir);
        this.entries.put(dir, Entry.builder().setIsDirectory(true).setOptions((ImmutableSet<EntryOption>)ImmutableSet.of()).build());
        return this;
    }

    public OutputBuilder copyAllContentsFromZip(Path toDirectory, ZipFile srcZipFile) {
        Enumeration<? extends ZipEntry> zipEntries = srcZipFile.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry zipEntry = zipEntries.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.addFileFromZip(toDirectory.resolve(zipEntry.getName()), srcZipFile, zipEntry, new EntryOption[0]);
        }
        return this;
    }

    public static enum EntryOption {
        UNCOMPRESSED;

    }

    @AutoValue
    protected static abstract class Entry {
        protected Entry() {
        }

        public abstract Optional<InputStreamSupplier> getInputStreamSupplier();

        public abstract boolean getIsDirectory();

        public abstract ImmutableSet<EntryOption> getOptions();

        public static Builder builder() {
            return new AutoValue_OutputBuilder_Entry.Builder();
        }

        public boolean hasOption(EntryOption option) {
            return this.getOptions().contains((Object)option);
        }

        static abstract class Builder {
            Builder() {
            }

            public abstract Builder setInputStreamSupplier(InputStreamSupplier var1);

            public abstract Builder setIsDirectory(boolean var1);

            public abstract Builder setOptions(ImmutableSet<EntryOption> var1);

            public abstract Entry autoBuild();

            public Entry build() {
                Entry result = this.autoBuild();
                Preconditions.checkState((boolean)(result.getInputStreamSupplier().isPresent() ^ result.getIsDirectory()), (Object)"Input stream supplier must be absent iff the entry is a directory.");
                return result;
            }
        }
    }

    public static interface InputStreamSupplier {
        public InputStream get() throws IOException;
    }
}

