/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.utils;

import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Ordering;
import java.util.Comparator;

public class TargetingComparators {
    private static final Ordering<Targeting.Abi.AbiAlias> ARCHITECTURE_ORDERING = Ordering.explicit((Object)((Object)Targeting.Abi.AbiAlias.ARMEABI), (Object[])new Targeting.Abi.AbiAlias[]{Targeting.Abi.AbiAlias.ARMEABI_V7A, Targeting.Abi.AbiAlias.ARM64_V8A, Targeting.Abi.AbiAlias.X86, Targeting.Abi.AbiAlias.X86_64, Targeting.Abi.AbiAlias.MIPS, Targeting.Abi.AbiAlias.MIPS64});
    private static final Comparator<Targeting.VariantTargeting> ABI_COMPARATOR = Comparator.comparing(TargetingComparators::getAbi, ARCHITECTURE_ORDERING);
    private static final Comparator<Targeting.VariantTargeting> SDK_COMPARATOR = Comparator.comparing(TargetingComparators::getMinSdk);
    private static final Comparator<Targeting.VariantTargeting> SCREEN_DENSITY_COMPARATOR = Comparator.comparing(TargetingComparators::getScreenDensity);
    public static final Comparator<Targeting.VariantTargeting> VARIANT_TARGETING_COMPARATOR = SDK_COMPARATOR.thenComparing(ABI_COMPARATOR).thenComparing(SCREEN_DENSITY_COMPARATOR);

    private static int getMinSdk(Targeting.VariantTargeting variantTargeting) {
        return variantTargeting.getSdkVersionTargeting().getValueList().stream().mapToInt(sdkVersion -> sdkVersion.getMin().getValue()).max().getAsInt();
    }

    private static Targeting.Abi.AbiAlias getAbi(Targeting.VariantTargeting variantTargeting) {
        return ((Targeting.Abi)variantTargeting.getAbiTargeting().getValueList().stream().collect(MoreCollectors.onlyElement())).getAlias();
    }

    private static int getScreenDensity(Targeting.VariantTargeting variantTargeting) {
        Targeting.ScreenDensity densityTargeting = (Targeting.ScreenDensity)variantTargeting.getScreenDensityTargeting().getValueList().stream().collect(MoreCollectors.onlyElement());
        return densityTargeting.getDensityOneofCase() == Targeting.ScreenDensity.DensityOneofCase.DENSITY_ALIAS ? ((Integer)ResourcesUtils.DENSITY_ALIAS_TO_DPI_MAP.get((Object)densityTargeting.getDensityAlias())).intValue() : densityTargeting.getDensityDpi();
    }
}

