/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.bundle.Commands;
import com.android.bundle.Files;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.manifest.AndroidManifest;
import com.android.tools.build.bundletool.manifest.ManifestEditor;
import com.android.tools.build.bundletool.model.AutoValue_ModuleSplit;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.utils.AbiUtils;
import com.android.tools.build.bundletool.utils.ResourcesUtils;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Stream;

@AutoValue
public abstract class ModuleSplit {
    public abstract Targeting.ApkTargeting getTargeting();

    public abstract ImmutableList<ModuleEntry> getEntries();

    public abstract Optional<Resources.ResourceTable> getResourceTable();

    public abstract Optional<AndroidManifest> getAndroidManifest();

    public abstract BundleModuleName getModuleName();

    public abstract boolean isMasterSplit();

    public abstract Optional<Files.NativeLibraries> getNativeConfig();

    public abstract Optional<Files.Assets> getAssetsConfig();

    public abstract Builder toBuilder();

    public static Path toSplitEntryPath(Path pathInModule) {
        if (pathInModule.startsWith(BundleModule.DEX_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() == 2 ? 1 : 0) != 0, (String)"Only files directly in the dex directory are supported but found: %s.", (Object)pathInModule);
            FilePreconditions.checkFileHasExtension("File under dex/ directory", pathInModule, ".dex");
            return pathInModule.getFileName();
        }
        if (pathInModule.startsWith(BundleModule.ROOT_DIRECTORY)) {
            Preconditions.checkArgument((pathInModule.getNameCount() >= 2 ? 1 : 0) != 0, (String)"Only files inside the root directory are supported but found: %s", (Object)pathInModule);
            return pathInModule.subpath(1, pathInModule.getNameCount());
        }
        return pathInModule;
    }

    public String getSuffix() {
        StringJoiner suffixJoiner = new StringJoiner("_");
        this.getTargeting().getAbiTargeting().getValueList().forEach(value -> suffixJoiner.add(((String)AbiUtils.ABI_NAME_TO_PROTO_VALUE_MAP.inverse().get((Object)value.getAlias())).replace('-', '_')));
        this.getTargeting().getLanguageTargeting().getValueList().forEach(suffixJoiner::add);
        this.getTargeting().getScreenDensityTargeting().getValueList().forEach(value -> suffixJoiner.add(((String)ResourcesUtils.SCREEN_DENSITY_TO_PROTO_VALUE_MAP.inverse().get((Object)value.getDensityAlias())).replace('-', '_')));
        this.getTargeting().getGraphicsApiTargeting().getValueList().forEach(value -> suffixJoiner.add(ModuleSplit.formatGraphicsApi(value)));
        this.getTargeting().getTextureCompressionFormatTargeting().getValueList().forEach(value -> suffixJoiner.add(value.getAlias().name().toLowerCase()));
        return suffixJoiner.toString();
    }

    private static String formatGraphicsApi(Targeting.GraphicsApi graphicsTargeting) {
        StringJoiner result = new StringJoiner("_");
        if (graphicsTargeting.hasOpenGlVersions()) {
            Targeting.OpenGlVersionRange range = graphicsTargeting.getOpenGlVersions();
            if (range.hasMin()) {
                result.add("glmin" + ModuleSplit.formatGlVersion(range.getMin()));
            }
            if (range.hasMax()) {
                result.add("glmax" + ModuleSplit.formatGlVersion(range.getMax()));
            }
        }
        return result.toString();
    }

    private static String formatGlVersion(Targeting.OpenGlVersion glVersion) {
        return glVersion.getMajor() + "_" + glVersion.getMinor();
    }

    public static ImmutableList<ModuleEntry> filterResourceEntries(ImmutableList<ModuleEntry> entries, Resources.ResourceTable resourceTable) {
        ImmutableSet<Path> referencedPaths = ResourcesUtils.getAllFileReferences(resourceTable);
        return (ImmutableList)entries.stream().filter(entry -> referencedPaths.contains((Object)entry.getPath())).collect(ImmutableList.toImmutableList());
    }

    public Commands.ApkDescription writeAsSplitApkTo(Path outputPath) {
        this.writeToZipFile(outputPath);
        return Commands.ApkDescription.newBuilder().setPath(outputPath.toString()).setTargeting(this.getTargeting()).setSplitApkMetadata(Commands.SplitApkMetadata.newBuilder().setSplitId(this.getAndroidManifest().get().getSplitId().orElse("")).setIsMasterSplit(this.isMasterSplit())).build();
    }

    public Commands.ApkDescription writeAsStandaloneApkTo(Path outputPath) {
        this.writeToZipFile(outputPath);
        return Commands.ApkDescription.newBuilder().setPath(outputPath.toString()).setTargeting(this.getTargeting()).build();
    }

    public Path writeToZipFile(Path outputPath) {
        Preconditions.checkState((boolean)this.getAndroidManifest().isPresent(), (Object)"Missing AndroidManifest");
        ZipBuilder zipBuilder = new ZipBuilder();
        for (ModuleEntry entry : this.getEntries()) {
            zipBuilder.addFile(ModuleSplit.toSplitEntryPath(entry.getPath()), () -> entry.getContent(), new OutputBuilder.EntryOption[0]);
        }
        if (this.getResourceTable().isPresent()) {
            zipBuilder.addFileWithProtoContent(BundleModule.RESOURCES_PROTO_PATH, (MessageLite)this.getResourceTable().get(), new OutputBuilder.EntryOption[0]);
        }
        zipBuilder.addFileWithProtoContent(Paths.get("AndroidManifest.xml", new String[0]), (MessageLite)this.getAndroidManifest().get().getManifestRoot(), new OutputBuilder.EntryOption[0]);
        try {
            zipBuilder.writeTo(outputPath);
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error while writing APK to file '%s'.", outputPath.getFileName());
        }
        return outputPath;
    }

    public ModuleSplit writeSplitIdInManifest(String resolvedSplitIdSuffix) {
        Preconditions.checkArgument((boolean)this.getAndroidManifest().isPresent(), (Object)"Missing Android Manifest");
        ManifestEditor manifestEditor = this.getAndroidManifest().get().toEditor();
        String splitId = this.generateSplitId(resolvedSplitIdSuffix);
        if (this.isMasterSplit()) {
            manifestEditor.setSplitIdForFeatureSplit(splitId);
        } else {
            manifestEditor.setSplitIdForConfigSplit(splitId, this.getSplitIdForMasterSplit());
        }
        return this.toBuilder().setAndroidManifest(manifestEditor.save()).build();
    }

    private String generateSplitId(String resolvedSuffix) {
        String masterSplitId = this.getSplitIdForMasterSplit();
        if (this.isMasterSplit()) {
            return masterSplitId;
        }
        StringBuilder splitIdBuilder = new StringBuilder(masterSplitId);
        if (splitIdBuilder.length() > 0) {
            splitIdBuilder.append(".");
        }
        return splitIdBuilder.append("config.").append(resolvedSuffix).toString();
    }

    private String getSplitIdForMasterSplit() {
        return this.getModuleName().getNameForSplitId();
    }

    public static Builder builder() {
        return new AutoValue_ModuleSplit.Builder();
    }

    public static ModuleSplit forModule(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> !BundleModule.SPECIAL_FILES.contains((Object)entry.getPath())), true);
    }

    public static ModuleSplit forResources(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.RESOURCES_DIRECTORY)), true);
    }

    public static ModuleSplit forAssets(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.ASSETS_DIRECTORY)), false);
    }

    public static ModuleSplit forNativeLibraries(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.LIB_DIRECTORY)), false);
    }

    public static ModuleSplit forCode(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)), false);
    }

    public static ModuleSplit forRoot(BundleModule bundleModule) {
        return ModuleSplit.fromBundleModule(bundleModule, (Predicate<ModuleEntry>)((Predicate)entry -> entry.getPath().startsWith(BundleModule.ROOT_DIRECTORY)), false);
    }

    protected static ModuleSplit fromBundleModule(BundleModule bundleModule, Predicate<ModuleEntry> entriesPredicate, boolean setResourceTable) {
        Builder splitBuilder = ModuleSplit.builder().setModuleName(bundleModule.getName()).setEntries((List)bundleModule.getEntries().stream().filter(entriesPredicate).collect(ImmutableList.toImmutableList())).setAndroidManifest(bundleModule.getManifest()).setMasterSplit(true).setTargeting(Targeting.ApkTargeting.getDefaultInstance());
        bundleModule.getNativeConfig().ifPresent(splitBuilder::setNativeConfig);
        bundleModule.getAssetsConfig().ifPresent(splitBuilder::setAssetsConfig);
        if (setResourceTable) {
            bundleModule.getResourceTable().ifPresent(splitBuilder::setResourceTable);
        }
        return splitBuilder.build();
    }

    public Stream<ModuleEntry> findEntriesUnderPath(String path) {
        return this.getEntries().stream().filter(entry -> entry.getPath().startsWith(path));
    }

    public Stream<ModuleEntry> findEntriesInsideDirectory(String directory) {
        return this.getEntries().stream().filter(entry -> entry.getPath().getParent().equals(Paths.get(directory, new String[0])));
    }

    public static abstract class Builder {
        public abstract Builder setModuleName(BundleModuleName var1);

        public abstract Builder setMasterSplit(boolean var1);

        public abstract Builder setNativeConfig(Files.NativeLibraries var1);

        public abstract Builder setAssetsConfig(Files.Assets var1);

        public abstract Builder setTargeting(Targeting.ApkTargeting var1);

        public abstract Builder setEntries(List<ModuleEntry> var1);

        protected abstract ImmutableList<ModuleEntry> getEntries();

        public abstract Builder setResourceTable(Resources.ResourceTable var1);

        public abstract Builder setAndroidManifest(AndroidManifest var1);

        protected abstract ModuleSplit autoBuild();

        public ModuleSplit build() {
            ModuleSplit moduleSplit = this.autoBuild();
            Preconditions.checkState((this.getEntries().stream().filter(entry -> BundleModule.SPECIAL_FILES.contains((Object)entry.getPath())).count() == 0L ? 1 : 0) != 0, (Object)"ModuleSplit entries cannot contain special bundle files.");
            if (moduleSplit.isMasterSplit()) {
                Preconditions.checkState((boolean)moduleSplit.getTargeting().toBuilder().clearSdkVersionTargeting().build().equals(Targeting.ApkTargeting.getDefaultInstance()), (Object)"Master split cannot have any targeting other than SDK version.");
            }
            return moduleSplit;
        }
    }
}

