/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Manifest;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleZipEntry;
import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipBuilder;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class AppBundle {
    public static final String BUNDLE_MANIFEST_FILE_NAME = "BundleManifest.pb";
    private final ImmutableMap<BundleModuleName, BundleModule> modules;
    private final Manifest.BundleManifest bundleManifest;

    private AppBundle(Map<BundleModuleName, BundleModule> modules, Manifest.BundleManifest bundleManifest) {
        this.modules = ImmutableMap.copyOf(modules);
        this.bundleManifest = bundleManifest;
    }

    public static AppBundle buildFromZip(ZipFile bundleFile) {
        return new AppBundle(AppBundle.extractModules(bundleFile), AppBundle.readBundleManifest(bundleFile));
    }

    public static AppBundle buildFromModules(ImmutableCollection<BundleModule> modules, Manifest.BundleManifest bundleManifest) {
        return new AppBundle((Map<BundleModuleName, BundleModule>)Maps.uniqueIndex(modules, BundleModule::getName), bundleManifest);
    }

    public ImmutableMap<BundleModuleName, BundleModule> getModules() {
        return this.modules;
    }

    public BundleModule getModule(BundleModuleName moduleName) {
        BundleModule module = (BundleModule)this.modules.get((Object)moduleName);
        if (module == null) {
            throw new CommandExecutionException("Module '%s' not found.", moduleName);
        }
        return module;
    }

    public Manifest.BundleManifest getBundleManifest() {
        return this.bundleManifest;
    }

    public void writeTo(Path pathOnDisk) throws IOException {
        ZipBuilder zipBuilder = new ZipBuilder();
        zipBuilder.addFileWithProtoContent(Paths.get(BUNDLE_MANIFEST_FILE_NAME, new String[0]), (MessageLite)this.bundleManifest, new OutputBuilder.EntryOption[0]);
        for (BundleModule module : this.modules.values()) {
            for (ModuleEntry entry : module.getEntries()) {
                Path entryPath = Paths.get(module.getName().toString(), new String[0]).resolve(entry.getPath());
                if (entry.isDirectory()) {
                    zipBuilder.addDirectory(entryPath);
                    continue;
                }
                zipBuilder.addFile(entryPath, () -> entry.getContent(), new OutputBuilder.EntryOption[0]);
            }
        }
        zipBuilder.writeTo(pathOnDisk);
    }

    private static Map<BundleModuleName, BundleModule> extractModules(ZipFile bundleFile) {
        HashMap<BundleModuleName, BundleModule.Builder> moduleBuilders = new HashMap<BundleModuleName, BundleModule.Builder>();
        Enumeration<? extends ZipEntry> entries = bundleFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            Path path = Paths.get(entry.getName(), new String[0]);
            if (path.startsWith("META-INF") || path.getNameCount() <= 1) continue;
            BundleModuleName moduleName = BundleModuleName.create(path.getName(0).toString());
            BundleModule.Builder moduleBuilder = moduleBuilders.computeIfAbsent(moduleName, name -> BundleModule.builder().setName((BundleModuleName)name));
            moduleBuilder.addEntry(ModuleZipEntry.fromBundleZipEntry(entry, bundleFile));
        }
        return Maps.transformValues(moduleBuilders, BundleModule.Builder::build);
    }

    private static Manifest.BundleManifest readBundleManifest(ZipFile bundleFile) {
        ZipEntry manifestEntry = bundleFile.getEntry(BUNDLE_MANIFEST_FILE_NAME);
        if (manifestEntry == null) {
            throw new ValidationException("Bundle manifest '%s' not found.", BUNDLE_MANIFEST_FILE_NAME);
        }
        try {
            return Manifest.BundleManifest.parseFrom(bundleFile.getInputStream(manifestEntry));
        }
        catch (InvalidProtocolBufferException e) {
            throw new ValidationException(e, "Bundle manifest '%s' could not be parsed.", BUNDLE_MANIFEST_FILE_NAME);
        }
        catch (IOException e) {
            throw new CommandExecutionException("Error reading file '%s'.", BUNDLE_MANIFEST_FILE_NAME);
        }
    }
}

