/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.manifest;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.exceptions.ValidationException;
import com.android.tools.build.bundletool.manifest.AutoValue_AndroidManifest;
import com.android.tools.build.bundletool.manifest.ManifestEditor;
import com.android.tools.build.bundletool.manifest.ProtoXmlHelper;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;

@AutoValue
public abstract class AndroidManifest {
    public static final String ANDROID_NAMESPACE = "http://schemas.android.com/apk/res/android";
    public static final String GL_VERSION_ATTRIBUTE_NAME = "glEsVersion";
    public static final String SUPPORTS_GL_TEXTURE_ELEMENT_NAME = "supports-gl-texture";
    public static final String USES_FEATURE_ELEMENT_NAME = "uses-feature";
    public static final String USES_SDK_ELEMENT_NAME = "uses-sdk";
    public static final String DYNAMIC_MODULE_ATTRIBUTE_NAME = "dynamic";
    public static final String MIN_SDK_VERSION_ATTRIBUTE_NAME = "minSdkVersion";
    public static final String MAX_SDK_VERSION_ATTRIBUTE_NAME = "maxSdkVersion";

    public abstract Resources.XmlNode getManifestRoot();

    public static AndroidManifest create(Resources.XmlNode manifestRoot) {
        return new AutoValue_AndroidManifest(manifestRoot);
    }

    public Optional<Integer> getMinSdkVersion() {
        return this.getUsesSdkAttribute(MIN_SDK_VERSION_ATTRIBUTE_NAME);
    }

    public Optional<Integer> getMaxSdkVersion() {
        return this.getUsesSdkAttribute(MAX_SDK_VERSION_ATTRIBUTE_NAME);
    }

    private Optional<Integer> getUsesSdkAttribute(String attributeName) {
        Optional<Resources.XmlElement> usesSdkElement = ProtoXmlHelper.getFirstElement(this.getManifestRoot(), USES_SDK_ELEMENT_NAME);
        if (!usesSdkElement.isPresent()) {
            return Optional.empty();
        }
        Optional<Resources.XmlAttribute> attribute = ProtoXmlHelper.findAttribute(usesSdkElement.get(), ANDROID_NAMESPACE, attributeName);
        if (!attribute.isPresent()) {
            return Optional.empty();
        }
        int attributeType = attribute.get().getCompiledItem().getPrim().getType();
        Preconditions.checkState((attributeType == 16 ? 1 : 0) != 0, (String)"Type of the compiled item is expected to be decimal integer, found %s.", (int)attributeType);
        return attribute.map(attr -> attr.getCompiledItem().getPrim().getData());
    }

    public Optional<String> getSplitId() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        return ProtoXmlHelper.findAttributeWithName(manifest, "split").map(Resources.XmlAttribute::getValue);
    }

    public Collection<String> getUsesSplits() {
        return (Collection)ProtoXmlHelper.findElements(this.getManifestRoot(), "uses-split").map(elem -> ProtoXmlHelper.findAttribute(elem, ANDROID_NAMESPACE, "name").orElseThrow(() -> new ValidationException("<uses-split> element is missing the android:name attribute", new Object[0]))).map(Resources.XmlAttribute::getValue).collect(ImmutableList.toImmutableList());
    }

    public boolean isDynamicModule() {
        Resources.XmlElement manifest = ProtoXmlHelper.getExactlyOneElement(this.getManifestRoot(), "manifest");
        Optional<Resources.XmlAttribute> dynamicNode = ProtoXmlHelper.findAttributeWithName(manifest, DYNAMIC_MODULE_ATTRIBUTE_NAME);
        if (!dynamicNode.isPresent()) {
            return false;
        }
        return ProtoXmlHelper.getAttributeValueAsBoolean(dynamicNode.get());
    }

    public ManifestEditor toEditor() {
        return new ManifestEditor(this.getManifestRoot());
    }
}

