/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.tools.build.bundletool.AutoValue_LinkCommand;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipBuilder;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Path;

@AutoValue
public abstract class LinkCommand {
    public static final String COMMAND_NAME = "link";
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<ImmutableList<Path>> SPLITS_FLAG = Flag.paths("splits");

    public abstract Path getOutputPath();

    public abstract ImmutableList<Path> getSplitPaths();

    public static Builder builder() {
        return new AutoValue_LinkCommand.Builder();
    }

    public static LinkCommand fromFlags(ParsedFlags flags) {
        Builder builder = LinkCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setSplitPaths(SPLITS_FLAG.getRequiredValue(flags));
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public void execute() {
        this.validateInput();
        ZipBuilder zipBuilder = new ZipBuilder();
        for (Path split : this.getSplitPaths()) {
            zipBuilder.addFileFromDisk(split.getFileName(), split, new OutputBuilder.EntryOption[0]);
        }
        try {
            zipBuilder.writeTo(this.getOutputPath());
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error linking APKs into a zip file: %s", e);
        }
    }

    private void validateInput() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        this.getSplitPaths().forEach(split -> FilePreconditions.checkFileHasExtension("Split APK", split, ".apk"));
        FilePreconditions.checkFileNamesAreUnique("Split APKs", this.getSplitPaths());
        this.getSplitPaths().forEach(FilePreconditions::checkFileExistsAndReadable);
    }

    public static void help() {
        System.out.println(String.format("bundletool %s --%s=<path/to/selected/splits.zip> [--%s=<path/to/split1.apk,path/to/split2.apk...>] ", COMMAND_NAME, OUTPUT_FLAG, SPLITS_FLAG));
        System.out.println();
        System.out.println("Links together selected splits into a zip file.");
        System.out.println();
        System.out.println("--output: Path to the zip file to build.");
        System.out.printf("--%s: The list of split APKs to add to the final zip\n", SPLITS_FLAG);
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setSplitPaths(ImmutableList<Path> var1);

        public abstract LinkCommand build();
    }
}

