/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool;

import com.android.bundle.Files;
import com.android.bundle.Manifest;
import com.android.tools.build.bundletool.AutoValue_BuildBundleCommand;
import com.android.tools.build.bundletool.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.utils.files.FilePreconditions;
import com.android.tools.build.bundletool.utils.files.TargetingGenerator;
import com.android.tools.build.bundletool.utils.flags.Flag;
import com.android.tools.build.bundletool.utils.flags.ParsedFlags;
import com.android.tools.build.bundletool.utils.zip.OutputBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipBuilder;
import com.android.tools.build.bundletool.utils.zip.ZipUtils;
import com.android.tools.build.bundletool.validation.BundleModulesValidator;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.io.MoreFiles;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Optional;
import java.util.zip.ZipFile;

@AutoValue
public abstract class BuildBundleCommand {
    public static final String COMMAND_NAME = "build-bundle";
    private static final Flag<Path> OUTPUT_FLAG = Flag.path("output");
    private static final Flag<ImmutableList<Path>> MODULES_FLAG = Flag.paths("modules");

    public abstract Path getOutputPath();

    public abstract ImmutableList<Path> getModulesPaths();

    public abstract Optional<Path> getBundleConfigPath();

    public static Builder builder() {
        return new AutoValue_BuildBundleCommand.Builder();
    }

    public static BuildBundleCommand fromFlags(ParsedFlags flags) {
        Builder builder = BuildBundleCommand.builder().setOutputPath(OUTPUT_FLAG.getRequiredValue(flags)).setModulesPaths(MODULES_FLAG.getRequiredValue(flags));
        flags.checkNoUnknownFlags();
        return builder.build();
    }

    public void execute() {
        this.validateInput();
        try {
            ZipBuilder bundleBuilder = new ZipBuilder();
            for (Path module : this.getModulesPaths()) {
                Optional<Files.Assets> assetsTargeting;
                Path moduleDir = Paths.get(MoreFiles.getNameWithoutExtension((Path)module), new String[0]);
                ZipFile moduleZipFile = new ZipFile(module.toFile());
                bundleBuilder.copyAllContentsFromZip(moduleDir, new ZipFile(module.toFile()));
                Optional<Files.NativeLibraries> nativeLibrariesTargeting = this.generateNativeLibrariesTargeting(moduleZipFile);
                if (nativeLibrariesTargeting.isPresent()) {
                    bundleBuilder.addFileWithProtoContent(moduleDir.resolve("native.pb"), (MessageLite)nativeLibrariesTargeting.get(), new OutputBuilder.EntryOption[0]);
                }
                if (!(assetsTargeting = this.generateAssetsTargeting(moduleZipFile)).isPresent()) continue;
                bundleBuilder.addFileWithProtoContent(moduleDir.resolve("assets.pb"), (MessageLite)assetsTargeting.get(), new OutputBuilder.EntryOption[0]);
            }
            Manifest.BundleManifest bundleManifest = Manifest.BundleManifest.newBuilder().setBundletoolVersion(1).build();
            bundleBuilder.addFileWithContent(Paths.get("BundleManifest.pb", new String[0]), bundleManifest.toByteArray(), new OutputBuilder.EntryOption[0]);
            ((OutputBuilder)bundleBuilder).writeTo(this.getOutputPath());
        }
        catch (IOException e) {
            throw new CommandExecutionException(e, "Error building the bundle: %s", e);
        }
    }

    private void validateInput() {
        FilePreconditions.checkFileDoesNotExist(this.getOutputPath());
        new BundleModulesValidator().validate(this.getModulesPaths());
    }

    private Optional<Files.Assets> generateAssetsTargeting(ZipFile module) {
        ImmutableList assetDirectories = (ImmutableList)ZipUtils.getFilesWithPathPrefix(module, Paths.get("assets", new String[0])).filter(path -> path.getNameCount() > 2).map(Path::toString).distinct().collect(ImmutableList.toImmutableList());
        if (assetDirectories.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForAssets((Collection<String>)assetDirectories));
    }

    private Optional<Files.NativeLibraries> generateNativeLibrariesTargeting(ZipFile module) {
        ImmutableList libAbiDirs = (ImmutableList)ZipUtils.getFilesWithPathPrefix(module, Paths.get("lib", new String[0])).filter(path -> path.getNameCount() > 2).map(path -> path.subpath(0, 2)).map(Path::toString).distinct().collect(ImmutableList.toImmutableList());
        if (libAbiDirs.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new TargetingGenerator().generateTargetingForNativeLibraries((Collection<String>)libAbiDirs));
    }

    public static void help() {
        System.out.printf("bundletool %s --%s=<path/to/bundle.zip> --%s=<path/to/module1.zip,path/to/module2.zip,...> ", COMMAND_NAME, OUTPUT_FLAG, MODULES_FLAG);
        System.out.println();
        System.out.printf("Builds a bundle as a zip from a set of modules. Note that the resources and the AndroidManifest.xml must already have been compiled with aapt2 and the module created with the bundletool.\n", new Object[0]);
        System.out.printf("--output: Path to the zip file to build.\n", new Object[0]);
        System.out.printf("--%s: The list of module files to build the final bundle from.\n", MODULES_FLAG);
    }

    public static abstract class Builder {
        public abstract Builder setOutputPath(Path var1);

        public abstract Builder setModulesPaths(ImmutableList<Path> var1);

        public abstract Builder setBundleConfigPath(Path var1);

        public abstract BuildBundleCommand build();
    }
}

