/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.files;

import com.android.builder.files.DirectoryEntry;
import com.android.builder.files.KeyedFileCache;
import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.ZipCentralDirectory;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.IOExceptionRunnable;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closer;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class IncrementalRelativeFileSets {
    private IncrementalRelativeFileSets() {
    }

    @Deprecated
    public static ImmutableMap<RelativeFile, FileStatus> fromDirectory(File directory) {
        Preconditions.checkArgument((boolean)directory.isDirectory(), (Object)"!directory.isDirectory()");
        return ImmutableMap.copyOf((Map)Maps.asMap(RelativeFiles.fromDirectory(directory), (Function)Functions.constant((Object)FileStatus.NEW)));
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip) throws IOException {
        return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(File zip, FileStatus status) throws IOException {
        Preconditions.checkArgument((boolean)zip.isFile(), (String)"!zip.isFile(): %s", (Object)zip);
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZip(new ZipCentralDirectory(zip)), f11 -> status)).build();
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(ZipCentralDirectory zip) throws IOException {
        return IncrementalRelativeFileSets.fromZip(zip, FileStatus.NEW);
    }

    public static ImmutableMap<RelativeFile, FileStatus> fromZip(ZipCentralDirectory zip, FileStatus status) throws IOException {
        return ImmutableMap.builder().putAll(Maps.asMap(RelativeFiles.fromZip(zip), f11 -> status)).build();
    }

    public static Map<RelativeFile, FileStatus> fromZip(ZipCentralDirectory zipCentralDirectory, KeyedFileCache cache, Set<Runnable> cacheUpdates) throws IOException {
        File zipFile = zipCentralDirectory.getFile();
        File oldFile = cache.get(zipFile);
        if (oldFile == null) {
            if (!zipFile.isFile()) {
                return ImmutableMap.of();
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.add(zipCentralDirectory)));
            return IncrementalRelativeFileSets.fromZip(zipCentralDirectory, FileStatus.NEW);
        }
        if (!zipFile.isFile()) {
            ZipCentralDirectory oldCdr = new ZipCentralDirectory(oldFile);
            Collection<DirectoryEntry> entries2 = oldCdr.getEntries().values();
            HashMap map = Maps.newHashMapWithExpectedSize((int)entries2.size());
            for (DirectoryEntry entry : entries2) {
                map.put(new RelativeFile(zipFile, entry.getName()), FileStatus.REMOVED);
            }
            cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.remove(zipFile)));
            return Collections.unmodifiableMap(map);
        }
        HashMap result = Maps.newHashMap();
        try (Closer closer = Closer.create();){
            String path;
            Map<String, DirectoryEntry> newEntries = zipCentralDirectory.getEntries();
            Map<String, DirectoryEntry> oldEntries = new ZipCentralDirectory(oldFile).getEntries();
            for (DirectoryEntry entry : newEntries.values()) {
                path = entry.getName();
                RelativeFile newRelative = new RelativeFile(zipFile, path);
                DirectoryEntry oldEntry = oldEntries.get(path);
                if (oldEntry == null) {
                    result.put(newRelative, FileStatus.NEW);
                    continue;
                }
                if (oldEntry.getCrc32() == entry.getCrc32() && oldEntry.getSize() == entry.getSize()) continue;
                result.put(newRelative, FileStatus.CHANGED);
            }
            for (DirectoryEntry entry : oldEntries.values()) {
                path = entry.getName();
                RelativeFile oldRelative = new RelativeFile(zipFile, path);
                DirectoryEntry newEntry = newEntries.get(path);
                if (newEntry != null) continue;
                result.put(oldRelative, FileStatus.REMOVED);
            }
        }
        cacheUpdates.add(IOExceptionRunnable.asRunnable(() -> cache.add(zipCentralDirectory)));
        return Collections.unmodifiableMap(result);
    }
}

