/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.files.RelativeFile;
import com.android.builder.files.RelativeFiles;
import com.android.builder.files.ZipCentralDirectory;
import com.android.builder.merge.DuplicatePathInIncrementalInputException;
import com.android.builder.merge.LazyIncrementalFileMergerInput;
import com.android.ide.common.resources.FileStatus;
import com.android.tools.build.apkzlib.utils.CachedSupplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class LazyIncrementalFileMergerInputs {
    private LazyIncrementalFileMergerInputs() {
    }

    public static LazyIncrementalFileMergerInput fromNew(String name, Set<File> base) {
        ImmutableSet baseI = ImmutableSet.copyOf(base);
        CachedSupplier all = new CachedSupplier(() -> LazyIncrementalFileMergerInputs.load((Set<File>)baseI));
        CachedSupplier upd = new CachedSupplier(() -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ((Set)all.get()).forEach(rf2 -> builder.put(rf2, (Object)FileStatus.NEW));
            return builder.build();
        });
        return new LazyIncrementalFileMergerInput(name, (CachedSupplier<Map<RelativeFile, FileStatus>>)upd, (CachedSupplier<Set<RelativeFile>>)all);
    }

    private static ImmutableSet<RelativeFile> load(Set<File> base) {
        HashSet<String> paths = new HashSet<String>();
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File b10 : base) {
            Set<RelativeFile> files;
            if (b10.isFile()) {
                try {
                    files = RelativeFiles.fromZip(new ZipCentralDirectory(b10));
                }
                catch (IOException e10) {
                    throw new UncheckedIOException(e10);
                }
            } else if (b10.isDirectory()) {
                files = RelativeFiles.fromDirectory(b10);
            } else {
                throw new AssertionError();
            }
            for (RelativeFile rf2 : files) {
                String p10 = rf2.getRelativePath();
                if (paths.add(p10)) continue;
                throw new DuplicatePathInIncrementalInputException("Duplicate relative path '" + p10 + "'");
            }
            builder.addAll(files);
        }
        return builder.build();
    }
}

