/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.signing;

import com.android.builder.model.SigningConfig;
import com.google.common.base.MoreObjects;
import java.io.File;
import java.security.KeyStore;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b&\u0018\u0000 92\u00020\u0001:\u00029:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u00102\u001a\u00020\n2\b\u00103\u001a\u0004\u0018\u000104H\u0096\u0002J\b\u00105\u001a\u00020\u0003H\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u0010\"\u001a\u00020\u00002\b\u0010 \u001a\u0004\u0018\u00010\u0003J\u0010\u0010%\u001a\u00020\u00002\b\u0010#\u001a\u0004\u0018\u00010\u0003J\u0010\u0010*\u001a\u00020\u00002\b\u0010'\u001a\u0004\u0018\u00010&J\u0010\u0010.\u001a\u00020\u00002\b\u0010,\u001a\u0004\u0018\u00010\u0003J\u0010\u00101\u001a\u00020\u00002\b\u0010/\u001a\u0004\u0018\u00010\u0003J\b\u00108\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u00a4\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0004R\u001a\u0010\t\u001a\u0004\u0018\u00010\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u0004\u0018\u00010\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u0004\u0018\u00010\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u0004\u0018\u00010\nX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u0014\u0010\u0018\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R$\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0019\"\u0004\b\u001c\u0010\u001dR$\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0019\"\u0004\b\u001f\u0010\u001dR\u001a\u0010 \u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0007\"\u0004\b\"\u0010\u0004R\u001a\u0010#\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u0007\"\u0004\b%\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010'\u001a\u0004\u0018\u00010&2\b\u0010\u001a\u001a\u0004\u0018\u00010&8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\u0007\"\u0004\b.\u0010\u0004R\u001a\u0010/\u001a\u0004\u0018\u00010\u0003X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b0\u0010\u0007\"\u0004\b1\u0010\u0004\u00a8\u0006;"}, d2={"Lcom/android/builder/signing/DefaultSigningConfig;", "Lcom/android/builder/model/SigningConfig;", "mName", "", "(Ljava/lang/String;)V", "_storeFilePath", "get_storeFilePath", "()Ljava/lang/String;", "set_storeFilePath", "enableV1Signing", "", "getEnableV1Signing", "()Ljava/lang/Boolean;", "setEnableV1Signing", "(Ljava/lang/Boolean;)V", "enableV2Signing", "getEnableV2Signing", "setEnableV2Signing", "enableV3Signing", "getEnableV3Signing", "setEnableV3Signing", "enableV4Signing", "getEnableV4Signing", "setEnableV4Signing", "isSigningReady", "()Z", "value", "isV1SigningEnabled", "setV1SigningEnabled", "(Z)V", "isV2SigningEnabled", "setV2SigningEnabled", "keyAlias", "getKeyAlias", "setKeyAlias", "keyPassword", "getKeyPassword", "setKeyPassword", "Ljava/io/File;", "storeFile", "getStoreFile", "()Ljava/io/File;", "setStoreFile", "(Ljava/io/File;)V", "storePassword", "getStorePassword", "setStorePassword", "storeType", "getStoreType", "setStoreType", "equals", "other", "", "getName", "hashCode", "", "toString", "Companion", "DebugSigningConfig", "builder"})
public abstract class DefaultSigningConfig
implements SigningConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mName;
    private boolean isV1SigningEnabled;
    private boolean isV2SigningEnabled;
    @NotNull
    public static final String DEFAULT_PASSWORD = "android";
    @NotNull
    public static final String DEFAULT_ALIAS = "AndroidDebugKey";

    public DefaultSigningConfig(@NotNull String mName) {
        Intrinsics.checkNotNullParameter((Object)mName, (String)"mName");
        this.mName = mName;
        this.isV1SigningEnabled = true;
        this.isV2SigningEnabled = true;
    }

    @Nullable
    protected abstract String get_storeFilePath();

    protected abstract void set_storeFilePath(@Nullable String var1);

    @Nullable
    public File getStoreFile() {
        File file;
        String string = this.get_storeFilePath();
        if (string == null) {
            file = null;
        } else {
            String string2 = string;
            boolean bl2 = false;
            boolean bl3 = false;
            String it2 = string2;
            boolean bl4 = false;
            file = new File(it2);
        }
        return file;
    }

    public void setStoreFile(@Nullable File value) {
        File file = value;
        this.set_storeFilePath(file == null ? null : file.getPath());
    }

    @Nullable
    public abstract String getStorePassword();

    public abstract void setStorePassword(@Nullable String var1);

    @Nullable
    public abstract String getKeyAlias();

    public abstract void setKeyAlias(@Nullable String var1);

    @Nullable
    public abstract String getKeyPassword();

    public abstract void setKeyPassword(@Nullable String var1);

    @Nullable
    public abstract String getStoreType();

    public abstract void setStoreType(@Nullable String var1);

    public boolean isV1SigningEnabled() {
        return this.isV1SigningEnabled;
    }

    public void setV1SigningEnabled(boolean value) {
        this.setEnableV1Signing(value);
        this.isV1SigningEnabled = value;
    }

    public boolean isV2SigningEnabled() {
        return this.isV2SigningEnabled;
    }

    public void setV2SigningEnabled(boolean value) {
        this.setEnableV2Signing(value);
        this.isV2SigningEnabled = value;
    }

    @Nullable
    public abstract Boolean getEnableV1Signing();

    public abstract void setEnableV1Signing(@Nullable Boolean var1);

    @Nullable
    public abstract Boolean getEnableV2Signing();

    public abstract void setEnableV2Signing(@Nullable Boolean var1);

    @Nullable
    public abstract Boolean getEnableV3Signing();

    public abstract void setEnableV3Signing(@Nullable Boolean var1);

    @Nullable
    public abstract Boolean getEnableV4Signing();

    public abstract void setEnableV4Signing(@Nullable Boolean var1);

    public boolean isSigningReady() {
        return this.getStoreFile() != null && this.getStorePassword() != null && this.getKeyAlias() != null && this.getKeyPassword() != null;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    @NotNull
    public final DefaultSigningConfig setStoreFile(@Nullable File storeFile) {
        this.setStoreFile(storeFile);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setStorePassword(@Nullable String storePassword) {
        this.setStorePassword(storePassword);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setKeyAlias(@Nullable String keyAlias) {
        this.setKeyAlias(keyAlias);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setKeyPassword(@Nullable String keyPassword) {
        this.setKeyPassword(keyPassword);
        return this;
    }

    @NotNull
    public final DefaultSigningConfig setStoreType(@Nullable String storeType) {
        this.setStoreType(storeType);
        return this;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        DefaultSigningConfig that = (DefaultSigningConfig)other;
        if (!Intrinsics.areEqual((Object)this.getKeyAlias(), (Object)that.getKeyAlias())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getKeyPassword(), (Object)that.getKeyPassword())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStoreFile(), (Object)that.getStoreFile())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStorePassword(), (Object)that.getStorePassword())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getStoreType(), (Object)that.getStoreType())) {
            return false;
        }
        if (this.isV1SigningEnabled() != that.isV1SigningEnabled()) {
            return false;
        }
        if (this.isV2SigningEnabled() != that.isV2SigningEnabled()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getEnableV1Signing(), (Object)that.getEnableV1Signing())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getEnableV2Signing(), (Object)that.getEnableV2Signing())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getEnableV3Signing(), (Object)that.getEnableV3Signing())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getEnableV4Signing(), (Object)that.getEnableV4Signing());
    }

    public int hashCode() {
        int n12;
        int result = super.hashCode();
        Object object = this.getStoreFile();
        result = 31 * result + (object == null ? 0 : (n12 = ((File)object).hashCode()));
        object = this.getStorePassword();
        result = 31 * result + (object == null ? 0 : (n12 = ((String)object).hashCode()));
        object = this.getKeyAlias();
        result = 31 * result + (object == null ? 0 : (n12 = ((String)object).hashCode()));
        object = this.getKeyPassword();
        result = 31 * result + (object == null ? 0 : (n12 = ((String)object).hashCode()));
        object = this.getStoreType();
        result = 31 * result + (object == null ? 0 : (n12 = ((String)object).hashCode()));
        result = 31 * result + (this.isV1SigningEnabled() ? 17 : 0);
        result = 31 * result + (this.isV2SigningEnabled() ? 17 : 0);
        object = this.getEnableV1Signing();
        result = 31 * result + (object == null ? 0 : (n12 = object.hashCode()));
        object = this.getEnableV2Signing();
        result = 31 * result + (object == null ? 0 : (n12 = object.hashCode()));
        object = this.getEnableV3Signing();
        result = 31 * result + (object == null ? 0 : (n12 = object.hashCode()));
        object = this.getEnableV4Signing();
        result = 31 * result + (object == null ? 0 : (n12 = object.hashCode()));
        return result;
    }

    @NotNull
    public String toString() {
        File file;
        String string = MoreObjects.toStringHelper((Object)this).add("storeFile", (Object)((file = this.getStoreFile()) == null ? null : file.getAbsolutePath())).add("storePassword", (Object)this.getStorePassword()).add("keyAlias", (Object)this.getKeyAlias()).add("keyPassword", (Object)this.getKeyPassword()).add("storeType", (Object)this.getStoreType()).add("v1SigningEnabled", this.isV1SigningEnabled()).add("v2SigningEnabled", this.isV2SigningEnabled()).add("enableV1Signing", (Object)this.getEnableV1Signing()).add("enableV2Signing", (Object)this.getEnableV2Signing()).add("enableV3Signing", (Object)this.getEnableV3Signing()).add("enableV4Signing", (Object)this.getEnableV4Signing()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toStringHelper(this)\n            .add(\"storeFile\", storeFile?.absolutePath)\n            .add(\"storePassword\", storePassword)\n            .add(\"keyAlias\", keyAlias)\n            .add(\"keyPassword\", keyPassword)\n            .add(\"storeType\", storeType)\n            .add(\"v1SigningEnabled\", isV1SigningEnabled)\n            .add(\"v2SigningEnabled\", isV2SigningEnabled)\n            .add(\"enableV1Signing\", enableV1Signing)\n            .add(\"enableV2Signing\", enableV2Signing)\n            .add(\"enableV3Signing\", enableV3Signing)\n            .add(\"enableV4Signing\", enableV4Signing)\n            .toString()");
        return string;
    }

    @JvmStatic
    @NotNull
    public static final DebugSigningConfig debugSigningConfig(@NotNull File storeFile) {
        return Companion.debugSigningConfig(storeFile);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/builder/signing/DefaultSigningConfig$Companion;", "", "()V", "DEFAULT_ALIAS", "", "DEFAULT_PASSWORD", "debugSigningConfig", "Lcom/android/builder/signing/DefaultSigningConfig$DebugSigningConfig;", "storeFile", "Ljava/io/File;", "builder"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DebugSigningConfig debugSigningConfig(@NotNull File storeFile) {
            Intrinsics.checkNotNullParameter((Object)storeFile, (String)"storeFile");
            return new DebugSigningConfig(storeFile);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/android/builder/signing/DefaultSigningConfig$DebugSigningConfig;", "", "storeFile", "Ljava/io/File;", "(Ljava/io/File;)V", "keyAlias", "", "getKeyAlias", "()Ljava/lang/String;", "keyPassword", "getKeyPassword", "getStoreFile", "()Ljava/io/File;", "storePassword", "getStorePassword", "storeType", "getStoreType", "copyToSigningConfig", "", "other", "Lcom/android/builder/signing/DefaultSigningConfig;", "builder"})
    public static final class DebugSigningConfig {
        @NotNull
        private final File storeFile;

        public DebugSigningConfig(@NotNull File storeFile) {
            Intrinsics.checkNotNullParameter((Object)storeFile, (String)"storeFile");
            this.storeFile = storeFile;
        }

        @NotNull
        public final File getStoreFile() {
            return this.storeFile;
        }

        @NotNull
        public final String getStorePassword() {
            return DefaultSigningConfig.DEFAULT_PASSWORD;
        }

        @NotNull
        public final String getKeyAlias() {
            return DefaultSigningConfig.DEFAULT_ALIAS;
        }

        @NotNull
        public final String getKeyPassword() {
            return DefaultSigningConfig.DEFAULT_PASSWORD;
        }

        @NotNull
        public final String getStoreType() {
            String string = KeyStore.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDefaultType()");
            return string;
        }

        public final void copyToSigningConfig(@NotNull DefaultSigningConfig other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            other.setStoreFile(this.storeFile);
            other.setStorePassword(this.getStorePassword());
            other.setKeyAlias(this.getKeyAlias());
            other.setKeyPassword(this.getKeyPassword());
            other.setStoreType(this.getStoreType());
        }
    }
}

