/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.utils;

import java.io.File;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006\u001a\u000e\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"isValidZipEntryName", "", "entry", "Ljava/util/zip/ZipEntry;", "isValidZipEntryPath", "filePath", "Ljava/io/File;", "outputDir", "zipEntry", "name", "", "builder"})
@JvmName(name="ZipEntryUtils")
public final class ZipEntryUtils {
    public static final boolean isValidZipEntryName(@NotNull ZipEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        String string = entry.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"entry.name");
        return !StringsKt.contains$default((CharSequence)string, (CharSequence)"../", (boolean)false, (int)2, null);
    }

    public static final boolean isValidZipEntryPath(@NotNull File filePath, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        String string = filePath.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filePath.canonicalPath");
        return StringsKt.startsWith$default((String)string, (String)Intrinsics.stringPlus((String)outputDir.getCanonicalPath(), (Object)File.separator), (boolean)false, (int)2, null);
    }

    @NotNull
    public static final ZipEntry zipEntry(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ZipEntry zipEntry = new ZipEntry(name);
        boolean bl2 = false;
        boolean bl3 = false;
        ZipEntry $this$zipEntry_u24lambda_u2d0 = zipEntry;
        boolean bl4 = false;
        $this$zipEntry_u24lambda_u2d0.setTime(-1L);
        return zipEntry;
    }
}

