/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.compiler;

import com.android.builder.compiling.DependencyFileProcessor;
import com.android.builder.internal.incremental.DependencyData;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.process.ProcessResult;
import com.android.repository.io.FileOpUtils;
import com.android.utils.FileUtils;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AidlProcessor {
    public static void call(String aidlExecutable, String frameworkLocation, Iterable<File> importFolders, File sourceOutputDir, File packagedOutputDir, Collection<String> packagedList, DependencyFileProcessor dependencyFileProcessor, ProcessExecutor processExecutor, ProcessOutputHandler processOutputHandler, Path startDir, Path inputFilePath) throws IOException {
        Object nonNullPackagedList = packagedList == null ? ImmutableSet.of() : Collections.unmodifiableSet(Sets.newHashSet(packagedList));
        ProcessInfoBuilder builder = new ProcessInfoBuilder();
        builder.setExecutable(aidlExecutable);
        builder.addArgs("-p" + frameworkLocation);
        builder.addArgs("-o" + sourceOutputDir.getAbsolutePath());
        for (File f10 : importFolders) {
            builder.addArgs("-I" + f10.getAbsolutePath());
        }
        File depFile = File.createTempFile("aidl", ".d");
        builder.addArgs("-d" + depFile.getAbsolutePath());
        builder.addArgs(inputFilePath.toAbsolutePath().toString());
        ProcessResult result = processExecutor.execute(builder.createProcess(), processOutputHandler);
        try {
            result.rethrowFailure().assertNormalExitValue();
        }
        catch (ProcessException pe2) {
            throw new IOException(pe2);
        }
        String relativeInputFile = FileUtils.toSystemIndependentPath((String)FileOpUtils.makeRelative((File)startDir.toFile(), (File)inputFilePath.toFile()));
        DependencyData data = dependencyFileProcessor.processFile(depFile);
        if (data != null) {
            boolean isParcelable = true;
            List<String> outputFiles = data.getOutputFiles();
            if (!outputFiles.isEmpty()) {
                for (String path : outputFiles) {
                    List outputFileContent = Files.readLines((File)new File(path), (Charset)StandardCharsets.UTF_8);
                    String emptyFileLine = "// This file is intentionally left blank as placeholder for parcel declaration.";
                    if (outputFileContent.size() <= 2 && ((String)outputFileContent.get(0)).equals(emptyFileLine)) {
                        FileUtils.delete((File)new File(path));
                        continue;
                    }
                    isParcelable = false;
                }
            }
            boolean isPackaged = nonNullPackagedList.contains(relativeInputFile);
            if (packagedOutputDir != null && (isParcelable || isPackaged)) {
                File destFile = new File(packagedOutputDir, relativeInputFile);
                destFile.getParentFile().mkdirs();
                Files.copy((File)inputFilePath.toFile(), (File)destFile);
                data.addSecondaryOutputFile(destFile.getPath());
            }
        }
        FileUtils.delete((File)depFile);
    }
}

