/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.dexing;

import com.android.builder.dexing.ClassFileEntry;
import com.android.builder.dexing.ClassFileInput;
import com.android.builder.dexing.NoCacheJarClassFileEntry;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

final class JarClassFileInput
implements ClassFileInput {
    private final Path rootPath;
    private ZipFile jarFile;

    public JarClassFileInput(Path rootPath) {
        this.rootPath = rootPath;
    }

    @Override
    public void close() throws IOException {
        if (this.jarFile != null) {
            this.jarFile.close();
        }
    }

    @Override
    public Stream<ClassFileEntry> entries(BiPredicate<Path, String> filter) {
        if (this.jarFile == null) {
            try {
                this.jarFile = new ZipFile(this.rootPath.toFile());
            }
            catch (IOException e5) {
                throw new JarClassFileInputsException("Unable to read jar file " + this.rootPath.toString(), e5);
            }
        }
        ArrayList<ZipEntry> entryList = new ArrayList<ZipEntry>(this.jarFile.size());
        Enumeration<? extends ZipEntry> entries2 = this.jarFile.entries();
        while (entries2.hasMoreElements()) {
            ZipEntry zipEntry = entries2.nextElement();
            if (!CLASS_MATCHER.test(zipEntry.getName()) || !filter.test(this.rootPath, zipEntry.getName())) continue;
            entryList.add(zipEntry);
        }
        return entryList.stream().map(this::createEntryFromEntry);
    }

    @Override
    public Path getPath() {
        return this.rootPath;
    }

    private ClassFileEntry createEntryFromEntry(ZipEntry entry) {
        return new NoCacheJarClassFileEntry(entry, Objects.requireNonNull(this.jarFile), this);
    }

    public static final class JarClassFileInputsException
    extends RuntimeException {
        public JarClassFileInputsException(String s4, IOException e5) {
            super(s4, e5);
        }
    }
}

