/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

import com.android.dex.util.ByteInput;
import java.io.UTFDataFormatException;

public final class Mutf8 {
    private Mutf8() {
    }

    public static String decode(ByteInput in, char[] out) throws UTFDataFormatException {
        int s4 = 0;
        while (true) {
            int b4;
            char a4;
            if ((a4 = (char)(in.readByte() & 0xFF)) == '\u0000') {
                return new String(out, 0, s4);
            }
            out[s4] = a4;
            if (a4 < '\u0080') {
                ++s4;
                continue;
            }
            if ((a4 & 0xE0) == 192) {
                b4 = in.readByte() & 0xFF;
                if ((b4 & 0xC0) != 128) {
                    throw new UTFDataFormatException("bad second byte");
                }
                out[s4++] = (char)((a4 & 0x1F) << 6 | b4 & 0x3F);
                continue;
            }
            if ((a4 & 0xF0) != 224) break;
            b4 = in.readByte() & 0xFF;
            int c4 = in.readByte() & 0xFF;
            if ((b4 & 0xC0) != 128 || (c4 & 0xC0) != 128) {
                throw new UTFDataFormatException("bad second or third byte");
            }
            out[s4++] = (char)((a4 & 0xF) << 12 | (b4 & 0x3F) << 6 | c4 & 0x3F);
        }
        throw new UTFDataFormatException("bad byte");
    }

    private static long countBytes(String s4, boolean shortLength) throws UTFDataFormatException {
        long result = 0L;
        int length = s4.length();
        for (int i4 = 0; i4 < length; ++i4) {
            char ch = s4.charAt(i4);
            result = ch != '\u0000' && ch <= '\u007f' ? ++result : (ch <= '\u07ff' ? (result += 2L) : (result += 3L));
            if (!shortLength || result <= 65535L) continue;
            throw new UTFDataFormatException("String more than 65535 UTF bytes long");
        }
        return result;
    }

    public static void encode(byte[] dst, int offset, String s4) {
        int length = s4.length();
        for (int i4 = 0; i4 < length; ++i4) {
            char ch = s4.charAt(i4);
            if (ch != '\u0000' && ch <= '\u007f') {
                dst[offset++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[offset++] = (byte)(0xC0 | 0x1F & ch >> 6);
                dst[offset++] = (byte)(0x80 | 0x3F & ch);
                continue;
            }
            dst[offset++] = (byte)(0xE0 | 0xF & ch >> 12);
            dst[offset++] = (byte)(0x80 | 0x3F & ch >> 6);
            dst[offset++] = (byte)(0x80 | 0x3F & ch);
        }
    }

    public static byte[] encode(String s4) throws UTFDataFormatException {
        int utfCount = (int)Mutf8.countBytes(s4, true);
        byte[] result = new byte[utfCount];
        Mutf8.encode(result, 0, s4);
        return result;
    }
}

