/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.utils;

import java.util.ListIterator;
import java.util.function.Predicate;

public class IteratorUtils {
    public static <T> T peekPrevious(ListIterator<T> iterator2) {
        T previous = iterator2.previous();
        T next = iterator2.next();
        assert (previous == next);
        return previous;
    }

    public static <T> T peekNext(ListIterator<T> iterator2) {
        T next = iterator2.next();
        T previous = iterator2.previous();
        assert (previous == next);
        return next;
    }

    public static <T> boolean allRemainingMatch(ListIterator<T> iterator2, Predicate<T> predicate) {
        return !IteratorUtils.anyRemainingMatch(iterator2, remaining -> !predicate.test(remaining));
    }

    public static <T> boolean anyRemainingMatch(ListIterator<T> iterator2, Predicate<T> predicate) {
        T state = IteratorUtils.peekNext(iterator2);
        boolean result = false;
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.test(item)) continue;
            result = true;
            break;
        }
        while (iterator2.hasPrevious() && iterator2.previous() != state) {
        }
        assert (IteratorUtils.peekNext(iterator2) == state);
        return result;
    }
}

