/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.merge;

import com.android.builder.merge.IncrementalFileMergerInput;
import com.android.builder.merge.IncrementalFileMergerOutput;
import com.android.builder.merge.IncrementalFileMergerState;
import com.android.builder.merge.OpenableCloseable;
import com.android.ide.common.resources.FileStatus;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public final class IncrementalFileMerger {
    private IncrementalFileMerger() {
    }

    public static IncrementalFileMergerState merge(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output, IncrementalFileMergerState state) {
        IncrementalFileMergerState.Builder newState = new IncrementalFileMergerState.Builder(state);
        newState.setInputNames((List<String>)IncrementalFileMerger.getInputNames(inputs));
        List inputNames = inputs.stream().map(IncrementalFileMergerInput::getName).collect(Collectors.toList());
        output.open();
        inputs.forEach(OpenableCloseable::open);
        if (inputNames.equals(state.getInputNames())) {
            IncrementalFileMerger.mergeNoChangedInputs(inputs, output, state, newState);
        } else {
            IncrementalFileMerger.mergeChangedInputs(inputs, output, state, newState);
        }
        inputs.forEach(OpenableCloseable::close);
        output.close();
        return newState.build();
    }

    private static void mergeNoChangedInputs(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output, IncrementalFileMergerState state, IncrementalFileMergerState.Builder newState) {
        HashSet impactedPaths = new HashSet();
        inputs.forEach(i -> impactedPaths.addAll(i.getUpdatedPaths()));
        for (String path : impactedPaths) {
            ImmutableList<String> prevInputNames = state.inputsFor(path);
            List<IncrementalFileMergerInput> inputsForFile = IncrementalFileMerger.getInputsForFile(path, inputs, state);
            IncrementalFileMerger.updateChangedFile(inputsForFile, prevInputNames, output, path, newState);
        }
    }

    private static void mergeChangedInputs(List<IncrementalFileMergerInput> inputs, IncrementalFileMergerOutput output, IncrementalFileMergerState state, IncrementalFileMergerState.Builder newState) {
        ArrayList<String> allNames = new ArrayList<String>((Collection<String>)state.getInputNames());
        List<String> newInputNameList = inputs.stream().map(IncrementalFileMergerInput::getName).peek(n -> {
            if (!allNames.contains(n)) {
                allNames.add((String)n);
            }
        }).collect(Collectors.toList());
        newState.setInputNames(allNames);
        HashSet maybeImpactedPaths = new HashSet();
        state.getInputNames().forEach(n -> maybeImpactedPaths.addAll(state.filesOf((String)n)));
        inputs.forEach(i -> maybeImpactedPaths.addAll(i.getUpdatedPaths()));
        for (String path : maybeImpactedPaths) {
            ImmutableList<String> prevInputNames = state.inputsFor(path);
            List<IncrementalFileMergerInput> inputsForFile = IncrementalFileMerger.getInputsForFile(path, inputs, state);
            boolean changed = false;
            if (prevInputNames.size() != inputsForFile.size()) {
                changed = true;
            }
            for (int i2 = 0; !changed && i2 < prevInputNames.size(); ++i2) {
                if (((String)prevInputNames.get(i2)).equals(inputsForFile.get(i2).getName())) continue;
                changed = true;
            }
            if (!changed && inputsForFile.stream().anyMatch(i -> i.getFileStatus(path) != null)) {
                changed = true;
            }
            if (!changed) continue;
            IncrementalFileMerger.updateChangedFile(inputsForFile, prevInputNames, output, path, newState);
        }
        newState.setInputNames(newInputNameList);
    }

    private static void updateChangedFile(List<IncrementalFileMergerInput> inputsForFile, ImmutableList<String> prevInputNames, IncrementalFileMergerOutput output, String path, IncrementalFileMergerState.Builder newState) {
        if (inputsForFile.isEmpty()) {
            output.remove(path);
            newState.remove(path);
        } else if (prevInputNames.isEmpty()) {
            output.create(path, (List<IncrementalFileMergerInput>)ImmutableList.copyOf(inputsForFile));
            newState.set(path, (List<String>)IncrementalFileMerger.getInputNames(inputsForFile));
        } else {
            output.update(path, (List<String>)prevInputNames, (List<IncrementalFileMergerInput>)ImmutableList.copyOf(inputsForFile));
            newState.set(path, (List<String>)IncrementalFileMerger.getInputNames(inputsForFile));
        }
    }

    private static List<IncrementalFileMergerInput> getInputsForFile(String path, List<IncrementalFileMergerInput> inputs, IncrementalFileMergerState state) {
        ImmutableList<String> prevInputNames = state.inputsFor(path);
        return inputs.stream().filter(i -> {
            FileStatus status = i.getFileStatus(path);
            if (status == null) {
                return prevInputNames.contains(i.getName());
            }
            return status != FileStatus.REMOVED;
        }).collect(Collectors.toList());
    }

    private static ImmutableList<String> getInputNames(List<IncrementalFileMergerInput> inputs) {
        ImmutableList.Builder builder = ImmutableList.builder();
        inputs.forEach(i -> builder.add((Object)i.getName()));
        return builder.build();
    }
}

