/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal;

import com.android.builder.model.ClassField;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Set;

public final class ClassFieldImpl
implements ClassField,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String name;
    private final String value;

    public ClassFieldImpl(String type, String name, String value) {
        if (type == null || name == null || value == null) {
            throw new NullPointerException("Build Config field cannot have a null parameter");
        }
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public ClassFieldImpl(ClassField classField) {
        this(classField.getType(), classField.getName(), classField.getValue());
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDocumentation() {
        return "";
    }

    public Set<String> getAnnotations() {
        return ImmutableSet.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassFieldImpl that = (ClassFieldImpl)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        return this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

