/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.code;

import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.InternalCompilerError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.MemberType;
import com.android.tools.r8.ir.code.NumericType;

public final class ValueType
extends Enum<ValueType> {
    public static final /* enum */ ValueType OBJECT = new ValueType();
    public static final /* enum */ ValueType INT = new ValueType();
    public static final /* enum */ ValueType FLOAT = new ValueType();
    public static final /* enum */ ValueType INT_OR_FLOAT = new ValueType();
    public static final /* enum */ ValueType INT_OR_FLOAT_OR_NULL = new ValueType();
    public static final /* enum */ ValueType LONG = new ValueType();
    public static final /* enum */ ValueType DOUBLE = new ValueType();
    public static final /* enum */ ValueType LONG_OR_DOUBLE = new ValueType();
    private static final /* synthetic */ ValueType[] $VALUES;

    public static ValueType[] values() {
        return (ValueType[])$VALUES.clone();
    }

    public static ValueType valueOf(String name) {
        return Enum.valueOf(ValueType.class, name);
    }

    public boolean isObject() {
        return this == OBJECT;
    }

    public boolean isSingle() {
        return this == INT || this == FLOAT || this == INT_OR_FLOAT;
    }

    public boolean isWide() {
        return this == LONG || this == DOUBLE || this == LONG_OR_DOUBLE;
    }

    public boolean isObjectOrSingle() {
        return !this.isWide();
    }

    public boolean isPreciseType() {
        return this != INT_OR_FLOAT && this != LONG_OR_DOUBLE && this != INT_OR_FLOAT_OR_NULL;
    }

    public ValueType meet(ValueType other) {
        if (this == other) {
            return this;
        }
        if (other == INT_OR_FLOAT_OR_NULL) {
            return other.meet(this);
        }
        switch (this) {
            case OBJECT: {
                if (!other.isObject()) break;
                return this;
            }
            case INT: 
            case FLOAT: {
                if (!other.isSingle()) break;
                return this;
            }
            case LONG: 
            case DOUBLE: {
                if (!other.isWide()) break;
                return this;
            }
            case INT_OR_FLOAT_OR_NULL: {
                if (!other.isObjectOrSingle()) break;
                return other;
            }
            case INT_OR_FLOAT: {
                if (!other.isSingle()) break;
                return other;
            }
            case LONG_OR_DOUBLE: {
                if (!other.isWide()) break;
                return other;
            }
            default: {
                throw new Unreachable("Unexpected value-type in meet: " + (Object)((Object)this));
            }
        }
        throw new CompilationError("Cannot compute meet of types: " + (Object)((Object)this) + " and " + (Object)((Object)other));
    }

    public boolean verifyCompatible(ValueType other) {
        assert (this.meet(other) != null);
        return true;
    }

    public int requiredRegisters() {
        return this.isWide() ? 2 : 1;
    }

    public static ValueType fromMemberType(MemberType type) {
        switch (type) {
            case BOOLEAN: 
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT_OR_FLOAT: {
                return INT_OR_FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case LONG_OR_DOUBLE: {
                return LONG_OR_DOUBLE;
            }
            case OBJECT: {
                return OBJECT;
            }
        }
        throw new Unreachable("Unexpected member type: " + (Object)((Object)type));
    }

    public static ValueType fromTypeDescriptorChar(char descriptor) {
        switch (descriptor) {
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'J': {
                return LONG;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'V': {
                throw new InternalCompilerError("No value type for void type.");
            }
        }
        throw new Unreachable("Invalid descriptor char '" + descriptor + "'");
    }

    public static ValueType fromDexType(DexType type) {
        return ValueType.fromTypeDescriptorChar((char)type.descriptor.content[0]);
    }

    public static ValueType fromNumericType(NumericType type) {
        switch (type) {
            case BYTE: 
            case CHAR: 
            case SHORT: 
            case INT: {
                return INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case LONG: {
                return LONG;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new Unreachable("Invalid numeric type '" + (Object)((Object)type) + "'");
    }

    static {
        $VALUES = new ValueType[]{OBJECT, INT, FLOAT, INT_OR_FLOAT, INT_OR_FLOAT_OR_NULL, LONG, DOUBLE, LONG_OR_DOUBLE};
    }
}

