/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.org.objectweb.asm.ClassWriter;

public class InnerClassAttribute {
    private final int access;
    private final DexType inner;
    private final DexType outer;
    private final DexString innerName;

    public static InnerClassAttribute createUnknownNamedInnerClass(DexType inner, DexType outer) {
        return new InnerClassAttribute(0, inner, outer, DexItemFactory.unknownTypeName);
    }

    public InnerClassAttribute(int access, DexType inner, DexType outer, DexString innerName) {
        assert (inner != null);
        this.access = access;
        this.inner = inner;
        this.outer = outer;
        this.innerName = innerName;
    }

    public boolean isNamed() {
        return this.innerName != null;
    }

    public boolean isAnonymous() {
        return this.innerName == null;
    }

    public int getAccess() {
        return this.access;
    }

    public DexType getInner() {
        return this.inner;
    }

    public DexType getOuter() {
        return this.outer;
    }

    public DexString getInnerName() {
        return this.innerName;
    }

    public void write(ClassWriter writer, NamingLens lens) {
        String internalName = lens.lookupInternalName(this.inner);
        String simpleName = lens.lookupSimpleName(this.inner, this.innerName);
        writer.visitInnerClass(internalName, this.outer == null ? null : lens.lookupInternalName(this.outer), this.innerName == null ? null : simpleName, this.access);
    }

    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.inner.collectIndexedItems(indexedItems);
        if (this.outer != null) {
            this.outer.collectIndexedItems(indexedItems);
        }
        if (this.innerName != null) {
            this.innerName.collectIndexedItems(indexedItems);
        }
    }
}

