/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.dex;

import com.android.tools.r8.DataDirectoryResource;
import com.android.tools.r8.DataEntryResource;
import com.android.tools.r8.DataResourceConsumer;
import com.android.tools.r8.DataResourceProvider;
import com.android.tools.r8.DexIndexedConsumer;
import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.ProgramResourceProvider;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.collect.ObjectArrays;
import com.android.tools.r8.dex.FileWriter;
import com.android.tools.r8.dex.Marker;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.dex.VirtualFile;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationDirectory;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexApplication;
import com.android.tools.r8.graph.DexCode;
import com.android.tools.r8.graph.DexDebugInfo;
import com.android.tools.r8.graph.DexEncodedArray;
import com.android.tools.r8.graph.DexProgramClass;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.graph.ParameterAnnotationsList;
import com.android.tools.r8.naming.NamingLens;
import com.android.tools.r8.naming.ProguardMapSupplier;
import com.android.tools.r8.utils.DescriptorUtils;
import com.android.tools.r8.utils.ExceptionUtils;
import com.android.tools.r8.utils.InternalOptions;
import com.android.tools.r8.utils.ThreadUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

public class ApplicationWriter {
    public final DexApplication application;
    public final String deadCode;
    public final NamingLens namingLens;
    public final String proguardSeedsData;
    public final InternalOptions options;
    public List<DexString> markerStrings;
    public DexIndexedConsumer programConsumer;
    public final ProguardMapSupplier proguardMapSupplier;

    public ApplicationWriter(DexApplication application, InternalOptions options, List<Marker> markers, String deadCode, NamingLens namingLens, String proguardSeedsData, ProguardMapSupplier proguardMapSupplier) {
        this(application, options, markers, deadCode, namingLens, proguardSeedsData, proguardMapSupplier, null);
    }

    public ApplicationWriter(DexApplication application, InternalOptions options, List<Marker> markers, String deadCode, NamingLens namingLens, String proguardSeedsData, ProguardMapSupplier proguardMapSupplier, DexIndexedConsumer consumer) {
        assert (application != null);
        this.application = application;
        assert (options != null);
        this.options = options;
        if (markers != null && !markers.isEmpty()) {
            this.markerStrings = new ArrayList<DexString>();
            for (Marker marker : markers) {
                this.markerStrings.add(application.dexItemFactory.createString(marker.toString()));
            }
        }
        this.deadCode = deadCode;
        this.namingLens = namingLens;
        this.proguardSeedsData = proguardSeedsData;
        this.proguardMapSupplier = proguardMapSupplier;
        this.programConsumer = consumer;
    }

    private Iterable<VirtualFile> distribute(ExecutorService executorService) throws ExecutionException, IOException {
        VirtualFile.Distributor distributor = this.options.isGeneratingDexFilePerClassFile() ? new VirtualFile.FilePerInputClassDistributor(this) : (!this.options.canUseMultidex() && this.options.mainDexKeepRules.isEmpty() && this.application.mainDexList.isEmpty() && this.options.enableMainDexListCheck ? new VirtualFile.MonoDexDistributor(this, this.options) : new VirtualFile.FillFilesDistributor(this, this.options, executorService));
        return ((VirtualFile.Distributor)distributor).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(ExecutorService executorService) throws IOException, ExecutionException {
        this.application.timing.begin("DexApplication.write");
        try {
            this.insertAttributeAnnotations();
            this.application.dexItemFactory.sort(this.namingLens);
            assert (this.markerStrings == null || this.markerStrings.isEmpty() || this.application.dexItemFactory.extractMarker() != null);
            SortAnnotations sortAnnotations = new SortAnnotations();
            this.application.classes().forEach(clazz -> clazz.addDependencies(sortAnnotations));
            LinkedHashMap<VirtualFile, Future<ObjectToOffsetMapping>> offsetMappingFutures = new LinkedHashMap<VirtualFile, Future<ObjectToOffsetMapping>>();
            for (VirtualFile virtualFile : this.distribute(executorService)) {
                if (virtualFile.isEmpty()) continue;
                offsetMappingFutures.put(virtualFile, executorService.submit(() -> {
                    ObjectToOffsetMapping mapping = virtualFile.computeMapping(this.application);
                    this.rewriteCodeWithJumboStrings(mapping, virtualFile.classes(), this.application);
                    return mapping;
                }));
            }
            ThreadUtils.awaitFutures(offsetMappingFutures.values());
            ArrayList<Future<Boolean>> dexDataFutures = new ArrayList<Future<Boolean>>();
            try {
                for (VirtualFile virtualFile : offsetMappingFutures.keySet()) {
                    assert (!virtualFile.isEmpty());
                    ObjectToOffsetMapping mapping = (ObjectToOffsetMapping)((Future)offsetMappingFutures.get(virtualFile)).get();
                    dexDataFutures.add(executorService.submit(() -> {
                        byte[] result = this.writeDexFile(mapping);
                        if (this.programConsumer != null) {
                            this.programConsumer.accept(virtualFile.getId(), result, virtualFile.getClassDescriptors(), this.options.reporter);
                        } else if (virtualFile.getPrimaryClassDescriptor() != null) {
                            this.options.getDexFilePerClassFileConsumer().accept(virtualFile.getPrimaryClassDescriptor(), result, virtualFile.getClassDescriptors(), this.options.reporter);
                        } else {
                            this.options.getDexIndexedConsumer().accept(virtualFile.getId(), result, virtualFile.getClassDescriptors(), this.options.reporter);
                        }
                        return true;
                    }));
                }
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException("Interrupted while waiting for future.", interruptedException);
            }
            offsetMappingFutures.clear();
            ThreadUtils.awaitFutures(dexDataFutures);
            this.options.reporter.failIfPendingErrors();
            ApplicationWriter.supplyAdditionalConsumers(this.application, this.namingLens, this.options, this.deadCode, this.proguardMapSupplier, this.proguardSeedsData);
        }
        finally {
            this.application.timing.end();
        }
    }

    public static void supplyAdditionalConsumers(DexApplication application, NamingLens namingLens, final InternalOptions options, String deadCode, ProguardMapSupplier proguardMapSupplier, String proguardSeedsData) {
        DataResourceConsumer dataResourceConsumer;
        if (options.configurationConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.configurationConsumer, options.proguardConfiguration.getParsedConfiguration());
        }
        if (options.usageInformationConsumer != null && deadCode != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.usageInformationConsumer, deadCode);
        }
        if (proguardMapSupplier != null && options.proguardMapConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.proguardMapConsumer, proguardMapSupplier.get());
        }
        if (options.proguardSeedsConsumer != null && proguardSeedsData != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.proguardSeedsConsumer, proguardSeedsData);
        }
        if (options.mainDexListConsumer != null) {
            ExceptionUtils.withConsumeResourceHandler(options.reporter, options.mainDexListConsumer, ApplicationWriter.writeMainDexList(application, namingLens));
        }
        if ((dataResourceConsumer = options.dataResourceConsumer) != null) {
            List dataResourceProviders = application.programResourceProviders.stream().map(ProgramResourceProvider::getDataResourceProvider).filter(Objects::nonNull).collect(Collectors.toList());
            for (DataResourceProvider dataResourceProvider : dataResourceProviders) {
                try {
                    dataResourceProvider.accept(new DataResourceProvider.Visitor(){

                        @Override
                        public void visit(DataDirectoryResource directory) {
                            dataResourceConsumer.accept(directory, (DiagnosticsHandler)options.reporter);
                            options.reporter.failIfPendingErrors();
                        }

                        @Override
                        public void visit(DataEntryResource file) {
                            dataResourceConsumer.accept(file, (DiagnosticsHandler)options.reporter);
                            options.reporter.failIfPendingErrors();
                        }
                    });
                }
                catch (ResourceException e) {
                    throw new CompilationError(e.getMessage(), e);
                }
            }
        }
    }

    private void insertAttributeAnnotations() {
        for (DexProgramClass clazz : this.application.classes()) {
            EnclosingMethodAttribute enclosingMethod = clazz.getEnclosingMethod();
            List<InnerClassAttribute> innerClasses = clazz.getInnerClasses();
            if (enclosingMethod == null && innerClasses.isEmpty()) continue;
            ArrayList<DexAnnotation> annotations = new ArrayList<DexAnnotation>(1 + innerClasses.size());
            if (enclosingMethod != null) {
                if (enclosingMethod.getEnclosingMethod() != null) {
                    annotations.add(DexAnnotation.createEnclosingMethodAnnotation(enclosingMethod.getEnclosingMethod(), this.options.itemFactory));
                } else {
                    annotations.add(DexAnnotation.createEnclosingClassAnnotation(enclosingMethod.getEnclosingClass(), this.options.itemFactory));
                }
            }
            if (!innerClasses.isEmpty()) {
                ArrayList<DexType> memberClasses = new ArrayList<DexType>(innerClasses.size());
                for (InnerClassAttribute innerClass : innerClasses) {
                    if (clazz.type == innerClass.getInner()) {
                        if (enclosingMethod == null && (innerClass.getOuter() == null || innerClass.isAnonymous())) {
                            this.options.warningMissingEnclosingMember(clazz.type, clazz.origin, clazz.getClassFileVersion());
                            continue;
                        }
                        annotations.add(DexAnnotation.createInnerClassAnnotation(innerClass.getInnerName(), innerClass.getAccess(), this.options.itemFactory));
                        if (innerClass.getOuter() == null || !innerClass.isNamed()) continue;
                        annotations.add(DexAnnotation.createEnclosingClassAnnotation(innerClass.getOuter(), this.options.itemFactory));
                        continue;
                    }
                    if (clazz.type != innerClass.getOuter() || !innerClass.isNamed()) continue;
                    memberClasses.add(innerClass.getInner());
                }
                if (!memberClasses.isEmpty()) {
                    annotations.add(DexAnnotation.createMemberClassesAnnotation(memberClasses, this.options.itemFactory));
                }
            }
            if (!annotations.isEmpty()) {
                DexAnnotation[] copy = ObjectArrays.concat(clazz.annotations.annotations, annotations.toArray(new DexAnnotation[annotations.size()]), DexAnnotation.class);
                clazz.annotations = new DexAnnotationSet(copy);
            }
            clazz.clearEnclosingMethod();
            clazz.clearInnerClasses();
        }
    }

    private void rewriteCodeWithJumboStrings(ObjectToOffsetMapping mapping, Collection<DexProgramClass> classes, DexApplication application) {
        if (!this.options.testing.forceJumboStringProcessing) {
            if (!mapping.hasJumboStrings()) {
                return;
            }
            if (application.highestSortingString != null && application.highestSortingString.slowCompareTo(mapping.getFirstJumboString()) < 0) {
                return;
            }
        }
        for (DexProgramClass clazz : classes) {
            clazz.forEachMethod(method -> method.rewriteCodeWithJumboStrings(mapping, application, this.options.testing.forceJumboStringProcessing));
        }
    }

    private byte[] writeDexFile(ObjectToOffsetMapping mapping) {
        FileWriter fileWriter = new FileWriter(mapping, this.application, this.options, this.namingLens);
        fileWriter.collect();
        return fileWriter.generate();
    }

    private static String mapMainDexListName(DexType type, NamingLens namingLens) {
        return DescriptorUtils.descriptorToJavaType(namingLens.lookupDescriptor(type).toString()).replace('.', '/') + ".class";
    }

    private static String writeMainDexList(DexApplication application, NamingLens namingLens) {
        StringBuilder builder = new StringBuilder();
        application.mainDexList.forEach(type -> builder.append(ApplicationWriter.mapMainDexListName(type, namingLens)).append('\n'));
        return builder.toString();
    }

    private static class SortAnnotations
    extends MixedSectionCollection {
        private SortAnnotations() {
        }

        @Override
        public boolean add(DexAnnotationSet dexAnnotationSet) {
            dexAnnotationSet.sort();
            return true;
        }

        @Override
        public boolean add(DexAnnotation annotation) {
            annotation.annotation.sort();
            return true;
        }

        @Override
        public boolean add(DexEncodedArray dexEncodedArray) {
            for (DexValue value : dexEncodedArray.values) {
                value.sort();
            }
            return true;
        }

        @Override
        public boolean add(DexProgramClass dexClassData) {
            return true;
        }

        @Override
        public boolean add(DexCode dexCode) {
            return true;
        }

        @Override
        public boolean add(DexDebugInfo dexDebugInfo) {
            return true;
        }

        @Override
        public boolean add(DexTypeList dexTypeList) {
            return true;
        }

        @Override
        public boolean add(ParameterAnnotationsList parameterAnnotationsList) {
            return true;
        }

        @Override
        public boolean setAnnotationsDirectoryForClass(DexProgramClass clazz, DexAnnotationDirectory annotationDirectory) {
            return true;
        }
    }
}

