/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.errors.CompilationError;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.ClassAccessFlags;
import com.android.tools.r8.graph.ClassKind;
import com.android.tools.r8.graph.DexAnnotation;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexAnnotationSet;
import com.android.tools.r8.graph.DexAnnotationSetRefList;
import com.android.tools.r8.graph.DexClass;
import com.android.tools.r8.graph.DexEncodedAnnotation;
import com.android.tools.r8.graph.DexEncodedField;
import com.android.tools.r8.graph.DexEncodedMethod;
import com.android.tools.r8.graph.DexField;
import com.android.tools.r8.graph.DexItemFactory;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.graph.DexString;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.graph.DexTypeList;
import com.android.tools.r8.graph.DexValue;
import com.android.tools.r8.graph.EnclosingMethodAttribute;
import com.android.tools.r8.graph.FieldAccessFlags;
import com.android.tools.r8.graph.InnerClassAttribute;
import com.android.tools.r8.graph.JarApplicationReader;
import com.android.tools.r8.graph.JarCode;
import com.android.tools.r8.graph.MethodAccessFlags;
import com.android.tools.r8.org.objectweb.asm.AnnotationVisitor;
import com.android.tools.r8.org.objectweb.asm.Attribute;
import com.android.tools.r8.org.objectweb.asm.ClassReader;
import com.android.tools.r8.org.objectweb.asm.ClassVisitor;
import com.android.tools.r8.org.objectweb.asm.FieldVisitor;
import com.android.tools.r8.org.objectweb.asm.Label;
import com.android.tools.r8.org.objectweb.asm.MethodVisitor;
import com.android.tools.r8.org.objectweb.asm.Type;
import com.android.tools.r8.org.objectweb.asm.TypePath;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.utils.InternalOptions;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class JarClassFileReader {
    private static final int ACC_SYNTHETIC_ATTRIBUTE = 262144;
    private final JarApplicationReader application;
    private final Consumer<DexClass> classConsumer;

    public JarClassFileReader(JarApplicationReader application, Consumer<DexClass> classConsumer) {
        this.application = application;
        this.classConsumer = classConsumer;
    }

    public void read(Origin origin, ClassKind classKind, InputStream input) throws IOException {
        ClassReader reader = new ClassReader(input);
        reader.accept(new CreateDexClassVisitor(origin, classKind, reader.b, this.application, this.classConsumer), 4);
    }

    private static int cleanAccessFlags(int access) {
        return access & 0xFFFBFFFF & 0xFFFDFFFF;
    }

    public static MethodAccessFlags createMethodAccessFlags(String name, int access) {
        boolean isConstructor = name.equals("<init>") || name.equals("<clinit>");
        return MethodAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access), isConstructor);
    }

    private static AnnotationVisitor createAnnotationVisitor(String desc, boolean visible, List<DexAnnotation> annotations, JarApplicationReader application) {
        assert (annotations != null);
        int visiblity = visible ? 1 : 0;
        return new CreateAnnotationVisitor(application, (names, values) -> annotations.add(new DexAnnotation(visiblity, JarClassFileReader.createEncodedAnnotation(desc, names, values, application))));
    }

    private static DexEncodedAnnotation createEncodedAnnotation(String desc, List<DexString> names, List<DexValue> values, JarApplicationReader application) {
        assert (names == null && values.isEmpty() || names != null && !names.isEmpty() && names.size() == values.size());
        DexAnnotationElement[] elements = new DexAnnotationElement[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            elements[i] = new DexAnnotationElement(names.get(i), values.get(i));
        }
        return new DexEncodedAnnotation(application.getTypeFromDescriptor(desc), elements);
    }

    private static DexAnnotationSet createAnnotationSet(List<DexAnnotation> annotations) {
        return annotations == null || annotations.isEmpty() ? DexAnnotationSet.empty() : new DexAnnotationSet(annotations.toArray(new DexAnnotation[annotations.size()]));
    }

    private static class CreateAnnotationVisitor
    extends AnnotationVisitor {
        private final JarApplicationReader application;
        private final BiConsumer<List<DexString>, List<DexValue>> onVisitEnd;
        private List<DexString> names = null;
        private final List<DexValue> values = new ArrayList<DexValue>();

        public CreateAnnotationVisitor(JarApplicationReader application, BiConsumer<List<DexString>, List<DexValue>> onVisitEnd) {
            super(393216);
            this.application = application;
            this.onVisitEnd = onVisitEnd;
        }

        @Override
        public void visit(String name, Object value) {
            this.addElement(name, this.getDexValue(value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            DexType owner = this.application.getTypeFromDescriptor(desc);
            this.addElement(name, new DexValue.DexValueEnum(this.application.getField(owner, value, desc)));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new CreateAnnotationVisitor(this.application, (names, values) -> this.addElement(name, new DexValue.DexValueAnnotation(JarClassFileReader.createEncodedAnnotation(desc, names, values, this.application))));
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new CreateAnnotationVisitor(this.application, (names, values) -> {
                assert (names == null);
                this.addElement(name, new DexValue.DexValueArray(values.toArray(new DexValue[values.size()])));
            });
        }

        @Override
        public void visitEnd() {
            this.onVisitEnd.accept(this.names, this.values);
        }

        private void addElement(String name, DexValue value) {
            if (name != null) {
                if (this.names == null) {
                    this.names = new ArrayList<DexString>();
                }
                this.names.add(this.application.getString(name));
            }
            this.values.add(value);
        }

        private static DexValue.DexValueArray getDexValueArray(Object value) {
            if (value instanceof byte[]) {
                byte[] values = (byte[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueByte.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof boolean[]) {
                boolean[] values = (boolean[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueBoolean.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof char[]) {
                char[] values = (char[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueChar.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof short[]) {
                short[] values = (short[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueShort.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof int[]) {
                int[] values = (int[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueInt.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof long[]) {
                long[] values = (long[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueLong.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof float[]) {
                float[] values = (float[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueFloat.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            if (value instanceof double[]) {
                double[] values = (double[])value;
                DexValue[] elements = new DexValue[values.length];
                for (int i = 0; i < values.length; ++i) {
                    elements[i] = DexValue.DexValueDouble.create(values[i]);
                }
                return new DexValue.DexValueArray(elements);
            }
            throw new Unreachable("Unexpected type of annotation value: " + value);
        }

        private DexValue getDexValue(Object value) {
            if (value == null) {
                return DexValue.DexValueNull.NULL;
            }
            if (value instanceof Byte) {
                return DexValue.DexValueByte.create((Byte)value);
            }
            if (value instanceof Boolean) {
                return DexValue.DexValueBoolean.create((Boolean)value);
            }
            if (value instanceof Character) {
                return DexValue.DexValueChar.create(((Character)value).charValue());
            }
            if (value instanceof Short) {
                return DexValue.DexValueShort.create((Short)value);
            }
            if (value instanceof Integer) {
                return DexValue.DexValueInt.create((Integer)value);
            }
            if (value instanceof Long) {
                return DexValue.DexValueLong.create((Long)value);
            }
            if (value instanceof Float) {
                return DexValue.DexValueFloat.create(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return DexValue.DexValueDouble.create((Double)value);
            }
            if (value instanceof String) {
                return new DexValue.DexValueString(this.application.getString((String)value));
            }
            if (value instanceof Type) {
                return new DexValue.DexValueType(this.application.getTypeFromDescriptor(((Type)value).getDescriptor()));
            }
            return CreateAnnotationVisitor.getDexValueArray(value);
        }
    }

    private static class CreateMethodVisitor
    extends MethodVisitor {
        private final int access;
        private final String name;
        private final String desc;
        private final CreateDexClassVisitor parent;
        private final int parameterCount;
        private List<DexAnnotation> annotations = null;
        private DexValue defaultAnnotation = null;
        private int fakeParameterAnnotations = 0;
        private List<List<DexAnnotation>> parameterAnnotations = null;
        private List<DexValue> parameterNames = null;
        private List<DexValue> parameterFlags = null;

        public CreateMethodVisitor(int access, String name, String desc, String signature, String[] exceptions, CreateDexClassVisitor parent) {
            super(393216);
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.parent = parent;
            this.parameterCount = JarApplicationReader.getArgumentCount(desc);
            if (exceptions != null && exceptions.length > 0) {
                DexValue[] values = new DexValue[exceptions.length];
                for (int i = 0; i < exceptions.length; ++i) {
                    values[i] = new DexValue.DexValueType(parent.application.getTypeFromName(exceptions[i]));
                }
                this.addAnnotation(DexAnnotation.createThrowsAnnotation(values, parent.application.getFactory()));
            }
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, parent.application.getFactory()));
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new CreateAnnotationVisitor(this.parent.application, (names, elements) -> {
                assert (elements.size() == 1);
                this.defaultAnnotation = (DexValue)elements.get(0);
            });
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            if (desc.equals("Ljava/lang/Synthetic;")) {
                if (this.parameterAnnotations == null) {
                    ++this.fakeParameterAnnotations;
                }
                return null;
            }
            if (this.parameterAnnotations == null) {
                int adjustedParameterCount = this.parameterCount - this.fakeParameterAnnotations;
                this.parameterAnnotations = new ArrayList<List<DexAnnotation>>(adjustedParameterCount);
                for (int i = 0; i < adjustedParameterCount; ++i) {
                    this.parameterAnnotations.add(new ArrayList());
                }
            }
            assert (this.mv == null);
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.parameterAnnotations.get(parameter - this.fakeParameterAnnotations), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, Label[] start, Label[] end, int[] index, String desc, boolean visible) {
            return null;
        }

        @Override
        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitParameter(String name, int access) {
            if (this.parameterNames == null) {
                assert (this.parameterFlags == null);
                this.parameterNames = new ArrayList<DexValue>(this.parameterCount);
                this.parameterFlags = new ArrayList<DexValue>(this.parameterCount);
            }
            this.parameterNames.add(new DexValue.DexValueString(this.parent.application.getFactory().createString(name)));
            this.parameterFlags.add(DexValue.DexValueInt.create(access));
            super.visitParameter(name, access);
        }

        @Override
        public void visitEnd() {
            DexAnnotationSetRefList parameterAnnotationSets;
            DexMethod method = this.parent.application.getMethod(this.parent.type, this.name, this.desc);
            MethodAccessFlags flags = JarClassFileReader.createMethodAccessFlags(this.name, this.access);
            JarCode code = null;
            if (!flags.isAbstract() && !flags.isNative() && this.parent.classKind == ClassKind.PROGRAM) {
                code = new JarCode(method, this.parent.origin, this.parent.context, this.parent.application);
            }
            if (this.parameterAnnotations == null) {
                parameterAnnotationSets = DexAnnotationSetRefList.empty();
            } else {
                DexAnnotationSet[] sets = new DexAnnotationSet[this.parameterAnnotations.size()];
                for (int i = 0; i < this.parameterAnnotations.size(); ++i) {
                    sets[i] = JarClassFileReader.createAnnotationSet(this.parameterAnnotations.get(i));
                }
                parameterAnnotationSets = new DexAnnotationSetRefList(sets);
            }
            InternalOptions internalOptions = ((CreateDexClassVisitor)this.parent).application.options;
            if (this.parameterNames != null && internalOptions.canUseParameterNameAnnotations()) {
                assert (this.parameterFlags != null);
                if (this.parameterNames.size() != this.parameterCount) {
                    internalOptions.warningInvalidParameterAnnotations(method, this.parent.origin, this.parameterCount, this.parameterNames.size());
                }
                this.getAnnotations().add(DexAnnotation.createMethodParametersAnnotation(this.parameterNames.toArray(new DexValue[this.parameterNames.size()]), this.parameterFlags.toArray(new DexValue[this.parameterFlags.size()]), this.parent.application.getFactory()));
            }
            DexEncodedMethod dexMethod = new DexEncodedMethod(method, flags, JarClassFileReader.createAnnotationSet(this.annotations), parameterAnnotationSets, code);
            if (flags.isStatic() || flags.isConstructor() || flags.isPrivate()) {
                this.parent.directMethods.add(dexMethod);
            } else {
                this.parent.virtualMethods.add(dexMethod);
            }
            if (this.defaultAnnotation != null) {
                this.parent.addDefaultAnnotation(this.name, this.defaultAnnotation);
            }
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }
    }

    private static class CreateFieldVisitor
    extends FieldVisitor {
        private final CreateDexClassVisitor parent;
        private final int access;
        private final String name;
        private final String desc;
        private final Object value;
        private List<DexAnnotation> annotations = null;

        public CreateFieldVisitor(CreateDexClassVisitor parent, int access, String name, String desc, String signature, Object value) {
            super(393216);
            this.parent = parent;
            this.access = access;
            this.name = name;
            this.desc = desc;
            this.value = value;
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, parent.application.getFactory()));
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.parent.application);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitEnd() {
            FieldAccessFlags flags = FieldAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(this.access));
            DexField dexField = this.parent.application.getField(this.parent.type, this.name, this.desc);
            DexAnnotationSet annotationSet = JarClassFileReader.createAnnotationSet(this.annotations);
            DexValue staticValue = flags.isStatic() ? this.getStaticValue(this.value, dexField.type) : null;
            DexEncodedField field = new DexEncodedField(dexField, flags, annotationSet, staticValue);
            if (flags.isStatic()) {
                this.parent.staticFields.add(field);
            } else {
                this.parent.instanceFields.add(field);
            }
        }

        private DexValue getStaticValue(Object value, DexType type) {
            if (value == null) {
                return DexValue.defaultForType(type, this.parent.application.getFactory());
            }
            DexItemFactory factory = this.parent.application.getFactory();
            if (type == factory.booleanType) {
                int i = (Integer)value;
                assert (0 <= i && i <= 1);
                return DexValue.DexValueBoolean.create(i == 1);
            }
            if (type == factory.byteType) {
                return DexValue.DexValueByte.create(((Integer)value).byteValue());
            }
            if (type == factory.shortType) {
                return DexValue.DexValueShort.create(((Integer)value).shortValue());
            }
            if (type == factory.charType) {
                return DexValue.DexValueChar.create((char)((Integer)value).intValue());
            }
            if (type == factory.intType) {
                return DexValue.DexValueInt.create((Integer)value);
            }
            if (type == factory.floatType) {
                return DexValue.DexValueFloat.create(((Float)value).floatValue());
            }
            if (type == factory.longType) {
                return DexValue.DexValueLong.create((Long)value);
            }
            if (type == factory.doubleType) {
                return DexValue.DexValueDouble.create((Double)value);
            }
            if (type == factory.stringType) {
                return new DexValue.DexValueString(factory.createString((String)value));
            }
            throw new Unreachable("Unexpected static-value type " + type);
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }
    }

    private static class CreateDexClassVisitor
    extends ClassVisitor {
        private final Origin origin;
        private final ClassKind classKind;
        private final JarApplicationReader application;
        private final Consumer<DexClass> classConsumer;
        private final JarCode.ReparseContext context = new JarCode.ReparseContext();
        private int version;
        private DexType type;
        private ClassAccessFlags accessFlags;
        private DexType superType;
        private DexTypeList interfaces;
        private DexString sourceFile;
        private EnclosingMethodAttribute enclosingMember = null;
        private final List<InnerClassAttribute> innerClasses = new ArrayList<InnerClassAttribute>();
        private List<DexAnnotation> annotations = null;
        private List<DexAnnotationElement> defaultAnnotations = null;
        private final List<DexEncodedField> staticFields = new ArrayList<DexEncodedField>();
        private final List<DexEncodedField> instanceFields = new ArrayList<DexEncodedField>();
        private final List<DexEncodedMethod> directMethods = new ArrayList<DexEncodedMethod>();
        private final List<DexEncodedMethod> virtualMethods = new ArrayList<DexEncodedMethod>();

        public CreateDexClassVisitor(Origin origin, ClassKind classKind, byte[] classCache, JarApplicationReader application, Consumer<DexClass> classConsumer) {
            super(393216);
            this.origin = origin;
            this.classKind = classKind;
            this.classConsumer = classConsumer;
            this.context.classCache = classCache;
            this.application = application;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.innerClasses.add(new InnerClassAttribute(access, this.application.getTypeFromName(name), outerName == null ? null : this.application.getTypeFromName(outerName), innerName == null ? null : this.application.getString(innerName)));
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
            assert (this.enclosingMember == null);
            DexType ownerType = this.application.getTypeFromName(owner);
            this.enclosingMember = name == null ? new EnclosingMethodAttribute(ownerType) : new EnclosingMethodAttribute(this.application.getMethod(ownerType, name, desc));
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.version = version;
            this.accessFlags = ClassAccessFlags.fromCfAccessFlags(JarClassFileReader.cleanAccessFlags(access));
            this.type = this.application.getTypeFromName(name);
            if (!this.accessFlags.areValid(this.getMajorVersion())) {
                throw new CompilationError("Illegal class file: Class " + name + " has invalid access flags. Found: " + this.accessFlags.toString(), this.origin);
            }
            if (superName == null && !name.equals("java/lang/Object")) {
                throw new CompilationError("Illegal class file: Class " + name + " is missing a super type.", this.origin);
            }
            if (this.accessFlags.isInterface() && !Objects.equals(superName, "java/lang/Object")) {
                throw new CompilationError("Illegal class file: Interface " + name + " must extend class java.lang.Object. Found: " + Objects.toString(superName), this.origin);
            }
            assert (superName != null || name.equals("java/lang/Object"));
            this.superType = superName == null ? null : this.application.getTypeFromName(superName);
            this.interfaces = this.application.getTypeListFromNames(interfaces);
            if (signature != null && !signature.isEmpty()) {
                this.addAnnotation(DexAnnotation.createSignatureAnnotation(signature, this.application.getFactory()));
            }
        }

        @Override
        public void visitSource(String source, String debug) {
            if (source != null) {
                this.sourceFile = this.application.getString(source);
            }
            if (debug != null) {
                this.getAnnotations().add(DexAnnotation.createSourceDebugExtensionAnnotation(new DexValue.DexValueString(this.application.getString(debug)), this.application.getFactory()));
            }
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return new CreateFieldVisitor(this, access, name, desc, signature, value);
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new CreateMethodVisitor(access, name, desc, signature, exceptions, this);
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return JarClassFileReader.createAnnotationVisitor(desc, visible, this.getAnnotations(), this.application);
        }

        @Override
        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
            return null;
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
            DexClass clazz;
            if (this.defaultAnnotations != null) {
                this.addAnnotation(DexAnnotation.createAnnotationDefaultAnnotation(this.type, this.defaultAnnotations, this.application.getFactory()));
            }
            if ((clazz = this.classKind.create(this.type, ProgramResource.Kind.CF, this.origin, this.accessFlags, this.superType, this.interfaces, this.sourceFile, this.enclosingMember, this.innerClasses, JarClassFileReader.createAnnotationSet(this.annotations), this.staticFields.toArray(new DexEncodedField[this.staticFields.size()]), this.instanceFields.toArray(new DexEncodedField[this.instanceFields.size()]), this.directMethods.toArray(new DexEncodedMethod[this.directMethods.size()]), this.virtualMethods.toArray(new DexEncodedMethod[this.virtualMethods.size()]))).isProgramClass()) {
                this.context.owner = clazz.asProgramClass();
                clazz.asProgramClass().setClassFileVersion(this.version);
            }
            this.classConsumer.accept(clazz);
        }

        private void addDefaultAnnotation(String name, DexValue value) {
            if (this.defaultAnnotations == null) {
                this.defaultAnnotations = new ArrayList<DexAnnotationElement>();
            }
            this.defaultAnnotations.add(new DexAnnotationElement(this.application.getString(name), value));
        }

        private void addAnnotation(DexAnnotation annotation) {
            this.getAnnotations().add(annotation);
        }

        private List<DexAnnotation> getAnnotations() {
            if (this.annotations == null) {
                this.annotations = new ArrayList<DexAnnotation>();
            }
            return this.annotations;
        }

        private int getMajorVersion() {
            return this.version & 0xFFFF;
        }

        private int getMinorVersion() {
            return this.version >> 16 & 0xFFFF;
        }
    }
}

