/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.com.google.common.base.Equivalence;
import com.android.tools.r8.graph.DexMethod;
import com.android.tools.r8.utils.MethodSignatureEquivalence;
import java.util.HashSet;
import java.util.Set;

class ScopedDexMethodSet {
    private static final Equivalence<DexMethod> METHOD_EQUIVALENCE = MethodSignatureEquivalence.get();
    private final ScopedDexMethodSet parent;
    private final Set<Equivalence.Wrapper<DexMethod>> items = new HashSet<Equivalence.Wrapper<DexMethod>>();

    public ScopedDexMethodSet() {
        this(null);
    }

    private ScopedDexMethodSet(ScopedDexMethodSet parent) {
        this.parent = parent;
    }

    public ScopedDexMethodSet newNestedScope() {
        return new ScopedDexMethodSet(this);
    }

    private boolean contains(Equivalence.Wrapper<DexMethod> item) {
        return this.items.contains(item) || this.parent != null && this.parent.contains(item);
    }

    public boolean addMethod(DexMethod method) {
        Equivalence.Wrapper<DexMethod> wrapped = METHOD_EQUIVALENCE.wrap(method);
        return !this.contains(wrapped) && this.items.add(wrapped);
    }

    public ScopedDexMethodSet getParent() {
        return this.parent;
    }
}

