/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.ir.synthetic;

import com.android.tools.r8.ApiLevelException;
import com.android.tools.r8.errors.Unreachable;
import com.android.tools.r8.graph.DebugLocalInfo;
import com.android.tools.r8.graph.DexProto;
import com.android.tools.r8.graph.DexType;
import com.android.tools.r8.ir.code.Argument;
import com.android.tools.r8.ir.code.BasicBlock;
import com.android.tools.r8.ir.code.CatchHandlers;
import com.android.tools.r8.ir.code.Position;
import com.android.tools.r8.ir.code.Value;
import com.android.tools.r8.ir.code.ValueType;
import com.android.tools.r8.ir.conversion.IRBuilder;
import com.android.tools.r8.ir.conversion.SourceCode;
import com.android.tools.r8.utils.ThrowingConsumer;
import java.util.ArrayList;
import java.util.List;

public abstract class SingleBlockSourceCode
implements SourceCode {
    protected final DexType receiver;
    protected final DexProto proto;
    private int nextRegister = 0;
    private final int receiverRegister;
    private int[] paramRegisters;
    private Value receiverValue;
    private Value[] paramValues;
    private List<ThrowingConsumer<IRBuilder, ApiLevelException>> constructors = new ArrayList<ThrowingConsumer<IRBuilder, ApiLevelException>>();

    protected SingleBlockSourceCode(DexType receiver, DexProto proto) {
        assert (proto != null);
        this.receiver = receiver;
        this.proto = proto;
        this.receiverRegister = receiver != null ? this.nextRegister(ValueType.OBJECT) : -1;
        DexType[] params = proto.parameters.values;
        int paramCount = params.length;
        this.paramRegisters = new int[paramCount];
        this.paramValues = new Value[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            this.paramRegisters[i] = this.nextRegister(ValueType.fromDexType(params[i]));
        }
    }

    protected final void add(ThrowingConsumer<IRBuilder, ApiLevelException> constructor) {
        this.constructors.add(constructor);
    }

    protected final int nextRegister(ValueType type) {
        int value = this.nextRegister;
        this.nextRegister += type.requiredRegisters();
        return value;
    }

    protected final Value getReceiverValue() {
        assert (this.receiver != null);
        assert (this.receiverValue != null);
        return this.receiverValue;
    }

    protected final int getReceiverRegister() {
        assert (this.receiver != null);
        assert (this.receiverRegister >= 0);
        return this.receiverRegister;
    }

    protected final Value getParamValue(int paramIndex) {
        assert (paramIndex >= 0);
        assert (paramIndex < this.paramValues.length);
        return this.paramValues[paramIndex];
    }

    protected final int getParamCount() {
        return this.paramValues.length;
    }

    protected final int getParamRegister(int paramIndex) {
        assert (paramIndex >= 0);
        assert (paramIndex < this.paramRegisters.length);
        return this.paramRegisters[paramIndex];
    }

    protected abstract void prepareInstructions();

    @Override
    public final int instructionCount() {
        return this.constructors.size();
    }

    @Override
    public final int instructionIndex(int instructionOffset) {
        return instructionOffset;
    }

    @Override
    public final int instructionOffset(int instructionIndex) {
        return instructionIndex;
    }

    @Override
    public DebugLocalInfo getCurrentLocal(int register) {
        return null;
    }

    @Override
    public final int traceInstruction(int instructionIndex, IRBuilder builder) {
        return instructionIndex == this.constructors.size() - 1 ? instructionIndex : -1;
    }

    @Override
    public final void closingCurrentBlockWithFallthrough(int fallthroughInstructionIndex, IRBuilder builder) {
    }

    @Override
    public final void setUp() {
        assert (this.constructors.isEmpty());
        this.prepareInstructions();
        assert (!this.constructors.isEmpty());
    }

    @Override
    public final void clear() {
        this.constructors = null;
        this.paramRegisters = null;
        this.paramValues = null;
        this.receiverValue = null;
    }

    @Override
    public final void buildPrelude(IRBuilder builder) {
        if (this.receiver != null) {
            this.receiverValue = builder.writeRegister(this.receiverRegister, ValueType.OBJECT, BasicBlock.ThrowingInfo.NO_THROW);
            builder.add(new Argument(this.receiverValue));
            this.receiverValue.markAsThis();
        }
        DexType[] parameters = this.proto.parameters.values;
        for (int i = 0; i < parameters.length; ++i) {
            Value paramValue;
            ValueType valueType = ValueType.fromDexType(parameters[i]);
            this.paramValues[i] = paramValue = builder.writeRegister(this.paramRegisters[i], valueType, BasicBlock.ThrowingInfo.NO_THROW);
            builder.add(new Argument(paramValue));
        }
    }

    @Override
    public final void buildPostlude(IRBuilder builder) {
    }

    @Override
    public final void buildInstruction(IRBuilder builder, int instructionIndex) throws ApiLevelException {
        this.constructors.get(instructionIndex).accept(builder);
    }

    @Override
    public final void resolveAndBuildSwitch(int value, int fallthroughOffset, int payloadOffset, IRBuilder builder) {
        throw new Unreachable("Unexpected call to resolveAndBuildSwitch");
    }

    @Override
    public final void resolveAndBuildNewArrayFilledData(int arrayRef, int payloadOffset, IRBuilder builder) {
        throw new Unreachable("Unexpected call to resolveAndBuildNewArrayFilledData");
    }

    @Override
    public final CatchHandlers<Integer> getCurrentCatchHandlers() {
        return null;
    }

    @Override
    public int getMoveExceptionRegister() {
        throw new Unreachable();
    }

    @Override
    public Position getDebugPositionAtOffset(int offset) {
        throw new Unreachable();
    }

    @Override
    public Position getCurrentPosition() {
        return Position.none();
    }

    @Override
    public final boolean verifyCurrentInstructionCanThrow() {
        return true;
    }

    @Override
    public boolean verifyLocalInScope(DebugLocalInfo local) {
        return true;
    }

    @Override
    public final boolean verifyRegister(int register) {
        return true;
    }
}

