/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.graph;

import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.dex.MixedSectionCollection;
import com.android.tools.r8.graph.DexAnnotationElement;
import com.android.tools.r8.graph.DexItem;
import com.android.tools.r8.graph.DexType;
import java.util.Arrays;

public class DexEncodedAnnotation
extends DexItem {
    private static final int UNSORTED = 0;
    public final DexType type;
    public final DexAnnotationElement[] elements;
    private int sorted = 0;

    public DexEncodedAnnotation(DexType type, DexAnnotationElement[] elements) {
        this.type = type;
        this.elements = elements;
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
        this.type.collectIndexedItems(indexedItems);
        DexEncodedAnnotation.collectAll((IndexedItemCollection)indexedItems, (DexItem[])this.elements);
    }

    @Override
    void collectMixedSectionItems(MixedSectionCollection mixedItems) {
        assert (false);
    }

    public String toString() {
        return "Encoded annotation " + this.type + " " + Arrays.toString(this.elements);
    }

    public int hashCode() {
        return this.type.hashCode() * 7 + Arrays.hashCode(this.elements);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DexEncodedAnnotation) {
            DexEncodedAnnotation that = (DexEncodedAnnotation)other;
            return that.type.equals(this.type) && Arrays.equals(that.elements, this.elements);
        }
        return false;
    }

    public void sort() {
        if (this.sorted != 0) {
            assert (this.sorted == this.sortedHashCode());
            return;
        }
        Arrays.sort(this.elements, (a, b) -> a.name.compareTo(b.name));
        for (DexAnnotationElement element : this.elements) {
            element.value.sort();
        }
        this.sorted = this.sortedHashCode();
    }

    private int sortedHashCode() {
        int hashCode = this.hashCode();
        return hashCode == 0 ? 1 : hashCode;
    }
}

