/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.code;

import com.android.tools.r8.code.Base2Format;
import com.android.tools.r8.code.BytecodeStream;
import com.android.tools.r8.dex.IndexedItemCollection;
import com.android.tools.r8.graph.ObjectToOffsetMapping;
import com.android.tools.r8.naming.ClassNameMapper;
import com.android.tools.r8.utils.StringUtils;
import java.nio.ShortBuffer;

abstract class Format21s
extends Base2Format {
    public final short AA;
    public final short BBBB;

    Format21s(int high, BytecodeStream stream) {
        super(stream);
        this.AA = (short)high;
        this.BBBB = Format21s.readSigned16BitValue(stream);
    }

    Format21s(int AA, int BBBB) {
        assert (Short.MIN_VALUE <= BBBB && BBBB <= Short.MAX_VALUE);
        assert (0 <= AA && AA <= 255);
        this.AA = (short)AA;
        this.BBBB = (short)BBBB;
    }

    @Override
    public void write(ShortBuffer dest, ObjectToOffsetMapping mapping) {
        this.writeFirst(this.AA, dest);
        this.write16BitValue(this.BBBB, dest);
    }

    @Override
    public final int hashCode() {
        return (this.BBBB << 8 | this.AA) ^ this.getClass().hashCode();
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Format21s o = (Format21s)other;
        return o.AA == this.AA && o.BBBB == this.BBBB;
    }

    @Override
    public String toString(ClassNameMapper naming) {
        return this.formatString("v" + this.AA + ", #" + this.BBBB);
    }

    @Override
    public String toSmaliString(ClassNameMapper naming) {
        return this.formatSmaliString("v" + this.AA + ", " + StringUtils.hexString(this.BBBB, 4) + "  # " + this.BBBB);
    }

    @Override
    public void collectIndexedItems(IndexedItemCollection indexedItems) {
    }
}

