/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8;

import com.android.tools.r8.DiagnosticsHandler;
import com.android.tools.r8.InternalProgramOutputPathConsumer;
import com.android.tools.r8.ProgramConsumer;
import com.android.tools.r8.ProgramResource;
import com.android.tools.r8.ResourceException;
import com.android.tools.r8.com.google.common.io.ByteStreams;
import com.android.tools.r8.com.google.common.io.Closer;
import com.android.tools.r8.origin.Origin;
import com.android.tools.r8.origin.PathOrigin;
import com.android.tools.r8.utils.FileUtils;
import com.android.tools.r8.utils.IOExceptionDiagnostic;
import com.android.tools.r8.utils.ZipUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipOutputStream;

public interface DexIndexedConsumer
extends ProgramConsumer {
    public void accept(int var1, byte[] var2, Set<String> var3, DiagnosticsHandler var4);

    public static DexIndexedConsumer emptyConsumer() {
        return ForwardingConsumer.EMPTY_CONSUMER;
    }

    public static class DirectoryConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final Path directory;
        private boolean preparedDirectory = false;

        public DirectoryConsumer(Path directory) {
            this(directory, null);
        }

        public DirectoryConsumer(Path directory, DexIndexedConsumer consumer) {
            super(consumer);
            this.directory = directory;
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data, descriptors, handler);
            Path target = DirectoryConsumer.getTargetDexFile(this.directory, fileIndex);
            try {
                this.prepareDirectory();
                DirectoryConsumer.writeFile(data, target);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, new PathOrigin(target)));
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
        }

        private synchronized void prepareDirectory() throws IOException {
            if (this.preparedDirectory) {
                return;
            }
            this.preparedDirectory = true;
            DirectoryConsumer.deleteClassesDexFiles(this.directory);
        }

        public static void deleteClassesDexFiles(Path directory) throws IOException {
            try (Stream<Path> filesInDir = Files.list(directory);){
                for (Path path : filesInDir.collect(Collectors.toList())) {
                    if (!FileUtils.isClassesDexFile(path)) continue;
                    Files.delete(path);
                }
            }
        }

        public static void writeResources(Path directory, List<ProgramResource> resources) throws IOException, ResourceException {
            DirectoryConsumer.deleteClassesDexFiles(directory);
            try (Closer closer = Closer.create();){
                for (int i = 0; i < resources.size(); ++i) {
                    ProgramResource resource = resources.get(i);
                    Path target = DirectoryConsumer.getTargetDexFile(directory, i);
                    DirectoryConsumer.writeFile(ByteStreams.toByteArray(closer.register(resource.getByteStream())), target);
                }
            }
        }

        private static Path getTargetDexFile(Path directory, int fileIndex) {
            return directory.resolve(ArchiveConsumer.getDefaultDexFileName(fileIndex));
        }

        private static void writeFile(byte[] contents, Path target) throws IOException {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            FileUtils.writeToFile(target, null, contents);
        }

        @Override
        public Path internalGetOutputPath() {
            return this.directory;
        }
    }

    public static class ArchiveConsumer
    extends ForwardingConsumer
    implements InternalProgramOutputPathConsumer {
        private final Path archive;
        private final Origin origin;
        private ZipOutputStream stream = null;
        private boolean closed = false;

        private static String getDefaultDexFileName(int fileIndex) {
            return fileIndex == 0 ? "classes.dex" : "classes" + (fileIndex + 1) + ".dex";
        }

        public ArchiveConsumer(Path archive) {
            this(archive, null);
        }

        public ArchiveConsumer(Path archive, DexIndexedConsumer consumer) {
            super(consumer);
            this.archive = archive;
            this.origin = new PathOrigin(archive);
        }

        protected String getDexFileName(int fileIndex) {
            return ArchiveConsumer.getDefaultDexFileName(fileIndex);
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            super.accept(fileIndex, data, descriptors, handler);
            this.synchronizedWrite(this.getDexFileName(fileIndex), data, handler);
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            super.finished(handler);
            assert (!this.closed);
            this.closed = true;
            try {
                if (this.stream != null) {
                    this.stream.close();
                    this.stream = null;
                }
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }

        protected synchronized ZipOutputStream getStream(DiagnosticsHandler handler) {
            assert (!this.closed);
            if (this.stream == null) {
                try {
                    this.stream = new ZipOutputStream(Files.newOutputStream(this.archive, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                }
                catch (IOException e) {
                    handler.error(new IOExceptionDiagnostic(e, this.origin));
                }
            }
            return this.stream;
        }

        private synchronized void synchronizedWrite(String entry, byte[] content, DiagnosticsHandler handler) {
            try {
                ZipUtils.writeToZipStream(this.getStream(handler), entry, content);
            }
            catch (IOException e) {
                handler.error(new IOExceptionDiagnostic(e, this.origin));
            }
        }

        public static void writeResources(Path archive, List<ProgramResource> resources) throws IOException, ResourceException {
            OpenOption[] options = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            try (Closer closer = Closer.create();
                 ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(archive, options));){
                for (int i = 0; i < resources.size(); ++i) {
                    ProgramResource resource = resources.get(i);
                    String entryName = ArchiveConsumer.getDefaultDexFileName(i);
                    byte[] bytes = ByteStreams.toByteArray(closer.register(resource.getByteStream()));
                    ZipUtils.writeToZipStream(out, entryName, bytes);
                }
            }
        }

        @Override
        public Path internalGetOutputPath() {
            return this.archive;
        }
    }

    public static class ForwardingConsumer
    implements DexIndexedConsumer {
        private static final DexIndexedConsumer EMPTY_CONSUMER = new ForwardingConsumer(null);
        private final DexIndexedConsumer consumer;

        public ForwardingConsumer(DexIndexedConsumer consumer) {
            this.consumer = consumer;
        }

        @Override
        public void accept(int fileIndex, byte[] data, Set<String> descriptors, DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.accept(fileIndex, data, descriptors, handler);
            }
        }

        @Override
        public void finished(DiagnosticsHandler handler) {
            if (this.consumer != null) {
                this.consumer.finished(handler);
            }
        }
    }
}

