/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt.v2;

import com.android.builder.core.VariantType;
import com.android.builder.internal.aapt.AaptException;
import com.android.builder.internal.aapt.AaptPackageConfig;
import com.android.builder.internal.aapt.AaptUtils;
import com.android.ide.common.res2.CompileResourceRequest;
import com.android.utils.FileUtils;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public final class AaptV2CommandBuilder {
    private AaptV2CommandBuilder() {
    }

    public static ImmutableList<String> makeCompile(CompileResourceRequest request) {
        String lowerName;
        ImmutableList.Builder parameters = new ImmutableList.Builder();
        if (request.isPseudoLocalize()) {
            parameters.add((Object)"--pseudo-localize");
        }
        if (!request.isPngCrunching() && (lowerName = request.getInputFile().getPath().toLowerCase(Locale.US)).endsWith(".png") && !lowerName.endsWith(".9.png")) {
            parameters.add((Object)"--no-crunch");
        }
        parameters.add((Object)"--legacy");
        parameters.add((Object[])new String[]{"-o", request.getOutputDirectory().getAbsolutePath()});
        parameters.add((Object)request.getInputFile().getAbsolutePath());
        return parameters.build();
    }

    public static ImmutableList<String> makeLink(AaptPackageConfig config) throws AaptException {
        ImmutableList densityResSplits;
        List<String> additionalParameters;
        File resourceOutputApk;
        ImmutableList.Builder builder;
        block58: {
            builder = ImmutableList.builder();
            if (config.getVerbose()) {
                builder.add((Object)"-v");
            }
            if (config.getGenerateProtos()) {
                builder.add((Object)"--proto-format");
            }
            builder.add((Object[])new String[]{"-I", (String)Preconditions.checkNotNull((Object)config.getAndroidJarPath())});
            config.getImports().forEach(file -> builder.add((Object[])new String[]{"-I", file.getAbsolutePath()}));
            File manifestFile = config.getManifestFile();
            Preconditions.checkNotNull((Object)manifestFile);
            builder.add((Object[])new String[]{"--manifest", manifestFile.getAbsolutePath()});
            if (config.getResourceOutputApk() != null) {
                resourceOutputApk = config.getResourceOutputApk();
            } else {
                try {
                    File tmpOutput = File.createTempFile("aapt-", "-out");
                    tmpOutput.deleteOnExit();
                    resourceOutputApk = tmpOutput;
                }
                catch (IOException e) {
                    throw new AaptException("No output apk defined and failed to create tmp file", e);
                }
            }
            builder.add((Object[])new String[]{"-o", resourceOutputApk.getAbsolutePath()});
            if (!config.getResourceDirs().isEmpty()) {
                try {
                    if (config.isListResourceFiles()) {
                        File resourceListFile = new File((File)Preconditions.checkNotNull((Object)config.getIntermediateDir(), (Object)"Intermediate directory must be supplied."), "resources-list-for-" + resourceOutputApk.getName() + ".txt");
                        FileUtils.deleteIfExists((File)resourceListFile);
                        for (File dir : config.getResourceDirs()) {
                            FileOutputStream fos = new FileOutputStream(resourceListFile);
                            Throwable throwable = null;
                            try {
                                PrintWriter pw = new PrintWriter(fos);
                                Throwable throwable2 = null;
                                try {
                                    Files.walk(dir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> pw.print(p.toString() + " "));
                                }
                                catch (Throwable throwable3) {
                                    throwable2 = throwable3;
                                    throw throwable3;
                                }
                                finally {
                                    if (pw == null) continue;
                                    if (throwable2 != null) {
                                        try {
                                            pw.close();
                                        }
                                        catch (Throwable throwable4) {
                                            throwable2.addSuppressed(throwable4);
                                        }
                                        continue;
                                    }
                                    pw.close();
                                }
                            }
                            catch (Throwable pw) {
                                throwable = pw;
                                throw pw;
                            }
                            finally {
                                if (fos == null) continue;
                                if (throwable != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable pw) {
                                        throwable.addSuppressed(pw);
                                    }
                                    continue;
                                }
                                fos.close();
                            }
                        }
                        builder.add((Object[])new String[]{"-R", "@" + resourceListFile.getAbsolutePath()});
                        break block58;
                    }
                    for (File dir : config.getResourceDirs()) {
                        Files.walk(dir.toPath(), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(p -> builder.add((Object[])new String[]{"-R", p.toString()}));
                    }
                }
                catch (IOException e) {
                    throw new AaptException("Failed to walk paths " + Joiner.on((char)File.pathSeparatorChar).join(config.getResourceDirs()), e);
                }
            }
        }
        builder.add((Object)"--auto-add-overlay");
        if (config.getSourceOutputDir() != null) {
            builder.add((Object[])new String[]{"--java", config.getSourceOutputDir().getAbsolutePath()});
        }
        if (config.getProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard", config.getProguardOutputFile().getAbsolutePath()});
        }
        if (config.getMainDexListProguardOutputFile() != null) {
            builder.add((Object[])new String[]{"--proguard-main-dex", config.getMainDexListProguardOutputFile().getAbsolutePath()});
        }
        if (config.getSplits() != null) {
            for (String split : config.getSplits()) {
                String splitter = File.pathSeparator;
                builder.add((Object[])new String[]{"--split", resourceOutputApk + "_" + split + (String)splitter + split});
            }
        }
        if (config.getVariantType() != VariantType.ANDROID_TEST && config.getCustomPackageForR() != null) {
            builder.add((Object[])new String[]{"--custom-package", config.getCustomPackageForR()});
        }
        boolean generateFinalIds = true;
        if (config.getVariantType() == VariantType.LIBRARY) {
            generateFinalIds = false;
        }
        if (!generateFinalIds) {
            builder.add((Object)"--non-final-ids");
        }
        builder.add((Object[])new String[]{"-0", "apk"});
        Collection<String> noCompressList = Objects.requireNonNull(config.getOptions()).getNoCompress();
        if (noCompressList != null) {
            for (String noCompress : noCompressList) {
                builder.add((Object[])new String[]{"-0", noCompress});
            }
        }
        if ((additionalParameters = config.getOptions().getAdditionalParameters()) != null) {
            builder.addAll(additionalParameters);
        }
        ArrayList<String> resourceConfigs = new ArrayList<String>((Collection<String>)config.getResourceConfigs());
        ArrayList densityResourceConfigs = Lists.newArrayList(AaptUtils.getDensityResConfigs(resourceConfigs));
        ArrayList otherResourceConfigs = Lists.newArrayList(AaptUtils.getNonDensityResConfigs(resourceConfigs));
        String preferredDensity = config.getPreferredDensity();
        Object object = densityResSplits = config.getSplits() != null ? AaptUtils.getDensityResConfigs(config.getSplits()) : ImmutableList.of();
        if ((preferredDensity != null || densityResSplits.iterator().hasNext()) && !densityResourceConfigs.isEmpty()) {
            throw new AaptException(String.format("When using splits in tools 21 and above, resConfigs should not contain any densities. Right now, it contains \"%1$s\"\nSuggestion: remove these from resConfigs from build.gradle", Joiner.on((String)"\",\"").join((Iterable)densityResourceConfigs)));
        }
        if (densityResourceConfigs.size() > 1) {
            throw new AaptException("Cannot filter assets for multiple densities using SDK build tools 21 or later. Consider using apk splits instead.");
        }
        if (!otherResourceConfigs.isEmpty() && config.getSplits() != null) {
            Iterable<String> nonDensitySplits = AaptUtils.getNonDensityResConfigs(config.getSplits());
            otherResourceConfigs.addAll(Lists.newArrayList(nonDensitySplits));
        }
        if (preferredDensity == null && densityResourceConfigs.size() == 1) {
            preferredDensity = (String)Iterables.getOnlyElement((Iterable)densityResourceConfigs);
        }
        if (!otherResourceConfigs.isEmpty()) {
            Joiner joiner = Joiner.on((char)',');
            builder.add((Object[])new String[]{"-c", joiner.join((Iterable)otherResourceConfigs)});
        }
        if (preferredDensity != null) {
            builder.add((Object[])new String[]{"--preferred-density", preferredDensity});
        }
        if (!(config.getSymbolOutputDir() == null || config.getVariantType() != VariantType.LIBRARY && config.getLibrarySymbolTableFiles().isEmpty())) {
            File rDotTxt = new File(config.getSymbolOutputDir(), "R.txt");
            builder.add((Object[])new String[]{"--output-text-symbols", rDotTxt.getAbsolutePath()});
        }
        if (config.getPackageId() != null) {
            builder.add((Object[])new String[]{"--package-id", "0x" + Integer.toHexString(config.getPackageId())});
            for (File dependentFeature : config.getDependentFeatures()) {
                builder.add((Object[])new String[]{"-I", dependentFeature.getAbsolutePath()});
            }
        } else if (!config.getDependentFeatures().isEmpty()) {
            throw new AaptException("Dependent features configured but no package ID was set.");
        }
        builder.add((Object)"--no-version-vectors");
        if (config.isStaticLibrary()) {
            builder.add((Object)"--static-lib");
            if (!config.getStaticLibraryDependencies().isEmpty()) {
                throw new AaptException("Static libraries to link against should be passed as imports");
            }
        } else {
            for (File file2 : config.getStaticLibraryDependencies()) {
                builder.add((Object)file2.getAbsolutePath());
            }
        }
        return builder.build();
    }
}

