/*
 * Decompiled with CFR 0.152.
 */
package com.android.builder.internal.aapt;

import com.android.builder.png.AaptProcess;
import com.android.builder.tasks.Job;
import com.android.builder.tasks.JobContext;
import com.android.builder.tasks.QueueThreadContext;
import com.android.builder.tasks.Task;
import com.android.utils.ILogger;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class AaptQueueThreadContext
implements QueueThreadContext<AaptProcess> {
    protected final Map<String, AaptProcess> aaptProcesses = new ConcurrentHashMap<String, AaptProcess>();
    private final ILogger logger;
    protected final String aaptLocation;
    private final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> outstandingJobs;
    private final Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> doneJobs;

    public AaptQueueThreadContext(ILogger logger, String aaptLocation, Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> outstandingJobs, Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> doneJobs) {
        this.logger = logger;
        this.aaptLocation = aaptLocation;
        this.outstandingJobs = outstandingJobs;
        this.doneJobs = doneJobs;
    }

    @Override
    public boolean creation(Thread t) throws IOException, InterruptedException {
        try {
            AaptProcess aaptProcess = new AaptProcess.Builder(this.aaptLocation, this.logger).start();
            boolean ready = aaptProcess.waitForReadyOrFail();
            if (ready) {
                this.aaptProcesses.put(t.getName(), aaptProcess);
            }
            return ready;
        }
        catch (InterruptedException e) {
            this.logger.error((Throwable)e, "Cannot start slave process", new Object[0]);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTask(Job<AaptProcess> job) throws Exception {
        job.runTask(new JobContext<AaptProcess>(this.aaptProcesses.get(Thread.currentThread().getName())));
        this.outstandingJobs.get(((QueuedJob)job).key).remove(job);
        Map<Integer, ConcurrentLinkedQueue<Job<AaptProcess>>> map = this.doneJobs;
        synchronized (map) {
            ConcurrentLinkedQueue jobs = this.doneJobs.computeIfAbsent(((QueuedJob)job).key, k -> new ConcurrentLinkedQueue());
            jobs.add(job);
        }
    }

    @Override
    public void destruction(Thread t) throws IOException, InterruptedException {
        AaptProcess aaptProcess = this.aaptProcesses.get(Thread.currentThread().getName());
        if (aaptProcess == null) {
            return;
        }
        try {
            aaptProcess.shutdown();
        }
        finally {
            this.aaptProcesses.remove(t.getName());
        }
        this.logger.verbose("Thread(%1$s): Process(%2$d), after shutdown queue_size=%3$d", new Object[]{Thread.currentThread().getName(), aaptProcess.hashCode(), this.aaptProcesses.size()});
    }

    @Override
    public void shutdown() {
        if (this.aaptProcesses.isEmpty()) {
            return;
        }
        this.logger.warning("Process list not empty", new Object[0]);
        for (Map.Entry<String, AaptProcess> aaptProcessEntry : this.aaptProcesses.entrySet()) {
            this.logger.warning("Thread(%1$s): queue not cleaned", new Object[]{aaptProcessEntry.getKey()});
            try {
                aaptProcessEntry.getValue().shutdown();
            }
            catch (Exception e) {
                this.logger.error((Throwable)e, "while shutting down" + aaptProcessEntry.getKey(), new Object[0]);
            }
        }
        this.aaptProcesses.clear();
    }

    public static final class QueuedJob
    extends Job<AaptProcess> {
        protected final int key;

        public QueuedJob(int key, String jobTile, Task<AaptProcess> task, ListenableFuture<File> resultFuture) {
            super(jobTile, task, resultFuture);
            this.key = key;
        }
    }
}

