/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import android.aapt.pb.internal.ResourcesInternal;
import com.android.aapt.Resources;
import com.android.aaptcompiler.ResourceFile;
import com.android.aaptcompiler.XmlResource;
import com.android.aaptcompiler.proto.ProtoSerializeKt;
import com.google.protobuf.CodedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002 !B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\rH\u0002J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\""}, d2={"Lcom/android/aaptcompiler/Container;", "", "output", "Ljava/io/OutputStream;", "totalEntryCount", "", "(Ljava/io/OutputStream;I)V", "currentEntryCount", "getOutput", "()Ljava/io/OutputStream;", "getTotalEntryCount", "()I", "addFileEntry", "", "input", "Ljava/io/InputStream;", "file", "Lcom/android/aaptcompiler/ResourceFile;", "addFileEntryImpl", "content", "", "addResTableEntry", "table", "Lcom/android/aapt/Resources$ResourceTable;", "addXmlEntry", "resource", "Lcom/android/aaptcompiler/XmlResource;", "closeIfFinished", "writePadding", "padding", "codedOut", "Lcom/google/protobuf/CodedOutputStream;", "Companion", "EntryType", "aaptcompiler"})
public final class Container {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OutputStream output;
    private final int totalEntryCount;
    private int currentEntryCount;
    public static final int FORMAT_MAGIC = 1414545729;
    public static final int FORMAT_VERSION = 1;
    public static final int RES_FILE_ENTRY_HEADER_SIZE = 12;

    public Container(@NotNull OutputStream output, int totalEntryCount) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        this.output = output;
        this.totalEntryCount = totalEntryCount;
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)this.output);
        codedOut.writeFixed32NoTag(1414545729);
        codedOut.writeFixed32NoTag(1);
        codedOut.writeFixed32NoTag(this.totalEntryCount);
        codedOut.flush();
    }

    @NotNull
    public final OutputStream getOutput() {
        return this.output;
    }

    public final int getTotalEntryCount() {
        return this.totalEntryCount;
    }

    public final void addResTableEntry(@NotNull Resources.ResourceTable table) {
        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
        if (this.currentEntryCount >= this.totalEntryCount) {
            String string = "Too many entries being serialized.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Container container = this;
        ++container.currentEntryCount;
        int cfr_ignored_0 = container.currentEntryCount;
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)this.output);
        codedOut.writeFixed32NoTag(EntryType.RES_TABLE.getValue());
        int size = table.getSerializedSize();
        int padding = (4 - size % 4) % 4;
        codedOut.writeFixed64NoTag((long)size);
        table.writeTo(codedOut);
        Intrinsics.checkExpressionValueIsNotNull((Object)codedOut, (String)"codedOut");
        this.writePadding(padding, codedOut);
        codedOut.flush();
        this.closeIfFinished();
    }

    public final void addFileEntry(@NotNull InputStream input, @NotNull ResourceFile file) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        this.addFileEntryImpl(ByteStreamsKt.readBytes((InputStream)input), file);
    }

    public final void addXmlEntry(@NotNull XmlResource resource) {
        Intrinsics.checkParameterIsNotNull((Object)resource, (String)"resource");
        byte[] byArray = resource.getXmlProto().toByteArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"resource.xmlProto.toByteArray()");
        this.addFileEntryImpl(byArray, resource.getFile());
    }

    private final void addFileEntryImpl(byte[] content, ResourceFile file) {
        if (this.currentEntryCount >= this.totalEntryCount) {
            String string = "Too many entries being serialized.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Container container = this;
        ++container.currentEntryCount;
        int cfr_ignored_0 = container.currentEntryCount;
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)this.output);
        codedOut.writeFixed32NoTag(EntryType.RES_FILE.getValue());
        ResourcesInternal.CompiledFile compiledFile = ProtoSerializeKt.serializeCompiledFileToPb(file);
        int headerSize = compiledFile.getSerializedSize();
        int headerPadding = (4 - headerSize % 4) % 4;
        int dataSize = content.length;
        int dataPadding = (4 - dataSize % 4) % 4;
        long totalSize = 12L + (long)headerSize + (long)headerPadding + (long)dataSize + (long)dataPadding;
        codedOut.writeFixed64NoTag(totalSize);
        codedOut.writeFixed32NoTag(headerSize);
        codedOut.writeFixed64NoTag((long)dataSize);
        compiledFile.writeTo(codedOut);
        Intrinsics.checkExpressionValueIsNotNull((Object)codedOut, (String)"codedOut");
        this.writePadding(headerPadding, codedOut);
        codedOut.write(content, 0, dataSize);
        this.writePadding(dataPadding, codedOut);
        codedOut.flush();
        this.closeIfFinished();
    }

    private final void writePadding(int padding, CodedOutputStream codedOut) {
        int n = 1;
        if (n <= padding) {
            int i;
            do {
                i = n++;
                codedOut.writeRawByte((byte)0);
            } while (i != padding);
        }
    }

    private final void closeIfFinished() {
        if (this.currentEntryCount == this.totalEntryCount) {
            this.output.close();
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/android/aaptcompiler/Container$EntryType;", "", "value", "", "(Ljava/lang/String;II)V", "getValue", "()I", "RES_TABLE", "RES_FILE", "aaptcompiler"})
    public static final class EntryType
    extends Enum<EntryType> {
        private final int value;
        public static final /* enum */ EntryType RES_TABLE = new EntryType(0);
        public static final /* enum */ EntryType RES_FILE = new EntryType(1);
        private static final /* synthetic */ EntryType[] $VALUES;

        private EntryType(int value) {
            this.value = value;
        }

        public final int getValue() {
            return this.value;
        }

        public static EntryType[] values() {
            EntryType[] entryTypeArray = $VALUES;
            EntryType[] entryTypeArray2 = new EntryType[entryTypeArray.length];
            System.arraycopy(entryTypeArray, 0, entryTypeArray2, 0, entryTypeArray.length);
            return entryTypeArray2;
        }

        public static EntryType valueOf(String value) {
            Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
            return Enum.valueOf(EntryType.class, value);
        }

        static {
            EntryType[] entryTypeArray = new EntryType[]{RES_TABLE, RES_FILE};
            $VALUES = entryTypeArray;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/android/aaptcompiler/Container$Companion;", "", "()V", "FORMAT_MAGIC", "", "FORMAT_VERSION", "RES_FILE_ENTRY_HEADER_SIZE", "aaptcompiler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

