/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler.buffer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003J\u000e\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0003J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u001e"}, d2={"Lcom/android/aaptcompiler/buffer/BigBuffer;", "", "blockSize", "", "(I)V", "getBlockSize", "()I", "blocks", "", "Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "getBlocks$aaptcompiler", "()Ljava/util/List;", "<set-?>", "size", "getSize", "align4", "", "append", "other", "block", "Lcom/android/aaptcompiler/buffer/BigBuffer$BlockRef;", "index", "nextBlock", "elementSize", "pad", "bytes", "toBytes", "", "Block", "BlockRef", "aaptcompiler"})
public final class BigBuffer {
    private int size;
    @NotNull
    private final List<Block> blocks;
    private final int blockSize;

    public final int getSize() {
        return this.size;
    }

    @NotNull
    public final List<Block> getBlocks$aaptcompiler() {
        return this.blocks;
    }

    @NotNull
    public final BlockRef nextBlock(int elementSize) {
        int start;
        Block back;
        Collection collection = this.blocks;
        boolean bl = false;
        if (!collection.isEmpty() && (back = (Block)CollectionsKt.last(this.blocks)).getBlockSize$aaptcompiler() - back.getSize$aaptcompiler() >= elementSize) {
            start = back.getSize$aaptcompiler();
            Block block = back;
            block.setSize$aaptcompiler(block.getSize$aaptcompiler() + elementSize);
            this.size += elementSize;
            return new BlockRef(start, elementSize, back);
        }
        start = this.blockSize;
        boolean bl2 = false;
        int actualSize = Math.max(start, elementSize);
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[actualSize]).order(ByteOrder.nativeOrder());
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(ByteArra\u2026(ByteOrder.nativeOrder())");
        Block block = new Block(elementSize, actualSize, byteBuffer);
        this.blocks.add(block);
        this.size += elementSize;
        return new BlockRef(0, elementSize, block);
    }

    public final void pad(int bytes) {
        this.nextBlock(bytes);
    }

    public final void align4() {
        int unaligned = this.size % 4;
        if (unaligned != 0) {
            this.pad(4 - unaligned);
        }
    }

    @NotNull
    public final BlockRef block(int index) {
        return new BlockRef(0, this.blocks.get(index).getSize$aaptcompiler(), this.blocks.get(index));
    }

    public final void append(@NotNull BigBuffer other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        this.blocks.addAll((Collection<Block>)other.blocks);
        this.size += other.size;
        other.blocks.clear();
        other.size = 0;
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] array = new byte[this.size];
        int currentLocation = 0;
        for (Block block : this.blocks) {
            Buffer buffer = block.getData$aaptcompiler().position(0);
            if (buffer == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.nio.ByteBuffer");
            }
            ByteBuffer data = (ByteBuffer)buffer;
            data.get(array, currentLocation, block.getSize$aaptcompiler());
            currentLocation += block.getSize$aaptcompiler();
        }
        return array;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    public BigBuffer(int blockSize) {
        List list;
        this.blockSize = blockSize;
        BigBuffer bigBuffer = this;
        boolean bl = false;
        bigBuffer.blocks = list = (List)new ArrayList();
    }

    public /* synthetic */ BigBuffer(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1024;
        }
        this(n);
    }

    public BigBuffer() {
        this(0, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "", "size", "", "blockSize", "data", "Ljava/nio/ByteBuffer;", "(IILjava/nio/ByteBuffer;)V", "getBlockSize$aaptcompiler", "()I", "getData$aaptcompiler", "()Ljava/nio/ByteBuffer;", "getSize$aaptcompiler", "setSize$aaptcompiler", "(I)V", "aaptcompiler"})
    public static final class Block {
        private int size;
        private final int blockSize;
        @NotNull
        private final ByteBuffer data;

        public final int getSize$aaptcompiler() {
            return this.size;
        }

        public final void setSize$aaptcompiler(int n) {
            this.size = n;
        }

        public final int getBlockSize$aaptcompiler() {
            return this.blockSize;
        }

        @NotNull
        public final ByteBuffer getData$aaptcompiler() {
            return this.data;
        }

        public Block(int size, int blockSize, @NotNull ByteBuffer data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            this.size = size;
            this.blockSize = blockSize;
            this.data = data;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\u000eJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010\u0010\u001a\u00020\u0006H\u00c0\u0003\u00a2\u0006\u0002\b\u0011J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003J\u0016\u0010\"\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003J\u0016\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006$"}, d2={"Lcom/android/aaptcompiler/buffer/BigBuffer$BlockRef;", "", "start", "", "size", "block", "Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "(IILcom/android/aaptcompiler/buffer/BigBuffer$Block;)V", "getBlock$aaptcompiler", "()Lcom/android/aaptcompiler/buffer/BigBuffer$Block;", "getSize", "()I", "getStart$aaptcompiler", "component1", "component1$aaptcompiler", "component2", "component3", "component3$aaptcompiler", "copy", "equals", "", "other", "hashCode", "readByte", "", "location", "readInt", "readShort", "", "toString", "", "writeByte", "", "value", "writeInt", "writeShort", "aaptcompiler"})
    public static final class BlockRef {
        private final int start;
        private final int size;
        @NotNull
        private final Block block;

        public final void writeByte(byte value, int location) {
            if (location + 1 > this.size) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            this.block.getData$aaptcompiler().put(actualLocation, value);
        }

        public final void writeShort(short value, int location) {
            if (location + 2 > this.size) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            this.block.getData$aaptcompiler().putShort(actualLocation, value);
        }

        public final void writeInt(int value, int location) {
            if (location + 4 > this.size) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            this.block.getData$aaptcompiler().putInt(actualLocation, value);
        }

        public final byte readByte(int location) {
            if (location + 1 > this.size) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            return this.block.getData$aaptcompiler().get(actualLocation);
        }

        public final short readShort(int location) {
            if (location + 2 > this.size) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            return this.block.getData$aaptcompiler().getShort(actualLocation);
        }

        public final int readInt(int location) {
            if (location + 4 > this.size) {
                throw (Throwable)new IndexOutOfBoundsException();
            }
            int actualLocation = this.start + location;
            return this.block.getData$aaptcompiler().getInt(actualLocation);
        }

        public final int getStart$aaptcompiler() {
            return this.start;
        }

        public final int getSize() {
            return this.size;
        }

        @NotNull
        public final Block getBlock$aaptcompiler() {
            return this.block;
        }

        public BlockRef(int start, int size, @NotNull Block block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            this.start = start;
            this.size = size;
            this.block = block;
        }

        public final int component1$aaptcompiler() {
            return this.start;
        }

        public final int component2() {
            return this.size;
        }

        @NotNull
        public final Block component3$aaptcompiler() {
            return this.block;
        }

        @NotNull
        public final BlockRef copy(int start, int size, @NotNull Block block) {
            Intrinsics.checkParameterIsNotNull((Object)block, (String)"block");
            return new BlockRef(start, size, block);
        }

        public static /* synthetic */ BlockRef copy$default(BlockRef blockRef, int n, int n2, Block block, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = blockRef.start;
            }
            if ((n3 & 2) != 0) {
                n2 = blockRef.size;
            }
            if ((n3 & 4) != 0) {
                block = blockRef.block;
            }
            return blockRef.copy(n, n2, block);
        }

        @NotNull
        public String toString() {
            return "BlockRef(start=" + this.start + ", size=" + this.size + ", block=" + this.block + ")";
        }

        public int hashCode() {
            Block block = this.block;
            return (this.start * 31 + this.size) * 31 + (block != null ? block.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof BlockRef)) break block3;
                    BlockRef blockRef = (BlockRef)object;
                    if (this.start != blockRef.start || this.size != blockRef.size || !Intrinsics.areEqual((Object)this.block, (Object)blockRef.block)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

