/*
 * Decompiled with CFR 0.152.
 */
package com.android.aaptcompiler;

import com.android.aaptcompiler.FlattenedXml;
import com.android.aaptcompiler.Span;
import com.android.aaptcompiler.StyleString;
import com.android.aaptcompiler.UntranslatableSection;
import com.android.aaptcompiler.android.ResourceTypesKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0006J\"\u0010\u001f\u001a\u00020\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\n\u0010\"\u001a\u00060\u0014j\u0002`\u0015H\u0002J\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0000J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020$H\u0002J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\u0006J\u0006\u0010,\u001a\u00020\u0000R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u00060\u0014j\u0002`\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/android/aaptcompiler/XmlStringBuilder;", "", "preserveSpaces", "", "(Z)V", "<set-?>", "", "error", "getError", "()Ljava/lang/String;", "firstQuote", "", "inQuote", "getInQuote", "()Z", "inUntranslatable", "lastCodepointWasSpace", "getLastCodepointWasSpace", "lastQuote", "rawStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "spanStack", "", "Lcom/android/aaptcompiler/Span;", "spans", "textBuilder", "untranslatableSections", "Lcom/android/aaptcompiler/UntranslatableSection;", "append", "str", "appendUnicodeEscapeSequence", "iter", "", "text", "clear", "", "endSpan", "endUntranslatable", "getFlattenedXml", "Lcom/android/aaptcompiler/FlattenedXml;", "resetTextState", "startSpan", "name", "startUntranslatable", "aaptcompiler"})
public final class XmlStringBuilder {
    private boolean inQuote;
    private boolean lastCodepointWasSpace;
    private int firstQuote;
    private int lastQuote;
    private StringBuilder rawStringBuilder;
    private StringBuilder textBuilder;
    private final List<Span> spans;
    private final List<Span> spanStack;
    private final List<UntranslatableSection> untranslatableSections;
    private boolean inUntranslatable;
    @NotNull
    private String error;
    private final boolean preserveSpaces;

    public final boolean getInQuote() {
        return this.inQuote;
    }

    public final boolean getLastCodepointWasSpace() {
        return this.lastCodepointWasSpace;
    }

    @NotNull
    public final String getError() {
        return this.error;
    }

    public final void clear() {
        this.inQuote = this.preserveSpaces;
        this.lastCodepointWasSpace = false;
        this.firstQuote = -1;
        this.lastQuote = -1;
        this.rawStringBuilder = new StringBuilder();
        this.textBuilder = new StringBuilder();
        this.spans.clear();
        this.spanStack.clear();
        this.untranslatableSections.clear();
        this.inUntranslatable = false;
        this.error = "";
    }

    @NotNull
    public final XmlStringBuilder append(@NotNull String str) {
        Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
        this.rawStringBuilder.append(str);
        PrimitiveIterator.OfInt codePoints = str.codePoints().iterator();
        block6: while (codePoints.hasNext()) {
            int codePoint = codePoints.nextInt();
            if (!Character.isValidCodePoint(codePoint)) {
                this.error = "Invalid unicode code point in string\n\"" + str + '\"';
                return this;
            }
            if (Character.isWhitespace(codePoint) && !this.preserveSpaces && !this.inQuote) {
                if (this.lastCodepointWasSpace) continue;
                this.textBuilder.append(' ');
                this.lastCodepointWasSpace = true;
                continue;
            }
            this.lastCodepointWasSpace = false;
            if (codePoint == 92) {
                if (!codePoints.hasNext()) continue;
                codePoint = codePoints.nextInt();
                switch (codePoint) {
                    case 116: {
                        this.textBuilder.append('\t');
                        continue block6;
                    }
                    case 110: {
                        this.textBuilder.append('\n');
                        continue block6;
                    }
                    case 34: 
                    case 35: 
                    case 39: 
                    case 63: 
                    case 64: 
                    case 92: {
                        this.textBuilder.appendCodePoint(codePoint);
                        continue block6;
                    }
                    case 117: {
                        PrimitiveIterator.OfInt ofInt = codePoints;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ofInt, (String)"codePoints");
                        if (this.appendUnicodeEscapeSequence(ofInt, this.textBuilder)) continue block6;
                        this.error = "Invalid unicode escape sequence in string\n\"" + str + '\"';
                        return this;
                    }
                }
                this.textBuilder.append(codePoint);
                continue;
            }
            if (codePoint == 34 && !this.preserveSpaces) {
                boolean bl = this.inQuote = !this.inQuote;
                if (this.firstQuote == -1) {
                    this.firstQuote = this.textBuilder.length();
                }
                this.lastQuote = this.textBuilder.length();
                continue;
            }
            if (codePoint == 39 && !this.preserveSpaces && !this.inQuote) {
                this.error = "Invalid unicode escape sequence in string\n\"{str}\"";
                return this;
            }
            this.textBuilder.appendCodePoint(codePoint);
        }
        return this;
    }

    @NotNull
    public final XmlStringBuilder startSpan(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        this.resetTextState();
        Span span = new Span(name, this.textBuilder.length(), 0, 4, null);
        this.spans.add(span);
        this.spanStack.add(span);
        return this;
    }

    @NotNull
    public final XmlStringBuilder endSpan() {
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        if (this.spanStack.isEmpty()) {
            this.error = "Unmatched span end.";
            return this;
        }
        this.resetTextState();
        Span lastSpan = this.spanStack.remove(CollectionsKt.getLastIndex(this.spanStack));
        lastSpan.setLastChar(this.textBuilder.length() - 1);
        return this;
    }

    @NotNull
    public final XmlStringBuilder startUntranslatable() {
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        if (this.inUntranslatable) {
            this.error = "Attempt to nest untranslatable sections in flattened xml, which is not allowed.";
            return this;
        }
        UntranslatableSection section = new UntranslatableSection(this.textBuilder.length(), 0, 2, null);
        this.untranslatableSections.add(section);
        this.inUntranslatable = true;
        return this;
    }

    @NotNull
    public final XmlStringBuilder endUntranslatable() {
        CharSequence charSequence = this.error;
        boolean bl = false;
        if (charSequence.length() > 0) {
            return this;
        }
        if (!this.inUntranslatable) {
            this.error = "Attempting to end untranslatable section while not in an untranslatable sections.";
            return this;
        }
        ((UntranslatableSection)CollectionsKt.last(this.untranslatableSections)).setEndIndex(this.textBuilder.length());
        this.inUntranslatable = false;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final FlattenedXml getFlattenedXml() {
        boolean bl;
        if (this.inUntranslatable) {
            this.error = "Attempting to flatten xml with unfinished untranslatable section.";
        }
        Collection collection = this.spanStack;
        boolean bl2 = false;
        if (!collection.isEmpty()) {
            this.error = "Attempting to flatten xml with unfinished spans.";
        }
        List untranslatables = this.untranslatableSections;
        String string = this.textBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"textBuilder.toString()");
        String text = string;
        if (this.spans.isEmpty()) {
            void $this$mapTo$iv$iv;
            int n;
            boolean bl3;
            int n2;
            switch (this.firstQuote) {
                case -1: {
                    int index2 = 0;
                    PrimitiveIterator.OfInt iterator = this.textBuilder.codePoints().iterator();
                    while (iterator.hasNext() && Character.isWhitespace(iterator.nextInt())) {
                        ++index2;
                    }
                    n2 = index2;
                    break;
                }
                default: {
                    n2 = this.firstQuote;
                }
            }
            int firstChar = n2;
            Collection index2 = this.untranslatableSections;
            int iterator = 0;
            if (!index2.isEmpty()) {
                int n3;
                int index2 = firstChar;
                iterator = ((UntranslatableSection)CollectionsKt.first(this.untranslatableSections)).getStartIndex();
                bl3 = false;
                firstChar = n3 = Math.min(index2, iterator);
            }
            switch (this.lastQuote) {
                case -1: {
                    int index32;
                    for (index32 = text.length() - 1; index32 > 0; --index32) {
                        String string2 = text;
                        boolean bl4 = false;
                        String string3 = string2;
                        if (string3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        if (!Character.isWhitespace(string3.codePointAt(index32))) break;
                    }
                    n = index32 + 1;
                    break;
                }
                default: {
                    n = this.lastQuote;
                }
            }
            int lastChar = n;
            Collection index32 = this.untranslatableSections;
            bl3 = false;
            if (!index32.isEmpty()) {
                int index32 = ((UntranslatableSection)CollectionsKt.last(this.untranslatableSections)).getEndIndex();
                bl3 = false;
                lastChar = Math.max(lastChar, index32);
            }
            Iterable $this$map$iv = this.untranslatableSections;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UntranslatableSection untranslatableSection = (UntranslatableSection)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl5 = false;
                UntranslatableSection untranslatableSection2 = it.shift(-firstChar);
                collection2.add(untranslatableSection2);
            }
            untranslatables = (List)destination$iv$iv;
            String string4 = this.textBuilder.substring(firstChar, lastChar);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"textBuilder.substring(firstChar, lastChar)");
            text = string4;
        }
        String string5 = this.rawStringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"rawStringBuilder.toString()");
        String raw = string5;
        CharSequence charSequence = this.error;
        List list = CollectionsKt.toList((Iterable)untranslatables);
        StyleString styleString = new StyleString(text, CollectionsKt.toList((Iterable)this.spans));
        String string6 = raw;
        boolean bl6 = false;
        boolean bl7 = bl = charSequence.length() == 0;
        List list2 = list;
        StyleString styleString2 = styleString;
        String string7 = string6;
        return new FlattenedXml(string7, styleString2, list2, bl7);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean appendUnicodeEscapeSequence(Iterator<Integer> iter, StringBuilder text) {
        int code = 0;
        int n = 1;
        int n2 = 4;
        while (n <= n2 && iter.hasNext()) {
            void i;
            int codePoint = ((Number)iter.next()).intValue();
            int value = ResourceTypesKt.parseHex(codePoint);
            if (value == -1) {
                return false;
            }
            code = code << 4 | value;
            ++i;
        }
        if (!Character.isValidCodePoint(code)) {
            return false;
        }
        text.appendCodePoint(code);
        return true;
    }

    private final void resetTextState() {
        this.inQuote = this.preserveSpaces;
        this.lastCodepointWasSpace = false;
    }

    public XmlStringBuilder(boolean preserveSpaces) {
        List list;
        this.inQuote = this.preserveSpaces = preserveSpaces;
        this.firstQuote = -1;
        this.lastQuote = -1;
        this.rawStringBuilder = new StringBuilder();
        this.textBuilder = new StringBuilder();
        XmlStringBuilder xmlStringBuilder = this;
        boolean bl = false;
        xmlStringBuilder.spans = list = (List)new ArrayList();
        xmlStringBuilder = this;
        bl = false;
        xmlStringBuilder.spanStack = list = (List)new ArrayList();
        xmlStringBuilder = this;
        bl = false;
        xmlStringBuilder.untranslatableSections = list = (List)new ArrayList();
        this.error = "";
    }

    public /* synthetic */ XmlStringBuilder(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public XmlStringBuilder() {
        this(false, 1, null);
    }
}

