/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl;

import com.amazon.ion.BufferConfiguration;
import com.amazon.ion.IonReader;
import com.amazon.ion.impl.ReaderLookaheadBuffer;
import com.amazon.ion.impl.ResizingPipedInputStream;
import com.amazon.ion.system.IonReaderBuilder;
import java.io.InputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ReaderLookaheadBufferBase
implements ReaderLookaheadBuffer {
    private final InputStream input;
    protected final ResizingPipedInputStream pipe;
    private final int maximumBufferSize;
    protected final BufferConfiguration.OversizedValueHandler oversizedValueHandler;
    protected final BufferConfiguration.DataHandler dataHandler;
    private int markedAvailable;
    private int markedReadIndex;
    private boolean isSkippingCurrentValue;

    ReaderLookaheadBufferBase(BufferConfiguration<?> configuration, InputStream inputStream) {
        this.input = inputStream;
        this.pipe = new ResizingPipedInputStream(configuration.getInitialBufferSize(), configuration.getMaximumBufferSize(), true);
        this.maximumBufferSize = configuration.getMaximumBufferSize();
        this.oversizedValueHandler = configuration.getOversizedValueHandler();
        this.dataHandler = configuration.getDataHandler();
        this.clearMark();
    }

    @Override
    public final void fillInput() throws Exception {
        this.clearMark();
        this.fillInputHelper();
    }

    protected abstract void fillInputHelper() throws Exception;

    @Override
    public final int available() {
        return this.pipe.available();
    }

    @Override
    public final IonReader newIonReader(IonReaderBuilder builder) {
        return builder.build(this.pipe);
    }

    public final void mark() {
        if (this.moreDataRequired()) {
            throw new IllegalStateException("moreDataRequired() must be false before calling mark().");
        }
        this.uncheckedMark();
    }

    final void uncheckedMark() {
        this.markedAvailable = this.available();
        this.markedReadIndex = this.pipe.getReadIndex();
    }

    public final void rewind() {
        if (this.markedReadIndex < 0 || this.markedAvailable < 0) {
            throw new IllegalStateException("Must call mark() before rewind().");
        }
        this.pipe.rewind(this.markedReadIndex, this.markedAvailable);
    }

    abstract void truncateToEndOfPreviousValue() throws Exception;

    public final void clearMark() {
        this.markedAvailable = -1;
        this.markedReadIndex = -1;
    }

    protected InputStream getPipe() {
        return this.pipe;
    }

    protected InputStream getInput() {
        return this.input;
    }

    protected void startNewValue() {
        this.isSkippingCurrentValue = false;
    }

    protected void startSkippingValue() throws Exception {
        if (!this.isSkippingCurrentValue) {
            this.isSkippingCurrentValue = true;
            this.truncateToEndOfPreviousValue();
        }
    }

    protected boolean isSkippingCurrentValue() {
        return this.isSkippingCurrentValue;
    }

    protected int getMaximumBufferSize() {
        return this.maximumBufferSize;
    }
}

