/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import androidx.annotation.RestrictTo;
import androidx.work.multiprocess.IWorkManagerImplCallback;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public interface IWorkManagerImpl
extends IInterface {
    public static final String DESCRIPTOR = "androidx$work$multiprocess$IWorkManagerImpl".replace('$', '.');

    public void enqueueWorkRequests(byte[] var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void updateUniquePeriodicWorkRequest(String var1, byte[] var2, IWorkManagerImplCallback var3) throws RemoteException;

    public void enqueueContinuation(byte[] var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void cancelWorkById(String var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void cancelAllWorkByTag(String var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void cancelUniqueWork(String var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void cancelAllWork(IWorkManagerImplCallback var1) throws RemoteException;

    public void queryWorkInfo(byte[] var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void setProgress(byte[] var1, IWorkManagerImplCallback var2) throws RemoteException;

    public void setForegroundAsync(byte[] var1, IWorkManagerImplCallback var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWorkManagerImpl {
        static final int TRANSACTION_enqueueWorkRequests = 1;
        static final int TRANSACTION_updateUniquePeriodicWorkRequest = 2;
        static final int TRANSACTION_enqueueContinuation = 3;
        static final int TRANSACTION_cancelWorkById = 4;
        static final int TRANSACTION_cancelAllWorkByTag = 5;
        static final int TRANSACTION_cancelUniqueWork = 6;
        static final int TRANSACTION_cancelAllWork = 7;
        static final int TRANSACTION_queryWorkInfo = 8;
        static final int TRANSACTION_setProgress = 9;
        static final int TRANSACTION_setForegroundAsync = 10;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWorkManagerImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWorkManagerImpl) {
                return (IWorkManagerImpl)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    byte[] _arg0 = data.createByteArray();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.enqueueWorkRequests(_arg0, _arg1);
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    byte[] _arg1 = data.createByteArray();
                    IWorkManagerImplCallback _arg2 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.updateUniquePeriodicWorkRequest(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    byte[] _arg0 = data.createByteArray();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.enqueueContinuation(_arg0, _arg1);
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.cancelWorkById(_arg0, _arg1);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.cancelAllWorkByTag(_arg0, _arg1);
                    break;
                }
                case 6: {
                    String _arg0 = data.readString();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.cancelUniqueWork(_arg0, _arg1);
                    break;
                }
                case 7: {
                    IWorkManagerImplCallback _arg0 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.cancelAllWork(_arg0);
                    break;
                }
                case 8: {
                    byte[] _arg0 = data.createByteArray();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.queryWorkInfo(_arg0, _arg1);
                    break;
                }
                case 9: {
                    byte[] _arg0 = data.createByteArray();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.setProgress(_arg0, _arg1);
                    break;
                }
                case 10: {
                    byte[] _arg0 = data.createByteArray();
                    IWorkManagerImplCallback _arg1 = IWorkManagerImplCallback.Stub.asInterface(data.readStrongBinder());
                    this.setForegroundAsync(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        private static class Proxy
        implements IWorkManagerImpl {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enqueueWorkRequests(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(request);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateUniquePeriodicWorkRequest(String name, byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeByteArray(request);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enqueueContinuation(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(request);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelWorkById(String id, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(id);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAllWorkByTag(String tag, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(tag);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelUniqueWork(String name, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeString(name);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void cancelAllWork(IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryWorkInfo(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(request);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setProgress(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(request);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setForegroundAsync(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(DESCRIPTOR);
                    _data.writeByteArray(request);
                    _data.writeStrongInterface((IInterface)callback);
                    boolean bl = this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IWorkManagerImpl {
        @Override
        public void enqueueWorkRequests(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void updateUniquePeriodicWorkRequest(String name, byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void enqueueContinuation(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void cancelWorkById(String id, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void cancelAllWorkByTag(String tag, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void cancelUniqueWork(String name, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void cancelAllWork(IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void queryWorkInfo(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void setProgress(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
        }

        @Override
        public void setForegroundAsync(byte[] request, IWorkManagerImplCallback callback) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

