/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.work.ListenableFutureKt;
import androidx.work.WorkInfo;
import androidx.work.WorkQuery;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.RawQueries;
import androidx.work.impl.utils.taskexecutor.SerialExecutor;
import androidx.work.impl.utils.taskexecutor.TaskExecutor;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a.\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0002H\u0000\u001a(\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0000\u001a$\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0000\u001a(\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bH\u0000\u001a(\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a4\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0001\"\u0004\b\u0000\u0010\u0014*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u00140\u0016H\u0002\u00a8\u0006\u0017"}, d2={"forStringIds", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "Landroidx/work/WorkInfo;", "Landroidx/work/impl/WorkDatabase;", "executor", "Landroidx/work/impl/utils/taskexecutor/TaskExecutor;", "ids", "", "forTag", "tag", "forUUID", "id", "Ljava/util/UUID;", "forUniqueWork", "name", "forWorkQuerySpec", "querySpec", "Landroidx/work/WorkQuery;", "loadStatusFuture", "T", "block", "Lkotlin/Function1;", "work-runtime_release"})
@JvmName(name="StatusRunnable")
public final class StatusRunnable {
    @NotNull
    public static final ListenableFuture<List<WorkInfo>> forStringIds(@NotNull WorkDatabase $this$forStringIds, @NotNull TaskExecutor executor, @NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forStringIds), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        return StatusRunnable.loadStatusFuture($this$forStringIds, executor, (Function1)new Function1<WorkDatabase, List<? extends WorkInfo>>(ids){
            final /* synthetic */ List<String> $ids;
            {
                this.$ids = $ids;
                super(1);
            }

            public final List<WorkInfo> invoke(WorkDatabase db) {
                Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
                Object object = WorkSpec.WORK_INFO_MAPPER.apply(db.workSpecDao().getWorkStatusPojoForIds(this.$ids));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WORK_INFO_MAPPER.apply(d\u2026orkStatusPojoForIds(ids))");
                return (List)object;
            }
        });
    }

    @NotNull
    public static final ListenableFuture<WorkInfo> forUUID(@NotNull WorkDatabase $this$forUUID, @NotNull TaskExecutor executor, @NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forUUID), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return StatusRunnable.loadStatusFuture($this$forUUID, executor, (Function1)new Function1<WorkDatabase, WorkInfo>(id){
            final /* synthetic */ UUID $id;
            {
                this.$id = $id;
                super(1);
            }

            public final WorkInfo invoke(WorkDatabase db) {
                Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
                WorkSpecDao workSpecDao = db.workSpecDao();
                String string = this.$id.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
                WorkSpec.WorkInfoPojo workInfoPojo = workSpecDao.getWorkStatusPojoForId(string);
                return workInfoPojo != null ? workInfoPojo.toWorkInfo() : null;
            }
        });
    }

    @NotNull
    public static final ListenableFuture<List<WorkInfo>> forTag(@NotNull WorkDatabase $this$forTag, @NotNull TaskExecutor executor, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forTag), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return StatusRunnable.loadStatusFuture($this$forTag, executor, (Function1)new Function1<WorkDatabase, List<? extends WorkInfo>>(tag){
            final /* synthetic */ String $tag;
            {
                this.$tag = $tag;
                super(1);
            }

            public final List<WorkInfo> invoke(WorkDatabase db) {
                Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
                Object object = WorkSpec.WORK_INFO_MAPPER.apply(db.workSpecDao().getWorkStatusPojoForTag(this.$tag));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WORK_INFO_MAPPER.apply(d\u2026orkStatusPojoForTag(tag))");
                return (List)object;
            }
        });
    }

    @NotNull
    public static final ListenableFuture<List<WorkInfo>> forUniqueWork(@NotNull WorkDatabase $this$forUniqueWork, @NotNull TaskExecutor executor, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forUniqueWork), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StatusRunnable.loadStatusFuture($this$forUniqueWork, executor, (Function1)new Function1<WorkDatabase, List<? extends WorkInfo>>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            public final List<WorkInfo> invoke(WorkDatabase db) {
                Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
                Object object = WorkSpec.WORK_INFO_MAPPER.apply(db.workSpecDao().getWorkStatusPojoForName(this.$name));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WORK_INFO_MAPPER.apply(d\u2026kStatusPojoForName(name))");
                return (List)object;
            }
        });
    }

    @NotNull
    public static final ListenableFuture<List<WorkInfo>> forWorkQuerySpec(@NotNull WorkDatabase $this$forWorkQuerySpec, @NotNull TaskExecutor executor, @NotNull WorkQuery querySpec) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$forWorkQuerySpec), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)querySpec, (String)"querySpec");
        return StatusRunnable.loadStatusFuture($this$forWorkQuerySpec, executor, (Function1)new Function1<WorkDatabase, List<? extends WorkInfo>>(querySpec){
            final /* synthetic */ WorkQuery $querySpec;
            {
                this.$querySpec = $querySpec;
                super(1);
            }

            public final List<WorkInfo> invoke(WorkDatabase db) {
                Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
                Object object = WorkSpec.WORK_INFO_MAPPER.apply(db.rawWorkInfoDao().getWorkInfoPojos(RawQueries.toRawQuery(this.$querySpec)));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"WORK_INFO_MAPPER.apply(d\u2026(querySpec.toRawQuery()))");
                return (List)object;
            }
        });
    }

    private static final <T> ListenableFuture<T> loadStatusFuture(WorkDatabase $this$loadStatusFuture, TaskExecutor executor, Function1<? super WorkDatabase, ? extends T> block) {
        SerialExecutor serialExecutor = executor.getSerialTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)serialExecutor, (String)"executor.serialTaskExecutor");
        return ListenableFutureKt.executeAsync(serialExecutor, "loadStatusFuture", (Function0)new Function0<T>(block, $this$loadStatusFuture){
            final /* synthetic */ Function1<WorkDatabase, T> $block;
            final /* synthetic */ WorkDatabase $this_loadStatusFuture;
            {
                this.$block = $block;
                this.$this_loadStatusFuture = $receiver;
                super(0);
            }

            public final T invoke() {
                return (T)this.$block.invoke((Object)((Object)this.$this_loadStatusFuture));
            }
        });
    }
}

