/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.work.Operation;
import androidx.work.OperationKt;
import androidx.work.Tracer;
import androidx.work.WorkInfo;
import androidx.work.impl.Processor;
import androidx.work.impl.Scheduler;
import androidx.work.impl.Schedulers;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.model.DependencyDao;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.CancelWorkRunnable;
import androidx.work.impl.utils.PreferenceUtils;
import androidx.work.impl.utils.taskexecutor.SerialExecutor;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0018\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"cancel", "", "workManagerImpl", "Landroidx/work/impl/WorkManagerImpl;", "workSpecId", "", "forAll", "Landroidx/work/Operation;", "forId", "id", "Ljava/util/UUID;", "forName", "name", "forNameInline", "forTag", "tag", "iterativelyCancelWorkAndDependents", "workDatabase", "Landroidx/work/impl/WorkDatabase;", "reschedulePendingWorkers", "work-runtime_release"})
@JvmName(name="CancelWorkRunnable")
public final class CancelWorkRunnable {
    private static final void cancel(WorkManagerImpl workManagerImpl, String workSpecId) {
        WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workManagerImpl.workDatabase");
        CancelWorkRunnable.iterativelyCancelWorkAndDependents(workDatabase, workSpecId);
        Processor processor = workManagerImpl.getProcessor();
        Intrinsics.checkNotNullExpressionValue((Object)processor, (String)"workManagerImpl.processor");
        Processor processor2 = processor;
        processor2.stopAndCancelWork(workSpecId, 1);
        for (Scheduler scheduler : workManagerImpl.getSchedulers()) {
            scheduler.cancel(workSpecId);
        }
    }

    private static final void reschedulePendingWorkers(WorkManagerImpl workManagerImpl) {
        Schedulers.schedule(workManagerImpl.getConfiguration(), workManagerImpl.getWorkDatabase(), workManagerImpl.getSchedulers());
    }

    private static final void iterativelyCancelWorkAndDependents(WorkDatabase workDatabase, String workSpecId) {
        WorkSpecDao workSpecDao = workDatabase.workSpecDao();
        DependencyDao dependencyDao = workDatabase.dependencyDao();
        Object[] objectArray = new String[]{workSpecId};
        List idsToProcess = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)idsToProcess).isEmpty()) {
            String id = (String)CollectionsKt.removeLast((List)idsToProcess);
            WorkInfo.State state = workSpecDao.getState(id);
            if (state != WorkInfo.State.SUCCEEDED && state != WorkInfo.State.FAILED) {
                workSpecDao.setCancelledState(id);
            }
            idsToProcess.addAll((Collection)dependencyDao.getDependentWorkIds(id));
        }
    }

    @NotNull
    public static final Operation forId(@NotNull UUID id, @NotNull WorkManagerImpl workManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)workManagerImpl, (String)"workManagerImpl");
        Tracer tracer2 = workManagerImpl.getConfiguration().getTracer();
        SerialExecutor serialExecutor = workManagerImpl.getWorkTaskExecutor().getSerialTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)serialExecutor, (String)"workManagerImpl.workTask\u2026ecutor.serialTaskExecutor");
        return OperationKt.launchOperation(tracer2, "CancelWorkById", serialExecutor, (Function0<Unit>)((Function0)new Function0<Unit>(workManagerImpl, id){
            final /* synthetic */ WorkManagerImpl $workManagerImpl;
            final /* synthetic */ UUID $id;
            {
                this.$workManagerImpl = $workManagerImpl;
                this.$id = $id;
                super(0);
            }

            public final void invoke() {
                WorkDatabase workDatabase = this.$workManagerImpl.getWorkDatabase();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workManagerImpl.workDatabase");
                WorkDatabase workDatabase2 = workDatabase;
                workDatabase2.runInTransaction(() -> forId.1.invoke$lambda$0(this.$workManagerImpl, this.$id));
                CancelWorkRunnable.access$reschedulePendingWorkers(this.$workManagerImpl);
            }

            private static final void invoke$lambda$0(WorkManagerImpl $workManagerImpl, UUID $id) {
                Intrinsics.checkNotNullParameter((Object)$workManagerImpl, (String)"$workManagerImpl");
                Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
                String string = $id.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"id.toString()");
                CancelWorkRunnable.access$cancel($workManagerImpl, string);
            }
        }));
    }

    @NotNull
    public static final Operation forTag(@NotNull String tag, @NotNull WorkManagerImpl workManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)workManagerImpl, (String)"workManagerImpl");
        Tracer tracer2 = workManagerImpl.getConfiguration().getTracer();
        String string = "CancelWorkByTag_" + tag;
        SerialExecutor serialExecutor = workManagerImpl.getWorkTaskExecutor().getSerialTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)serialExecutor, (String)"workManagerImpl.workTask\u2026ecutor.serialTaskExecutor");
        return OperationKt.launchOperation(tracer2, string, serialExecutor, (Function0<Unit>)((Function0)new Function0<Unit>(workManagerImpl, tag){
            final /* synthetic */ WorkManagerImpl $workManagerImpl;
            final /* synthetic */ String $tag;
            {
                this.$workManagerImpl = $workManagerImpl;
                this.$tag = $tag;
                super(0);
            }

            public final void invoke() {
                WorkDatabase workDatabase = this.$workManagerImpl.getWorkDatabase();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workManagerImpl.workDatabase");
                WorkDatabase workDatabase2 = workDatabase;
                workDatabase2.runInTransaction(() -> forTag.1.invoke$lambda$0(workDatabase2, this.$tag, this.$workManagerImpl));
                CancelWorkRunnable.access$reschedulePendingWorkers(this.$workManagerImpl);
            }

            private static final void invoke$lambda$0(WorkDatabase $workDatabase, String $tag, WorkManagerImpl $workManagerImpl) {
                Intrinsics.checkNotNullParameter((Object)((Object)$workDatabase), (String)"$workDatabase");
                Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
                Intrinsics.checkNotNullParameter((Object)$workManagerImpl, (String)"$workManagerImpl");
                WorkSpecDao workSpecDao = $workDatabase.workSpecDao();
                List<String> workSpecIds = workSpecDao.getUnfinishedWorkWithTag($tag);
                for (String workSpecId : workSpecIds) {
                    CancelWorkRunnable.access$cancel($workManagerImpl, workSpecId);
                }
            }
        }));
    }

    @NotNull
    public static final Operation forName(@NotNull String name, @NotNull WorkManagerImpl workManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)workManagerImpl, (String)"workManagerImpl");
        Tracer tracer2 = workManagerImpl.getConfiguration().getTracer();
        String string = "CancelWorkByName_" + name;
        SerialExecutor serialExecutor = workManagerImpl.getWorkTaskExecutor().getSerialTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)serialExecutor, (String)"workManagerImpl.workTask\u2026ecutor.serialTaskExecutor");
        return OperationKt.launchOperation(tracer2, string, serialExecutor, (Function0<Unit>)((Function0)new Function0<Unit>(name, workManagerImpl){
            final /* synthetic */ String $name;
            final /* synthetic */ WorkManagerImpl $workManagerImpl;
            {
                this.$name = $name;
                this.$workManagerImpl = $workManagerImpl;
                super(0);
            }

            public final void invoke() {
                CancelWorkRunnable.forNameInline(this.$name, this.$workManagerImpl);
                CancelWorkRunnable.access$reschedulePendingWorkers(this.$workManagerImpl);
            }
        }));
    }

    public static final void forNameInline(@NotNull String name, @NotNull WorkManagerImpl workManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)workManagerImpl, (String)"workManagerImpl");
        WorkDatabase workDatabase = workManagerImpl.getWorkDatabase();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workManagerImpl.workDatabase");
        WorkDatabase workDatabase2 = workDatabase;
        workDatabase2.runInTransaction(() -> CancelWorkRunnable.forNameInline$lambda$0(workDatabase2, name, workManagerImpl));
    }

    @NotNull
    public static final Operation forAll(@NotNull WorkManagerImpl workManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)workManagerImpl, (String)"workManagerImpl");
        Tracer tracer2 = workManagerImpl.getConfiguration().getTracer();
        SerialExecutor serialExecutor = workManagerImpl.getWorkTaskExecutor().getSerialTaskExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)serialExecutor, (String)"workManagerImpl.workTask\u2026ecutor.serialTaskExecutor");
        return OperationKt.launchOperation(tracer2, "CancelAllWork", serialExecutor, (Function0<Unit>)((Function0)new Function0<Unit>(workManagerImpl){
            final /* synthetic */ WorkManagerImpl $workManagerImpl;
            {
                this.$workManagerImpl = $workManagerImpl;
                super(0);
            }

            public final void invoke() {
                WorkDatabase workDatabase = this.$workManagerImpl.getWorkDatabase();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)workDatabase), (String)"workManagerImpl.workDatabase");
                WorkDatabase workDatabase2 = workDatabase;
                workDatabase2.runInTransaction(() -> forAll.1.invoke$lambda$0(workDatabase2, this.$workManagerImpl));
            }

            private static final void invoke$lambda$0(WorkDatabase $workDatabase, WorkManagerImpl $workManagerImpl) {
                Intrinsics.checkNotNullParameter((Object)((Object)$workDatabase), (String)"$workDatabase");
                Intrinsics.checkNotNullParameter((Object)$workManagerImpl, (String)"$workManagerImpl");
                WorkSpecDao workSpecDao = $workDatabase.workSpecDao();
                List<String> workSpecIds = workSpecDao.getAllUnfinishedWork();
                for (String workSpecId : workSpecIds) {
                    CancelWorkRunnable.access$cancel($workManagerImpl, workSpecId);
                }
                new PreferenceUtils($workDatabase).setLastCancelAllTimeMillis($workManagerImpl.getConfiguration().getClock().currentTimeMillis());
            }
        }));
    }

    private static final void forNameInline$lambda$0(WorkDatabase $workDatabase, String $name, WorkManagerImpl $workManagerImpl) {
        Intrinsics.checkNotNullParameter((Object)((Object)$workDatabase), (String)"$workDatabase");
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$workManagerImpl, (String)"$workManagerImpl");
        WorkSpecDao workSpecDao = $workDatabase.workSpecDao();
        List<String> workSpecIds = workSpecDao.getUnfinishedWorkWithName($name);
        for (String workSpecId : workSpecIds) {
            CancelWorkRunnable.cancel($workManagerImpl, workSpecId);
        }
    }

    public static final /* synthetic */ void access$reschedulePendingWorkers(WorkManagerImpl workManagerImpl) {
        CancelWorkRunnable.reschedulePendingWorkers(workManagerImpl);
    }

    public static final /* synthetic */ void access$cancel(WorkManagerImpl workManagerImpl, String workSpecId) {
        CancelWorkRunnable.cancel(workManagerImpl, workSpecId);
    }
}

