/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.ComponentName;
import androidx.annotation.RestrictTo;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0001H\u0007\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\u0001H\u0007\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a!\u0010\n\u001a\u00020\t\"\n\b\u0000\u0010\u000b\u0018\u0001*\u00020\f*\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\b\u001a\u001a\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"buildDelegatedRemoteRequestData", "Landroidx/work/Data;", "delegatedWorkerName", "", "componentName", "Landroid/content/ComponentName;", "inputData", "isRemoteWorkRequest", "", "Landroidx/work/WorkerParameters;", "usingRemoteService", "T", "Landroidx/work/ListenableWorker;", "workerClassName", "work-runtime_release"})
@JvmName(name="WorkerParametersExtensions")
@SourceDebugExtension(value={"SMAP\nWorkerParameters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WorkerParameters.kt\nandroidx/work/WorkerParametersExtensions\n+ 2 Data_.kt\nandroidx/work/Data\n*L\n1#1,100:1\n229#2:101\n229#2:102\n229#2:103\n*S KotlinDebug\n*F\n+ 1 WorkerParameters.kt\nandroidx/work/WorkerParametersExtensions\n*L\n96#1:101\n97#1:102\n98#1:103\n*E\n"})
public final class WorkerParametersExtensions {
    public static final boolean isRemoteWorkRequest(@NotNull WorkerParameters $this$isRemoteWorkRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$isRemoteWorkRequest, (String)"<this>");
        Data data = $this$isRemoteWorkRequest.getInputData();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"inputData");
        return WorkerParametersExtensions.isRemoteWorkRequest(data);
    }

    public static final /* synthetic */ <T extends ListenableWorker> WorkerParameters usingRemoteService(WorkerParameters $this$usingRemoteService, ComponentName componentName) {
        Intrinsics.checkNotNullParameter((Object)$this$usingRemoteService, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        boolean $i$f$usingRemoteService = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        String string = ListenableWorker.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"T::class.java.name");
        return WorkerParametersExtensions.usingRemoteService($this$usingRemoteService, string, componentName);
    }

    @NotNull
    public static final WorkerParameters usingRemoteService(@NotNull WorkerParameters $this$usingRemoteService, @NotNull String workerClassName, @NotNull ComponentName componentName) {
        Intrinsics.checkNotNullParameter((Object)$this$usingRemoteService, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)workerClassName, (String)"workerClassName");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        UUID uUID = $this$usingRemoteService.getId();
        Data data = $this$usingRemoteService.getInputData();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"inputData");
        return new WorkerParameters(uUID, WorkerParametersExtensions.buildDelegatedRemoteRequestData(workerClassName, componentName, data), (Collection<String>)$this$usingRemoteService.getTags(), $this$usingRemoteService.getRuntimeExtras(), $this$usingRemoteService.getRunAttemptCount(), $this$usingRemoteService.getGeneration(), $this$usingRemoteService.getBackgroundExecutor(), $this$usingRemoteService.getWorkerContext(), $this$usingRemoteService.getTaskExecutor(), $this$usingRemoteService.getWorkerFactory(), $this$usingRemoteService.getProgressUpdater(), $this$usingRemoteService.getForegroundUpdater());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NotNull
    public static final Data buildDelegatedRemoteRequestData(@NotNull String delegatedWorkerName, @NotNull ComponentName componentName, @NotNull Data inputData) {
        Intrinsics.checkNotNullParameter((Object)delegatedWorkerName, (String)"delegatedWorkerName");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        Data.Builder builder = new Data.Builder();
        builder.putAll(inputData).putString("androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_PACKAGE_NAME", componentName.getPackageName()).putString("androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_CLASS_NAME", componentName.getClassName()).putString("androidx.work.multiprocess.RemoteListenableDelegatingWorker.ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME", delegatedWorkerName);
        return builder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean isRemoteWorkRequest(@NotNull Data $this$isRemoteWorkRequest) {
        Data this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$isRemoteWorkRequest, (String)"<this>");
        Data data = $this$isRemoteWorkRequest;
        String key$iv = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_PACKAGE_NAME";
        boolean $i$f$hasKey$work_runtime_release = false;
        if (!this_$iv.hasKeyWithValueOfType(key$iv, String.class)) return false;
        this_$iv = $this$isRemoteWorkRequest;
        key$iv = "androidx.work.impl.workers.RemoteListenableWorker.ARGUMENT_CLASS_NAME";
        $i$f$hasKey$work_runtime_release = false;
        if (!this_$iv.hasKeyWithValueOfType(key$iv, String.class)) return false;
        this_$iv = $this$isRemoteWorkRequest;
        key$iv = "androidx.work.multiprocess.RemoteListenableDelegatingWorker.ARGUMENT_REMOTE_LISTENABLE_WORKER_NAME";
        $i$f$hasKey$work_runtime_release = false;
        if (!this_$iv.hasKeyWithValueOfType(key$iv, String.class)) return false;
        return true;
    }
}

