/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.workers;

import android.os.Build;
import androidx.work.Logger;
import androidx.work.impl.model.SystemIdInfo;
import androidx.work.impl.model.SystemIdInfoDao;
import androidx.work.impl.model.WorkNameDao;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecKt;
import androidx.work.impl.model.WorkTagDao;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u001a/\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0001H\u0002\u00a2\u0006\u0002\u0010\t\u001a.\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"TAG", "", "workSpecRow", "workSpec", "Landroidx/work/impl/model/WorkSpec;", "name", "systemId", "", "tags", "(Landroidx/work/impl/model/WorkSpec;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "workSpecRows", "workNameDao", "Landroidx/work/impl/model/WorkNameDao;", "workTagDao", "Landroidx/work/impl/model/WorkTagDao;", "systemIdInfoDao", "Landroidx/work/impl/model/SystemIdInfoDao;", "workSpecs", "", "work-runtime_release"})
@SourceDebugExtension(value={"SMAP\nDiagnosticsWorker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsWorker.kt\nandroidx/work/impl/workers/DiagnosticsWorkerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1855#2,2:89\n*S KotlinDebug\n*F\n+ 1 DiagnosticsWorker.kt\nandroidx/work/impl/workers/DiagnosticsWorkerKt\n*L\n77#1:89,2\n*E\n"})
public final class DiagnosticsWorkerKt {
    @NotNull
    private static final String TAG;

    private static final String workSpecRows(WorkNameDao workNameDao, WorkTagDao workTagDao, SystemIdInfoDao systemIdInfoDao, List<WorkSpec> workSpecs) {
        StringBuilder stringBuilder;
        StringBuilder $this$workSpecRows_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String systemIdHeader = Build.VERSION.SDK_INT >= 23 ? "Job Id" : "Alarm Id";
        String header = "\n Id \t Class Name\t " + systemIdHeader + "\t State\t Unique Name\t Tags\t";
        $this$workSpecRows_u24lambda_u241.append(header);
        Iterable $this$forEach$iv = workSpecs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WorkSpec workSpec = (WorkSpec)element$iv;
            boolean bl2 = false;
            SystemIdInfo systemIdInfo = systemIdInfoDao.getSystemIdInfo(WorkSpecKt.generationalId(workSpec));
            Integer systemId = systemIdInfo != null ? Integer.valueOf(systemIdInfo.systemId) : null;
            String names = CollectionsKt.joinToString$default((Iterable)workNameDao.getNamesForWorkSpecId(workSpec.id), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            String tags = CollectionsKt.joinToString$default((Iterable)workTagDao.getTagsForWorkSpecId(workSpec.id), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            $this$workSpecRows_u24lambda_u241.append(DiagnosticsWorkerKt.workSpecRow(workSpec, names, systemId, tags));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String workSpecRow(WorkSpec workSpec, String name, Integer systemId, String tags) {
        return '\n' + workSpec.id + "\t " + workSpec.workerClassName + "\t " + systemId + "\t " + workSpec.state.name() + "\t " + name + "\t " + tags + '\t';
    }

    public static final /* synthetic */ String access$getTAG$p() {
        return TAG;
    }

    public static final /* synthetic */ String access$workSpecRows(WorkNameDao workNameDao, WorkTagDao workTagDao, SystemIdInfoDao systemIdInfoDao, List workSpecs) {
        return DiagnosticsWorkerKt.workSpecRows(workNameDao, workTagDao, systemIdInfoDao, workSpecs);
    }

    static {
        String string = Logger.tagWithPrefix("DiagnosticsWrkr");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagWithPrefix(\"DiagnosticsWrkr\")");
        TAG = string;
    }
}

