/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl.utils;

import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import androidx.work.impl.utils.taskexecutor.SerialExecutor;
import java.util.ArrayDeque;
import java.util.concurrent.Executor;

public class SerialExecutorImpl
implements SerialExecutor {
    private final ArrayDeque<Task> mTasks;
    private final Executor mExecutor;
    @GuardedBy(value="mLock")
    private Runnable mActive;
    final Object mLock;

    public SerialExecutorImpl(@NonNull Executor executor) {
        this.mExecutor = executor;
        this.mTasks = new ArrayDeque();
        this.mLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(@NonNull Runnable command) {
        Object object = this.mLock;
        synchronized (object) {
            this.mTasks.add(new Task(this, command));
            if (this.mActive == null) {
                this.scheduleNext();
            }
        }
    }

    @GuardedBy(value="mLock")
    void scheduleNext() {
        this.mActive = this.mTasks.poll();
        if (this.mActive != null) {
            this.mExecutor.execute(this.mActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasPendingTasks() {
        Object object = this.mLock;
        synchronized (object) {
            return !this.mTasks.isEmpty();
        }
    }

    @NonNull
    @VisibleForTesting
    public Executor getDelegatedExecutor() {
        return this.mExecutor;
    }

    static class Task
    implements Runnable {
        final SerialExecutorImpl mSerialExecutor;
        final Runnable mRunnable;

        Task(@NonNull SerialExecutorImpl serialExecutor, @NonNull Runnable runnable) {
            this.mSerialExecutor = serialExecutor;
            this.mRunnable = runnable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.mRunnable.run();
            }
            finally {
                Object object = this.mSerialExecutor.mLock;
                synchronized (object) {
                    this.mSerialExecutor.scheduleNext();
                }
            }
        }
    }
}

