/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.impl;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.Clock;
import androidx.work.Configuration;
import androidx.work.Logger;
import androidx.work.impl.Processor;
import androidx.work.impl.Scheduler;
import androidx.work.impl.WorkDatabase;
import androidx.work.impl.background.systemalarm.SystemAlarmScheduler;
import androidx.work.impl.background.systemalarm.SystemAlarmService;
import androidx.work.impl.background.systemjob.SystemJobScheduler;
import androidx.work.impl.background.systemjob.SystemJobService;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkSpecDao;
import androidx.work.impl.utils.PackageManagerHelper;
import java.util.List;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Schedulers {
    public static final String GCM_SCHEDULER = "androidx.work.impl.background.gcm.GcmScheduler";
    private static final String TAG = Logger.tagWithPrefix("Schedulers");

    public static void registerRescheduling(@NonNull List<Scheduler> schedulers2, @NonNull Processor processor, @NonNull Executor executor, @NonNull WorkDatabase workDatabase, @NonNull Configuration configuration) {
        processor.addExecutionListener((id, needsReschedule) -> executor.execute(() -> {
            for (Scheduler scheduler : schedulers2) {
                scheduler.cancel(id.getWorkSpecId());
            }
            Schedulers.schedule(configuration, workDatabase, schedulers2);
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void schedule(@NonNull Configuration configuration, @NonNull WorkDatabase workDatabase, @Nullable List<Scheduler> schedulers2) {
        List<WorkSpec> allEligibleWorkSpecs;
        List<WorkSpec> eligibleWorkSpecsForLimitedSlots;
        if (schedulers2 == null || schedulers2.size() == 0) {
            return;
        }
        WorkSpecDao workSpecDao = workDatabase.workSpecDao();
        workDatabase.beginTransaction();
        try {
            List<WorkSpec> contentUriWorkSpecs = null;
            if (Build.VERSION.SDK_INT >= 24) {
                contentUriWorkSpecs = workSpecDao.getEligibleWorkForSchedulingWithContentUris();
                Schedulers.markScheduled(workSpecDao, configuration.getClock(), contentUriWorkSpecs);
            }
            eligibleWorkSpecsForLimitedSlots = workSpecDao.getEligibleWorkForScheduling(configuration.getMaxSchedulerLimit());
            Schedulers.markScheduled(workSpecDao, configuration.getClock(), eligibleWorkSpecsForLimitedSlots);
            if (contentUriWorkSpecs != null) {
                eligibleWorkSpecsForLimitedSlots.addAll(contentUriWorkSpecs);
            }
            allEligibleWorkSpecs = workSpecDao.getAllEligibleWorkSpecsForScheduling(200);
            workDatabase.setTransactionSuccessful();
        }
        finally {
            workDatabase.endTransaction();
        }
        if (eligibleWorkSpecsForLimitedSlots.size() > 0) {
            WorkSpec[] eligibleWorkSpecsArray = new WorkSpec[eligibleWorkSpecsForLimitedSlots.size()];
            eligibleWorkSpecsArray = eligibleWorkSpecsForLimitedSlots.toArray(eligibleWorkSpecsArray);
            for (Scheduler scheduler : schedulers2) {
                if (!scheduler.hasLimitedSchedulingSlots()) continue;
                scheduler.schedule(eligibleWorkSpecsArray);
            }
        }
        if (allEligibleWorkSpecs.size() > 0) {
            WorkSpec[] enqueuedWorkSpecsArray = new WorkSpec[allEligibleWorkSpecs.size()];
            enqueuedWorkSpecsArray = allEligibleWorkSpecs.toArray(enqueuedWorkSpecsArray);
            for (Scheduler scheduler : schedulers2) {
                if (scheduler.hasLimitedSchedulingSlots()) continue;
                scheduler.schedule(enqueuedWorkSpecsArray);
            }
        }
    }

    @NonNull
    static Scheduler createBestAvailableBackgroundScheduler(@NonNull Context context, @NonNull WorkDatabase workDatabase, Configuration configuration) {
        Scheduler scheduler;
        if (Build.VERSION.SDK_INT >= 23) {
            scheduler = new SystemJobScheduler(context, workDatabase, configuration);
            PackageManagerHelper.setComponentEnabled(context, SystemJobService.class, true);
            Logger.get().debug(TAG, "Created SystemJobScheduler and enabled SystemJobService");
        } else {
            scheduler = Schedulers.tryCreateGcmBasedScheduler(context, configuration.getClock());
            if (scheduler == null) {
                scheduler = new SystemAlarmScheduler(context);
                PackageManagerHelper.setComponentEnabled(context, SystemAlarmService.class, true);
                Logger.get().debug(TAG, "Created SystemAlarmScheduler");
            }
        }
        return scheduler;
    }

    @Nullable
    private static Scheduler tryCreateGcmBasedScheduler(@NonNull Context context, Clock clock) {
        try {
            Class<?> klass = Class.forName(GCM_SCHEDULER);
            Scheduler scheduler = (Scheduler)klass.getConstructor(Context.class, Clock.class).newInstance(context, clock);
            Logger.get().debug(TAG, "Created androidx.work.impl.background.gcm.GcmScheduler");
            return scheduler;
        }
        catch (Throwable throwable) {
            Logger.get().debug(TAG, "Unable to create GCM Scheduler", throwable);
            return null;
        }
    }

    private Schedulers() {
    }

    private static void markScheduled(WorkSpecDao dao, Clock clock, List<WorkSpec> workSpecs) {
        if (workSpecs.size() > 0) {
            long now = clock.currentTimeMillis();
            for (WorkSpec workSpec : workSpecs) {
                dao.markWorkSpecScheduled(workSpec.id, now);
            }
        }
    }
}

