/*
 * Decompiled with CFR 0.152.
 */
package androidx.work;

import android.content.Context;
import androidx.annotation.RestrictTo;
import androidx.work.ListenableWorker;
import androidx.work.Logger;
import androidx.work.WorkerFactoryKt;
import androidx.work.WorkerParameters;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\"\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\f"}, d2={"Landroidx/work/WorkerFactory;", "", "()V", "createWorker", "Landroidx/work/ListenableWorker;", "appContext", "Landroid/content/Context;", "workerClassName", "", "workerParameters", "Landroidx/work/WorkerParameters;", "createWorkerWithDefaultFallback", "work-runtime_release"})
public abstract class WorkerFactory {
    @Nullable
    public abstract ListenableWorker createWorker(@NotNull Context var1, @NotNull String var2, @NotNull WorkerParameters var3);

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public final ListenableWorker createWorkerWithDefaultFallback(@NotNull Context appContext, @NotNull String workerClassName, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)workerClassName, (String)"workerClassName");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        ListenableWorker worker = null;
        worker = this.createWorker(appContext, workerClassName, workerParameters);
        if (worker == null) {
            Class<ListenableWorker> clazz;
            try {
                clazz = Class.forName(workerClassName).asSubclass(ListenableWorker.class);
            }
            catch (Throwable throwable) {
                Logger.get().error(WorkerFactoryKt.access$getTAG$p(), "Invalid class: " + workerClassName, throwable);
                clazz = null;
            }
            Class<ListenableWorker> clazz2 = clazz;
            if (clazz2 != null) {
                Class<ListenableWorker> clazz3 = clazz2;
                boolean bl = false;
                try {
                    Object[] objectArray = new Class[]{Context.class, WorkerParameters.class};
                    Constructor<ListenableWorker> constructor = clazz3.getDeclaredConstructor((Class<?>[])objectArray);
                    objectArray = new Object[]{appContext, workerParameters};
                    worker = constructor.newInstance(objectArray);
                }
                catch (Throwable e) {
                    Logger.get().error(WorkerFactoryKt.access$getTAG$p(), "Could not instantiate " + workerClassName, e);
                }
            }
        }
        ListenableWorker listenableWorker = worker;
        boolean bl = listenableWorker != null ? listenableWorker.isUsed() : false;
        if (bl) {
            String message = "WorkerFactory (" + this.getClass().getName() + ") returned an instance of a ListenableWorker (" + workerClassName + ") which has already been invoked. createWorker() must always return a new instance of a ListenableWorker.";
            throw new IllegalStateException(message);
        }
        return worker;
    }
}

