/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.work.BackoffPolicy;
import androidx.work.OutOfQuotaPolicy;
import androidx.work.WorkInfo;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkRequestHolder;
import androidx.work.impl.model.WorkSpec;
import androidx.work.impl.model.WorkTypeConverters;
import androidx.work.multiprocess.parcelable.ParcelUtils;
import androidx.work.multiprocess.parcelable.ParcelableConstraints;
import androidx.work.multiprocess.parcelable.ParcelableData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableWorkRequest
implements Parcelable {
    private final WorkRequest mWorkRequest;
    public static final Parcelable.Creator<ParcelableWorkRequest> CREATOR = new Parcelable.Creator<ParcelableWorkRequest>(){

        public ParcelableWorkRequest createFromParcel(Parcel in) {
            return new ParcelableWorkRequest(in);
        }

        public ParcelableWorkRequest[] newArray(int size) {
            return new ParcelableWorkRequest[size];
        }
    };

    public ParcelableWorkRequest(@NonNull WorkRequest workRequest) {
        this.mWorkRequest = workRequest;
    }

    protected ParcelableWorkRequest(@NonNull Parcel in) {
        String id = in.readString();
        HashSet tagsSet = new HashSet(in.createStringArrayList());
        String workerClassName = in.readString();
        WorkSpec workSpec = new WorkSpec(id, workerClassName);
        workSpec.inputMergerClassName = in.readString();
        workSpec.state = WorkTypeConverters.intToState((int)in.readInt());
        ParcelableData parcelableInputData = new ParcelableData(in);
        workSpec.input = parcelableInputData.getData();
        ParcelableData parcelableOutputData = new ParcelableData(in);
        workSpec.output = parcelableOutputData.getData();
        workSpec.initialDelay = in.readLong();
        workSpec.intervalDuration = in.readLong();
        workSpec.flexDuration = in.readLong();
        workSpec.runAttemptCount = in.readInt();
        ParcelableConstraints parcelableConstraints = (ParcelableConstraints)in.readParcelable(this.getClass().getClassLoader());
        workSpec.constraints = parcelableConstraints.getConstraints();
        workSpec.backoffPolicy = WorkTypeConverters.intToBackoffPolicy((int)in.readInt());
        workSpec.backoffDelayDuration = in.readLong();
        workSpec.minimumRetentionDuration = in.readLong();
        workSpec.scheduleRequestedAt = in.readLong();
        workSpec.expedited = ParcelUtils.readBooleanValue(in);
        workSpec.outOfQuotaPolicy = WorkTypeConverters.intToOutOfQuotaPolicy((int)in.readInt());
        this.mWorkRequest = new WorkRequestHolder(UUID.fromString(id), workSpec, tagsSet);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        parcel.writeString(this.mWorkRequest.getStringId());
        ArrayList tags = new ArrayList(this.mWorkRequest.getTags());
        parcel.writeStringList(tags);
        WorkSpec workSpec = this.mWorkRequest.getWorkSpec();
        parcel.writeString(workSpec.workerClassName);
        parcel.writeString(workSpec.inputMergerClassName);
        parcel.writeInt(WorkTypeConverters.stateToInt((WorkInfo.State)workSpec.state));
        ParcelableData parcelableInputData = new ParcelableData(workSpec.input);
        parcelableInputData.writeToParcel(parcel, flags);
        ParcelableData parcelableOutputData = new ParcelableData(workSpec.output);
        parcelableOutputData.writeToParcel(parcel, flags);
        parcel.writeLong(workSpec.initialDelay);
        parcel.writeLong(workSpec.intervalDuration);
        parcel.writeLong(workSpec.flexDuration);
        parcel.writeInt(workSpec.runAttemptCount);
        parcel.writeParcelable((Parcelable)new ParcelableConstraints(workSpec.constraints), flags);
        parcel.writeInt(WorkTypeConverters.backoffPolicyToInt((BackoffPolicy)workSpec.backoffPolicy));
        parcel.writeLong(workSpec.backoffDelayDuration);
        parcel.writeLong(workSpec.minimumRetentionDuration);
        parcel.writeLong(workSpec.scheduleRequestedAt);
        ParcelUtils.writeBooleanValue(parcel, workSpec.expedited);
        parcel.writeInt(WorkTypeConverters.outOfQuotaPolicyToInt((OutOfQuotaPolicy)workSpec.outOfQuotaPolicy));
    }

    @NonNull
    public WorkRequest getWorkRequest() {
        return this.mWorkRequest;
    }
}

