/*
 * Decompiled with CFR 0.152.
 */
package androidx.work.multiprocess.parcelable;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.work.ExistingWorkPolicy;
import androidx.work.WorkRequest;
import androidx.work.impl.WorkContinuationImpl;
import androidx.work.impl.WorkManagerImpl;
import androidx.work.impl.WorkRequestHolder;
import androidx.work.multiprocess.parcelable.ParcelUtils;
import androidx.work.multiprocess.parcelable.ParcelableWorkRequest;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@SuppressLint(value={"BanParcelableUsage"})
public class ParcelableWorkContinuationImpl
implements Parcelable {
    private static final ExistingWorkPolicy[] sValues = ExistingWorkPolicy.values();
    private WorkContinuationImplInfo mInfo;
    public static final Parcelable.Creator<ParcelableWorkContinuationImpl> CREATOR = new Parcelable.Creator<ParcelableWorkContinuationImpl>(){

        public ParcelableWorkContinuationImpl createFromParcel(@NonNull Parcel in) {
            return new ParcelableWorkContinuationImpl(in);
        }

        public ParcelableWorkContinuationImpl[] newArray(int size) {
            return new ParcelableWorkContinuationImpl[size];
        }
    };

    public ParcelableWorkContinuationImpl(@NonNull WorkContinuationImpl continuation) {
        this.mInfo = new WorkContinuationImplInfo(continuation);
    }

    public ParcelableWorkContinuationImpl(@NonNull WorkContinuationImplInfo info) {
        this.mInfo = info;
    }

    @NonNull
    public WorkContinuationImplInfo getInfo() {
        return this.mInfo;
    }

    protected ParcelableWorkContinuationImpl(@NonNull Parcel parcel) {
        String name = null;
        boolean hasName = ParcelUtils.readBooleanValue(parcel);
        if (hasName) {
            name = parcel.readString();
        }
        int ordinal = parcel.readInt();
        ExistingWorkPolicy workPolicy = sValues[ordinal];
        int requestSize = parcel.readInt();
        ArrayList<WorkRequestHolder> requests = new ArrayList<WorkRequestHolder>(requestSize);
        ClassLoader loader = this.getClass().getClassLoader();
        for (int i = 0; i < requestSize; ++i) {
            ParcelableWorkRequest parcelledRequest = (ParcelableWorkRequest)parcel.readParcelable(loader);
            WorkRequestHolder requestHolder = (WorkRequestHolder)parcelledRequest.getWorkRequest();
            requests.add(requestHolder);
        }
        ArrayList<WorkContinuationImplInfo> parents = null;
        boolean hasParents = ParcelUtils.readBooleanValue(parcel);
        if (hasParents) {
            int parentsSize = parcel.readInt();
            parents = new ArrayList<WorkContinuationImplInfo>(parentsSize);
            for (int i = 0; i < parentsSize; ++i) {
                ParcelableWorkContinuationImpl parcelledContinuation = (ParcelableWorkContinuationImpl)parcel.readParcelable(loader);
                parents.add(parcelledContinuation.getInfo());
            }
        }
        this.mInfo = new WorkContinuationImplInfo(name, workPolicy, requests, parents);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel parcel, int flags) {
        List<WorkContinuationImplInfo> parents;
        String name = this.mInfo.getName();
        boolean hasName = !TextUtils.isEmpty((CharSequence)name);
        ParcelUtils.writeBooleanValue(parcel, hasName);
        if (hasName) {
            parcel.writeString(name);
        }
        ExistingWorkPolicy policy = this.mInfo.getExistingWorkPolicy();
        parcel.writeInt(policy.ordinal());
        List<? extends WorkRequest> requests = this.mInfo.getWork();
        parcel.writeInt(requests.size());
        if (!requests.isEmpty()) {
            for (int i = 0; i < requests.size(); ++i) {
                WorkRequest request = requests.get(i);
                ParcelableWorkRequest parcelledRequest = new ParcelableWorkRequest(request);
                parcel.writeParcelable((Parcelable)parcelledRequest, flags);
            }
        }
        boolean hasParents = (parents = this.mInfo.getParentInfos()) != null && !parents.isEmpty();
        ParcelUtils.writeBooleanValue(parcel, hasParents);
        if (hasParents) {
            parcel.writeInt(parents.size());
            for (int i = 0; i < parents.size(); ++i) {
                ParcelableWorkContinuationImpl parcelledContinuationImpl = new ParcelableWorkContinuationImpl(parents.get(i));
                parcel.writeParcelable((Parcelable)parcelledContinuationImpl, flags);
            }
        }
    }

    @NonNull
    public WorkContinuationImpl toWorkContinuationImpl(@NonNull WorkManagerImpl workManager) {
        return this.mInfo.toWorkContinuationImpl(workManager);
    }

    public static class WorkContinuationImplInfo {
        private final String mName;
        private final ExistingWorkPolicy mWorkPolicy;
        private final List<? extends WorkRequest> mRequests;
        private List<WorkContinuationImplInfo> mParents;

        public WorkContinuationImplInfo(@NonNull WorkContinuationImpl continuation) {
            this.mName = continuation.getName();
            this.mWorkPolicy = continuation.getExistingWorkPolicy();
            this.mRequests = continuation.getWork();
            List continuations = continuation.getParents();
            this.mParents = null;
            if (continuations != null) {
                this.mParents = new ArrayList<WorkContinuationImplInfo>(continuations.size());
                for (WorkContinuationImpl workContinuation : continuations) {
                    this.mParents.add(new WorkContinuationImplInfo(workContinuation));
                }
            }
        }

        public WorkContinuationImplInfo(@Nullable String name, @NonNull ExistingWorkPolicy workPolicy, @NonNull List<? extends WorkRequest> requests, @Nullable List<WorkContinuationImplInfo> parents) {
            this.mName = name;
            this.mWorkPolicy = workPolicy;
            this.mRequests = requests;
            this.mParents = parents;
        }

        @Nullable
        public String getName() {
            return this.mName;
        }

        @NonNull
        public ExistingWorkPolicy getExistingWorkPolicy() {
            return this.mWorkPolicy;
        }

        @NonNull
        public List<? extends WorkRequest> getWork() {
            return this.mRequests;
        }

        @Nullable
        public List<WorkContinuationImplInfo> getParentInfos() {
            return this.mParents;
        }

        @NonNull
        public WorkContinuationImpl toWorkContinuationImpl(@NonNull WorkManagerImpl workManager) {
            return new WorkContinuationImpl(workManager, this.getName(), this.getExistingWorkPolicy(), this.getWork(), WorkContinuationImplInfo.parents(workManager, this.getParentInfos()));
        }

        @Nullable
        private static List<WorkContinuationImpl> parents(@NonNull WorkManagerImpl workManager, @Nullable List<WorkContinuationImplInfo> parentInfos) {
            if (parentInfos == null) {
                return null;
            }
            ArrayList<WorkContinuationImpl> continuations = new ArrayList<WorkContinuationImpl>(parentInfos.size());
            for (WorkContinuationImplInfo info : parentInfos) {
                continuations.add(new WorkContinuationImpl(workManager, info.getName(), info.getExistingWorkPolicy(), info.getWork(), WorkContinuationImplInfo.parents(workManager, info.getParentInfos())));
            }
            return continuations;
        }
    }
}

