/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.storage.file;

import android.net.Uri;
import androidx.test.internal.util.Checks;

public final class PropertyFile {
    public static Uri buildUri(Authority host) {
        Checks.checkNotNull((Object)((Object)host));
        return new Uri.Builder().scheme("content").authority(host.getAuthority()).build();
    }

    public static Uri buildUri(Authority host, String property) {
        Checks.checkNotNull((Object)((Object)host));
        Checks.checkNotNull((Object)property);
        return new Uri.Builder().scheme("content").authority(host.getAuthority()).path(property).build();
    }

    private PropertyFile() {
    }

    public static enum Authority {
        TEST_ARGS("androidx.test.services.storage.testargs");

        private final String authority;

        public String getAuthority() {
            return this.authority;
        }

        private Authority(String authority) {
            this.authority = (String)Checks.checkNotNull((Object)authority);
        }
    }

    public static enum Column {
        NAME("name", 0),
        VALUE("value", 1);

        private final String columnName;
        private final int position;

        public int getPosition() {
            return this.position;
        }

        public String getName() {
            return this.columnName;
        }

        private Column(String columnName, int position) {
            this.columnName = (String)Checks.checkNotNull((Object)columnName);
            this.position = position;
        }

        public static String[] getNames() {
            Column[] columns = Column.values();
            String[] names = new String[Column.values().length];
            for (int i = 0; i < names.length; ++i) {
                names[i] = columns[i].getName();
            }
            return names;
        }
    }
}

