/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.web.assertion;

import androidx.test.espresso.remote.internal.deps.guava.io.ByteStreams;
import androidx.test.internal.util.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

final class CompressorDecompressor {
    private static final String TAG = "CompressorDecompressor";
    private static final Compressor DEFAULT_COMPRESSOR;
    private static final Decompressor DEFAULT_DECOMPRESSOR;

    static {
        Object object = new GZIPCompressor();
        DEFAULT_COMPRESSOR = object;
        DEFAULT_DECOMPRESSOR = object = new GZIPDecompressor();
    }

    CompressorDecompressor() {
    }

    public static byte[] compress(byte[] source) throws IOException {
        byte[] byArray;
        long l = System.currentTimeMillis();
        byte[] byArray2 = DEFAULT_COMPRESSOR.compress(byArray);
        long l2 = System.currentTimeMillis();
        Object[] objectArray = new Object[]{byArray.length, byArray2.length, Float.valueOf((float)byArray2.length / (float)byArray.length), Math.abs(byArray2.length - byArray.length), l2 - l};
        LogUtil.logDebugWithProcess((String)TAG, (String)"Compressed input with size %d (bytes) to output with size %d (bytes). Compression factor: %f (%d bytes). Total time %d ms", (Object[])objectArray);
        return byArray2;
    }

    public static byte[] decompress(byte[] bytes) throws IOException {
        byte[] byArray;
        long l = System.currentTimeMillis();
        byte[] byArray2 = DEFAULT_DECOMPRESSOR.decompress(byArray);
        long l2 = System.currentTimeMillis();
        Object[] objectArray = new Object[]{byArray.length, byArray2.length, l2 - l};
        LogUtil.logDebugWithProcess((String)TAG, (String)"Decompressed input with size %d (bytes) to output with size %d (bytes). Total time %d ms", (Object[])objectArray);
        return byArray2;
    }

    static interface Compressor {
        public byte[] compress(byte[] var1) throws IOException;
    }

    static interface Decompressor {
        public byte[] decompress(byte[] var1) throws IOException;
    }

    static final class GZIPCompressor
    implements Compressor {
        GZIPCompressor() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte[] compress(byte[] bytes) throws IOException {
            Object object = new ByteArrayOutputStream();
            try (GZIPOutputStream gZIPOutputStream = new GZIPOutputStream((OutputStream)object);){
                void var1_2;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])var1_2);
                ByteStreams.copy(byteArrayInputStream, gZIPOutputStream);
            }
            return ((ByteArrayOutputStream)object).toByteArray();
        }
    }

    static final class GZIPDecompressor
    implements Decompressor {
        GZIPDecompressor() {
        }

        @Override
        public byte[] decompress(byte[] bytes) throws IOException {
            GZIPInputStream gZIPInputStream;
            Object object = new ByteArrayInputStream((byte[])gZIPInputStream);
            gZIPInputStream = new GZIPInputStream((InputStream)object);
            try {
                object = ByteStreams.toByteArray(gZIPInputStream);
            }
            finally {
                gZIPInputStream.close();
            }
            return object;
        }
    }
}

