/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.Android;
import androidx.test.espresso.remote.internal.deps.protobuf.Internal;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.UnsafeUtil;
import java.nio.ByteBuffer;
import java.util.Arrays;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class Utf8 {
    private static final Processor processor;

    static int encode(CharSequence charSequence, byte[] byArray, int n, int n2) {
        return processor.encodeUtf8(charSequence, byArray, n, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    static int encodedLength(CharSequence charSequence) {
        int n;
        int n2;
        block6: {
            int n3;
            int n4;
            int n5;
            block5: {
                n2 = charSequence.length();
                for (n5 = 0; n5 < n2; ++n5) {
                    if (charSequence.charAt(n5) < '\u0080') {
                        continue;
                    }
                    n4 = n2;
                    n3 = n5;
                    break block5;
                }
                n4 = n2;
                n3 = n5;
            }
            while (n3 < n2) {
                n5 = charSequence.charAt(n3);
                if (n5 < 2048) {
                    n4 += 127 - n5 >>> 31;
                    ++n3;
                    continue;
                }
                n = n4 + Utf8.encodedLengthGeneral(charSequence, n3);
                break block6;
            }
            n = n4;
        }
        if (n < n2) {
            StringBuilder stringBuilder = new StringBuilder();
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(stringBuilder.append("UTF-8 length does not fit in int: ").append((long)n + 0x100000000L).toString());
            throw illegalArgumentException;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int encodedLengthGeneral(CharSequence object, int n) {
        int n2 = object.length();
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            n = object.charAt(n4);
            if (n < 2048) {
                n3 += 127 - n >>> 31;
                n = n4;
            } else {
                n3 += 2;
                if (n >= 55296) {
                    if (n <= 57343) {
                        if (Character.codePointAt((CharSequence)object, n4) < 65536) {
                            object = new UnpairedSurrogateException(n4, n2);
                            throw object;
                        }
                        n = n4 + 1;
                    } else {
                        n = n4;
                    }
                } else {
                    n = n4;
                }
            }
            n4 = n + 1;
        }
        return n3;
    }

    private static int estimateConsecutiveAscii(ByteBuffer byteBuffer, int n, int n2) {
        int n3 = n2 + -7;
        for (n2 = n; n2 < n3 && (byteBuffer.getLong(n2) & 0x8080808080808080L) == 0L; n2 += 8) {
        }
        return n2 - n;
    }

    private static int incompleteStateFor(int n) {
        if (n > -12) {
            return -1;
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int incompleteStateFor(int n, int n2) {
        if (n > -12) return -1;
        if (n2 > -65) {
            return -1;
        }
        n ^= n2 << 8;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int incompleteStateFor(int n, int n2, int n3) {
        if (n > -12) return -1;
        if (n2 > -65) return -1;
        if (n3 <= -65) return n ^ n2 << 8 ^ n3 << 16;
        return -1;
    }

    private static int incompleteStateFor(byte[] object, int n, int n2) {
        byte by = object[n + -1];
        switch (n2 - n) {
            default: {
                object = new AssertionError;
                object();
                throw object;
            }
            case 2: {
                return Utf8.incompleteStateFor(by, (int)object[n], (int)object[n + 1]);
            }
            case 1: {
                return Utf8.incompleteStateFor(by, object[n]);
            }
            case 0: 
        }
        return Utf8.incompleteStateFor(by);
    }

    private static int incompleteStateFor(ByteBuffer object, int n, int n2, int n3) {
        switch (n3) {
            default: {
                object = new AssertionError();
                throw object;
            }
            case 2: {
                return Utf8.incompleteStateFor(n, (int)((ByteBuffer)object).get(n2), (int)((ByteBuffer)object).get(n2 + 1));
            }
            case 1: {
                return Utf8.incompleteStateFor(n, ((ByteBuffer)object).get(n2));
            }
            case 0: 
        }
        return Utf8.incompleteStateFor(n);
    }

    static String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(byteBuffer, n, n2);
    }

    static String decodeUtf8(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
        return processor.decodeUtf8(byArray, n, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    static {
        void var0_1;
        if (UnsafeProcessor.isAvailable() && !Android.isOnAndroidDevice()) {
            UnsafeProcessor unsafeProcessor = new UnsafeProcessor();
        } else {
            SafeProcessor safeProcessor = new SafeProcessor();
        }
        processor = var0_1;
    }

    static boolean isValidUtf8(ByteBuffer byteBuffer) {
        return processor.isValidUtf8(byteBuffer, byteBuffer.position(), byteBuffer.remaining());
    }

    static boolean isValidUtf8(byte[] byArray) {
        return processor.isValidUtf8(byArray, 0, byArray.length);
    }

    static boolean isValidUtf8(byte[] byArray, int n, int n2) {
        return processor.isValidUtf8(byArray, n, n2);
    }

    static abstract class Processor {
        abstract int encodeUtf8(CharSequence var1, byte[] var2, int var3, int var4);

        private static int partialIsValidUtf8(ByteBuffer byteBuffer, int n, int n2) {
            n += Utf8.estimateConsecutiveAscii(byteBuffer, n, n2);
            while (n < n2) {
                int n3 = n + 1;
                if ((n = (int)byteBuffer.get(n)) < 0) {
                    int n4;
                    if (n < -32) {
                        if (n3 >= n2) {
                            return n;
                        }
                        if (n < -62 || byteBuffer.get(n3) > -65) {
                            return -1;
                        }
                        n = n3 + 1;
                        continue;
                    }
                    if (n < -16) {
                        if (n3 >= n2 + -1) {
                            return Utf8.incompleteStateFor(byteBuffer, n, n3, n2 - n3);
                        }
                        n4 = n3 + 1;
                        if ((n3 = (int)byteBuffer.get(n3)) > -65 || n == -32 && n3 < -96 || n == -19 && n3 >= -96 || byteBuffer.get(n4) > -65) {
                            return -1;
                        }
                        n = n4 + 1;
                        continue;
                    }
                    if (n3 >= n2 + -2) {
                        return Utf8.incompleteStateFor(byteBuffer, n, n3, n2 - n3);
                    }
                    n4 = n3 + 1;
                    if ((n3 = (int)byteBuffer.get(n3)) <= -65 && (n << 28) + (n3 + 112) >> 30 == 0) {
                        n = n4 + 1;
                        if (byteBuffer.get(n4) <= -65) {
                            n3 = n + 1;
                            if (byteBuffer.get(n) <= -65) {
                                n = n3;
                                continue;
                            }
                        }
                    }
                    return -1;
                }
                n = n3;
            }
            return 0;
        }

        final int partialIsValidUtf8(int n, ByteBuffer byteBuffer, int n2, int n3) {
            if (byteBuffer.hasArray()) {
                int n4 = byteBuffer.arrayOffset();
                return this.partialIsValidUtf8(n, byteBuffer.array(), n4 + n2, n4 + n3);
            }
            if (byteBuffer.isDirect()) {
                return this.partialIsValidUtf8Direct(n, byteBuffer, n2, n3);
            }
            return this.partialIsValidUtf8Default(n, byteBuffer, n2, n3);
        }

        abstract int partialIsValidUtf8(int var1, byte[] var2, int var3, int var4);

        /*
         * Enabled aggressive block sorting
         */
        final int partialIsValidUtf8Default(int n, ByteBuffer byteBuffer, int n2, int n3) {
            int n4;
            if (n == 0) {
                n4 = n2;
                return Processor.partialIsValidUtf8(byteBuffer, n4, n3);
            }
            if (n2 >= n3) {
                return n;
            }
            byte by = (byte)n;
            if (by < -32) {
                if (by < -62) return -1;
                n4 = n2 + 1;
                if (byteBuffer.get(n2) <= -65) return Processor.partialIsValidUtf8(byteBuffer, n4, n3);
                return -1;
            }
            if (by < -16) {
                if ((n = (int)((byte)(~(n >> 8)))) == 0) {
                    n4 = n2 + 1;
                    n = byteBuffer.get(n2);
                    if (n4 >= n3) return Utf8.incompleteStateFor(by, n);
                } else {
                    n4 = n2;
                }
                if (n > -65) return -1;
                if (by == -32) {
                    if (n < -96) return -1;
                }
                if (by == -19) {
                    if (n >= -96) return -1;
                }
                n = n4 + 1;
                if (byteBuffer.get(n4) > -65) return -1;
                n4 = n;
                return Processor.partialIsValidUtf8(byteBuffer, n4, n3);
            }
            int n5 = ~(n >> 8);
            if (n5 == 0) {
                n4 = n2 + 1;
                n = byteBuffer.get(n2);
                if (n4 >= n3) return Utf8.incompleteStateFor(by, n);
                n2 = 0;
            } else {
                byte by2 = (byte)(n >> 16);
                n4 = n2;
                n = n5;
                n2 = by2;
            }
            if (n2 == 0) {
                n2 = n4 + 1;
                n5 = byteBuffer.get(n4);
                if (n2 >= n3) return Utf8.incompleteStateFor(by, n, n5);
                n4 = n2;
            } else {
                n5 = n2;
            }
            if (n > -65) return -1;
            if ((by << 28) + (n + 112) >> 30 != 0) return -1;
            if (n5 > -65) return -1;
            n = n4 + 1;
            if (byteBuffer.get(n4) > -65) return -1;
            n4 = n;
            return Processor.partialIsValidUtf8(byteBuffer, n4, n3);
        }

        abstract int partialIsValidUtf8Direct(int var1, ByteBuffer var2, int var3, int var4);

        final String decodeUtf8(ByteBuffer byteBuffer, int n, int n2) throws InvalidProtocolBufferException {
            if (byteBuffer.hasArray()) {
                int n3 = byteBuffer.arrayOffset();
                return this.decodeUtf8(byteBuffer.array(), n3 + n, n2);
            }
            if (byteBuffer.isDirect()) {
                return this.decodeUtf8Direct(byteBuffer, n, n2);
            }
            return this.decodeUtf8Default(byteBuffer, n, n2);
        }

        abstract String decodeUtf8(byte[] var1, int var2, int var3) throws InvalidProtocolBufferException;

        /*
         * Enabled aggressive block sorting
         */
        final String decodeUtf8Default(ByteBuffer byteBuffer, int n, int n2) throws InvalidProtocolBufferException {
            int n3;
            int n4;
            char[] cArray;
            int n5;
            block14: {
                if ((n | n2 | byteBuffer.limit() - n - n2) < 0) {
                    Object[] objectArray = new Object[]{byteBuffer.limit(), n, n2};
                    Object object = new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", objectArray));
                    throw object;
                }
                n5 = n + n2;
                cArray = new char[n2];
                n4 = n;
                n = 0;
                while (n4 < n5) {
                    n2 = byteBuffer.get(n4);
                    if (!DecodeUtil.isOneByte((byte)n2)) {
                        n2 = n;
                        break block14;
                    }
                    ++n4;
                    n3 = n + 1;
                    DecodeUtil.handleOneByte((byte)n2, cArray, n);
                    n = n3;
                }
                n2 = n;
            }
            block1: while (n4 < n5) {
                n = n4 + 1;
                if (DecodeUtil.isOneByte((byte)(n4 = (int)byteBuffer.get(n4)))) {
                    n3 = n2 + 1;
                    DecodeUtil.handleOneByte((byte)n4, cArray, n2);
                    n4 = n;
                    n = n3;
                } else {
                    int n6;
                    int n7;
                    if (DecodeUtil.isTwoBytes((byte)n4)) {
                        if (n >= n5) {
                            throw InvalidProtocolBufferException.invalidUtf8();
                        }
                        n3 = n + 1;
                        n7 = n2 + 1;
                        DecodeUtil.handleTwoBytes((byte)n4, byteBuffer.get(n), cArray, n2);
                        n4 = n3;
                        n2 = n7;
                        continue;
                    }
                    if (DecodeUtil.isThreeBytes((byte)n4)) {
                        if (n >= n5 + -1) {
                            throw InvalidProtocolBufferException.invalidUtf8();
                        }
                        n3 = n + 1;
                        n7 = n3 + 1;
                        n6 = n2 + 1;
                        DecodeUtil.handleThreeBytes((byte)n4, byteBuffer.get(n), byteBuffer.get(n3), cArray, n2);
                        n4 = n7;
                        n2 = n6;
                        continue;
                    }
                    if (n >= n5 + -2) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    n3 = n + 1;
                    n7 = n3 + 1;
                    n6 = n7 + 1;
                    DecodeUtil.handleFourBytes((byte)n4, byteBuffer.get(n), byteBuffer.get(n3), byteBuffer.get(n7), cArray, n2);
                    n2 = n2 + 2;
                    n4 = n6;
                    continue;
                }
                while (n4 < n5) {
                    n2 = byteBuffer.get(n4);
                    if (!DecodeUtil.isOneByte((byte)n2)) {
                        n2 = n;
                        continue block1;
                    }
                    ++n4;
                    n3 = n + 1;
                    DecodeUtil.handleOneByte((byte)n2, cArray, n);
                    n = n3;
                }
                n2 = n;
            }
            return new String(cArray, 0, n2);
        }

        abstract String decodeUtf8Direct(ByteBuffer var1, int var2, int var3) throws InvalidProtocolBufferException;

        Processor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isValidUtf8(ByteBuffer byteBuffer, int n, int n2) {
            if (this.partialIsValidUtf8(0, byteBuffer, n, n2) != 0) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final boolean isValidUtf8(byte[] byArray, int n, int n2) {
            if (this.partialIsValidUtf8(0, byArray, n, n2) != 0) return false;
            return true;
        }
    }

    static class UnpairedSurrogateException
    extends IllegalArgumentException {
        UnpairedSurrogateException(int n, int n2) {
            StringBuilder stringBuilder = new StringBuilder();
            super(stringBuilder.append("Unpaired surrogate at index ").append(n).append(" of ").append(n2).toString());
        }
    }

    static final class UnsafeProcessor
    extends Processor {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        int encodeUtf8(CharSequence object, byte[] object2, int n, int n2) {
            int n3;
            int n4;
            block14: {
                block13: {
                    long l;
                    long l2 = n;
                    long l3 = l2 + (long)n2;
                    n4 = object.length();
                    if (n4 > n2 || ((Object)object2).length - n2 < n) {
                        char c = object.charAt(n4 + -1);
                        object2 = new StringBuilder();
                        Object object3 = new ArrayIndexOutOfBoundsException(((StringBuilder)object2).append("Failed writing ").append(c).append(" at index ").append(n + n2).toString());
                        throw object3;
                    }
                    for (n3 = 0; n3 < n4 && (n = (int)object.charAt(n3)) < 128; ++n3) {
                        l = l2 + 1L;
                        UnsafeUtil.putByte((byte[])object2, l2, (byte)n);
                        l2 = l;
                    }
                    if (n3 == n4) {
                        return (int)l2;
                    }
                    l = l2;
                    n = n3;
                    while (true) {
                        long l4;
                        if (n >= n4) {
                            return (int)l;
                        }
                        n3 = object.charAt(n);
                        if (n3 < 128 && l < l3) {
                            l4 = l + 1L;
                            UnsafeUtil.putByte((byte[])object2, l, (byte)n3);
                            n3 = n;
                        } else if (n3 < 2048 && l <= l3 + -2L) {
                            l2 = l + 1L;
                            UnsafeUtil.putByte((byte[])object2, l, (byte)(n3 >>> 6 | 0x3C0));
                            l4 = l2 + 1L;
                            UnsafeUtil.putByte((byte[])object2, l2, (byte)(n3 & 0x3F | 0x80));
                            n3 = n;
                        } else if ((n3 < 55296 || n3 > 57343) && l <= l3 + -3L) {
                            l2 = l + 1L;
                            UnsafeUtil.putByte((byte[])object2, l, (byte)(n3 >>> 12 | 0x1E0));
                            l = l2 + 1L;
                            UnsafeUtil.putByte((byte[])object2, l2, (byte)(n3 >>> 6 & 0x3F | 0x80));
                            l4 = l + 1L;
                            UnsafeUtil.putByte((byte[])object2, l, (byte)(n3 & 0x3F | 0x80));
                            n3 = n;
                        } else {
                            if (l > l3 + -4L) break;
                            if (n + 1 == n4) break block13;
                            if (!Character.isSurrogatePair((char)n3, (char)(n2 = (int)object.charAt(++n)))) {
                                n3 = n;
                                break block14;
                            }
                            n3 = Character.toCodePoint((char)n3, (char)n2);
                            l2 = l + 1L;
                            UnsafeUtil.putByte((byte[])object2, l, (byte)(n3 >>> 18 | 0xF0));
                            l = l2 + 1L;
                            UnsafeUtil.putByte((byte[])object2, l2, (byte)(n3 >>> 12 & 0x3F | 0x80));
                            l2 = l + 1L;
                            UnsafeUtil.putByte((byte[])object2, l, (byte)(n3 >>> 6 & 0x3F | 0x80));
                            l4 = l2 + 1L;
                            UnsafeUtil.putByte((byte[])object2, l2, (byte)(n3 & 0x3F | 0x80));
                            n3 = n;
                        }
                        n = n3 + 1;
                        l = l4;
                    }
                    if (!(n3 < 55296 || n3 > 57343 || n + 1 != n4 && Character.isSurrogatePair((char)n3, object.charAt(n + 1)))) {
                        UnpairedSurrogateException unpairedSurrogateException = new UnpairedSurrogateException(n, n4);
                        throw unpairedSurrogateException;
                    }
                    object2 = new StringBuilder();
                    object = new ArrayIndexOutOfBoundsException(((StringBuilder)object2).append("Failed writing ").append((char)n3).append(" at index ").append(l).toString());
                    throw object;
                }
                n3 = n;
            }
            object = new UnpairedSurrogateException(n3 + -1, n4);
            throw object;
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private static int partialIsValidUtf8(long l, int n) {
            int n2 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(l, n);
            n -= n2;
            long l2 = l += (long)n2;
            while (true) {
                long l3;
                long l4;
                int n3;
                int n4;
                long l5;
                block13: {
                    l5 = l2;
                    n4 = 0;
                    for (n3 = n; n3 > 0; --n3) {
                        l4 = l5 + 1L;
                        n4 = UnsafeUtil.getByte(l5);
                        if (n4 >= 0) {
                            l5 = l4;
                            continue;
                        }
                        n = n4;
                        break block13;
                    }
                    l4 = l5;
                    n = n4;
                }
                if (n3 == 0) {
                    return 0;
                }
                --n3;
                if (n < -32) {
                    if (n3 == 0) {
                        return n;
                    }
                    if (n < -62) return -1;
                    long l6 = l4 + 1L;
                    if (UnsafeUtil.getByte(l4) > -65) return -1;
                    l3 = l6;
                    n = --n3;
                } else if (n < -16) {
                    if (n3 < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(l4, n, n3);
                    }
                    n3 -= 2;
                    long l7 = l4 + 1L;
                    n4 = UnsafeUtil.getByte(l4);
                    if (n4 > -65) return -1;
                    if (n == -32) {
                        if (n4 < -96) return -1;
                    }
                    if (n == -19) {
                        if (n4 >= -96) return -1;
                    }
                    l3 = l7 + 1L;
                    if (UnsafeUtil.getByte(l7) > -65) return -1;
                    n = n3;
                } else {
                    if (n3 < 3) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(l4, n, n3);
                    }
                    n3 -= 3;
                    l3 = l4 + 1L;
                    n4 = UnsafeUtil.getByte(l4);
                    if (n4 > -65) return -1;
                    if ((n << 28) + (n4 + 112) >> 30 != 0) return -1;
                    l5 = l3 + 1L;
                    if (UnsafeUtil.getByte(l3) > -65) return -1;
                    l3 = l5 + 1L;
                    if (UnsafeUtil.getByte(l5) > -65) return -1;
                    n = n3;
                }
                l2 = l3;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        private static int partialIsValidUtf8(byte[] byArray, long l, int n) {
            int n2 = UnsafeProcessor.unsafeEstimateConsecutiveAscii(byArray, l, n);
            n -= n2;
            long l2 = l += (long)n2;
            while (true) {
                long l3;
                long l4;
                int n3;
                int n4;
                long l5;
                block13: {
                    l5 = l2;
                    n4 = 0;
                    for (n3 = n; n3 > 0; --n3) {
                        l4 = l5 + 1L;
                        n4 = UnsafeUtil.getByte(byArray, l5);
                        if (n4 >= 0) {
                            l5 = l4;
                            continue;
                        }
                        n = n4;
                        break block13;
                    }
                    l4 = l5;
                    n = n4;
                }
                if (n3 == 0) {
                    return 0;
                }
                --n3;
                if (n < -32) {
                    if (n3 == 0) {
                        return n;
                    }
                    if (n < -62) return -1;
                    long l6 = l4 + 1L;
                    if (UnsafeUtil.getByte(byArray, l4) > -65) return -1;
                    l3 = l6;
                    n = --n3;
                } else if (n < -16) {
                    if (n3 < 2) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(byArray, n, l4, n3);
                    }
                    n3 -= 2;
                    long l7 = l4 + 1L;
                    n4 = UnsafeUtil.getByte(byArray, l4);
                    if (n4 > -65) return -1;
                    if (n == -32) {
                        if (n4 < -96) return -1;
                    }
                    if (n == -19) {
                        if (n4 >= -96) return -1;
                    }
                    l3 = l7 + 1L;
                    if (UnsafeUtil.getByte(byArray, l7) > -65) return -1;
                    n = n3;
                } else {
                    if (n3 < 3) {
                        return UnsafeProcessor.unsafeIncompleteStateFor(byArray, n, l4, n3);
                    }
                    n3 -= 3;
                    l3 = l4 + 1L;
                    n4 = UnsafeUtil.getByte(byArray, l4);
                    if (n4 > -65) return -1;
                    if ((n << 28) + (n4 + 112) >> 30 != 0) return -1;
                    l5 = l3 + 1L;
                    if (UnsafeUtil.getByte(byArray, l3) > -65) return -1;
                    l3 = l5 + 1L;
                    if (UnsafeUtil.getByte(byArray, l5) > -65) return -1;
                    n = n3;
                }
                l2 = l3;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
            long l;
            long l2;
            long l3;
            if ((n2 | n3 | byArray.length - n3) < 0) {
                Object[] objectArray = new Object[]{byArray.length, n2, n3};
                Object object = new ArrayIndexOutOfBoundsException(String.format("Array length=%d, index=%d, limit=%d", objectArray));
                throw object;
            }
            long l4 = n2;
            long l5 = n3;
            if (n == 0) {
                l3 = l4;
                return UnsafeProcessor.partialIsValidUtf8(byArray, l3, (int)(l5 - l3));
            }
            if (l4 >= l5) {
                return n;
            }
            n3 = (byte)n;
            if (n3 < -32) {
                if (n3 < -62) return -1;
                l3 = l4 + 1L;
                if (UnsafeUtil.getByte(byArray, l4) <= -65) return UnsafeProcessor.partialIsValidUtf8(byArray, l3, (int)(l5 - l3));
                return -1;
            }
            if (n3 < -16) {
                long l6;
                byte by = (byte)(~(n >> 8));
                if (by == 0) {
                    l6 = l4 + 1L;
                    by = UnsafeUtil.getByte(byArray, l4);
                    if (l6 >= l5) return Utf8.incompleteStateFor(n3, by);
                } else {
                    l6 = l4;
                }
                if (by > -65) return -1;
                if (n3 == -32) {
                    if (by < -96) return -1;
                }
                if (n3 == -19) {
                    if (by >= -96) return -1;
                }
                long l7 = l6 + 1L;
                if (UnsafeUtil.getByte(byArray, l6) > -65) return -1;
                l3 = l7;
                return UnsafeProcessor.partialIsValidUtf8(byArray, l3, (int)(l5 - l3));
            }
            byte by = (byte)(~(n >> 8));
            if (by == 0) {
                l2 = l4 + 1L;
                by = UnsafeUtil.getByte(byArray, l4);
                if (l2 >= l5) return Utf8.incompleteStateFor(n3, by);
                n = 0;
            } else {
                n = (byte)(n >> 16);
                l2 = l4;
            }
            if (n == 0) {
                l = l2 + 1L;
                n2 = UnsafeUtil.getByte(byArray, l2);
                if (l >= l5) return Utf8.incompleteStateFor(n3, (int)by, n2);
            } else {
                l = l2;
                n2 = n;
            }
            if (by > -65) return -1;
            if ((n3 << 28) + (by + 112) >> 30 != 0) return -1;
            if (n2 > -65) return -1;
            l3 = l + 1L;
            if (UnsafeUtil.getByte(byArray, l) <= -65) return UnsafeProcessor.partialIsValidUtf8(byArray, l3, (int)(l5 - l3));
            return -1;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        int partialIsValidUtf8Direct(int n, ByteBuffer byteBuffer, int n2, int n3) {
            int n4;
            long l;
            long l2;
            long l3;
            if ((n2 | n3 | byteBuffer.limit() - n3) < 0) {
                Object[] objectArray = new Object[]{byteBuffer.limit(), n2, n3};
                Object object = new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", objectArray));
                throw object;
            }
            long l4 = UnsafeUtil.addressOffset(byteBuffer) + (long)n2;
            long l5 = l4 + (long)(n3 - n2);
            if (n == 0) {
                l3 = l4;
                return UnsafeProcessor.partialIsValidUtf8(l3, (int)(l5 - l3));
            }
            if (l4 >= l5) {
                return n;
            }
            n2 = (byte)n;
            if (n2 < -32) {
                if (n2 < -62) return -1;
                l3 = l4 + 1L;
                if (UnsafeUtil.getByte(l4) <= -65) return UnsafeProcessor.partialIsValidUtf8(l3, (int)(l5 - l3));
                return -1;
            }
            if (n2 < -16) {
                long l6;
                byte by = (byte)(~(n >> 8));
                if (by == 0) {
                    l6 = l4 + 1L;
                    by = UnsafeUtil.getByte(l4);
                    if (l6 >= l5) return Utf8.incompleteStateFor(n2, by);
                } else {
                    l6 = l4;
                }
                if (by > -65) return -1;
                if (n2 == -32) {
                    if (by < -96) return -1;
                }
                if (n2 == -19) {
                    if (by >= -96) return -1;
                }
                long l7 = l6 + 1L;
                if (UnsafeUtil.getByte(l6) > -65) return -1;
                l3 = l7;
                return UnsafeProcessor.partialIsValidUtf8(l3, (int)(l5 - l3));
            }
            byte by = (byte)(~(n >> 8));
            if (by == 0) {
                l2 = l4 + 1L;
                by = UnsafeUtil.getByte(l4);
                if (l2 >= l5) return Utf8.incompleteStateFor(n2, by);
                n = 0;
            } else {
                n = (byte)(n >> 16);
                l2 = l4;
            }
            if (n == 0) {
                l = l2 + 1L;
                n4 = UnsafeUtil.getByte(l2);
                if (l >= l5) return Utf8.incompleteStateFor(n2, (int)by, n4);
            } else {
                l = l2;
                n4 = n;
            }
            if (by > -65) return -1;
            if ((n2 << 28) + (by + 112) >> 30 != 0) return -1;
            if (n4 > -65) return -1;
            l3 = l + 1L;
            if (UnsafeUtil.getByte(l) <= -65) return UnsafeProcessor.partialIsValidUtf8(l3, (int)(l5 - l3));
            return -1;
        }

        private static int unsafeEstimateConsecutiveAscii(long l, int n) {
            int n2;
            int n3;
            if (n < 16) {
                return 0;
            }
            int n4 = (int)(-l & 7L);
            long l2 = l;
            for (n3 = n4; n3 > 0; --n3) {
                long l3 = l2 + 1L;
                if (UnsafeUtil.getByte(l2) < 0) {
                    return n4 - n3;
                }
                l2 = l3;
            }
            n3 = n - n4;
            long l4 = l2;
            for (n2 = n3; n2 >= 8 && (UnsafeUtil.getLong(l4) & 0x8080808080808080L) == 0L; n2 -= 8) {
                l = l4 + 8L;
                l4 = l;
            }
            return n - n2;
        }

        /*
         * Enabled aggressive block sorting
         */
        private static int unsafeEstimateConsecutiveAscii(byte[] byArray, long l, int n) {
            int n2;
            long l2;
            block8: {
                int n3;
                if (n < 16) {
                    return 0;
                }
                int n4 = 8 - ((int)l & 7);
                long l3 = l;
                for (n3 = 0; n3 < n4; ++n3) {
                    long l4 = l3 + 1L;
                    if (UnsafeUtil.getByte(byArray, l3) < 0) {
                        return n3;
                    }
                    l3 = l4;
                }
                long l5 = l3;
                int n5 = n3;
                while (n5 + 8 <= n) {
                    if ((UnsafeUtil.getLong(byArray, UnsafeUtil.BYTE_ARRAY_BASE_OFFSET + l5) & 0x8080808080808080L) != 0L) {
                        l2 = l5;
                        n2 = n5;
                        break block8;
                    }
                    l = l5 + 8L;
                    n5 += 8;
                    l5 = l;
                }
                l2 = l5;
                n2 = n5;
            }
            while (n2 < n) {
                long l6 = l2 + 1L;
                if (UnsafeUtil.getByte(byArray, l2) < 0) {
                    return n2;
                }
                ++n2;
                l2 = l6;
            }
            return n;
        }

        private static int unsafeIncompleteStateFor(long l, int n, int n2) {
            switch (n2) {
                default: {
                    AssertionError assertionError = new AssertionError();
                    throw assertionError;
                }
                case 2: {
                    return Utf8.incompleteStateFor(n, (int)UnsafeUtil.getByte(l), (int)UnsafeUtil.getByte(l + 1L));
                }
                case 1: {
                    return Utf8.incompleteStateFor(n, UnsafeUtil.getByte(l));
                }
                case 0: 
            }
            return Utf8.incompleteStateFor(n);
        }

        private static int unsafeIncompleteStateFor(byte[] object, int n, long l, int n2) {
            switch (n2) {
                default: {
                    object = new AssertionError;
                    object();
                    throw object;
                }
                case 2: {
                    return Utf8.incompleteStateFor(n, (int)UnsafeUtil.getByte(object, l), (int)UnsafeUtil.getByte(object, l + 1L));
                }
                case 1: {
                    return Utf8.incompleteStateFor(n, UnsafeUtil.getByte(object, l));
                }
                case 0: 
            }
            return Utf8.incompleteStateFor(n);
        }

        @Override
        String decodeUtf8(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            Object object = new String(byArray, n, n2, Internal.UTF_8);
            if (!((String)object).contains("\ufffd")) {
                return object;
            }
            if (!Arrays.equals(((String)object).getBytes(Internal.UTF_8), Arrays.copyOfRange(byArray, n, n + n2))) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            return object;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        String decodeUtf8Direct(ByteBuffer byteBuffer, int n, int n2) throws InvalidProtocolBufferException {
            long l;
            int n3;
            int n4;
            char[] cArray;
            long l2;
            long l3;
            block14: {
                if ((n | n2 | byteBuffer.limit() - n - n2) < 0) {
                    Object[] objectArray = new Object[]{byteBuffer.limit(), n, n2};
                    Object object = new ArrayIndexOutOfBoundsException(String.format("buffer limit=%d, index=%d, limit=%d", objectArray));
                    throw object;
                }
                l3 = UnsafeUtil.addressOffset(byteBuffer) + (long)n;
                l2 = l3 + (long)n2;
                cArray = new char[n2];
                long l4 = l3;
                n4 = 0;
                while (l4 < l2) {
                    n3 = UnsafeUtil.getByte(l4);
                    if (!DecodeUtil.isOneByte((byte)n3)) {
                        l = l4;
                        n3 = n4;
                        break block14;
                    }
                    l3 = l4 + 1L;
                    n2 = n4 + 1;
                    DecodeUtil.handleOneByte((byte)n3, cArray, n4);
                    l4 = l3;
                    n4 = n2;
                }
                l = l4;
                n3 = n4;
            }
            while (true) {
                long l5;
                block15: {
                    long l6;
                    block16: {
                        if (l >= l2) {
                            return new String(cArray, 0, n3);
                        }
                        long l7 = l + 1L;
                        n4 = UnsafeUtil.getByte(l);
                        if (DecodeUtil.isOneByte((byte)n4)) break block16;
                        if (DecodeUtil.isTwoBytes((byte)n4)) {
                            if (l7 >= l2) {
                                throw InvalidProtocolBufferException.invalidUtf8();
                            }
                            l5 = l7 + 1L;
                            n2 = n3 + 1;
                            DecodeUtil.handleTwoBytes((byte)n4, UnsafeUtil.getByte(l7), cArray, n3);
                            n3 = n2;
                            break block15;
                        } else if (DecodeUtil.isThreeBytes((byte)n4)) {
                            if (l7 >= l2 + -1L) {
                                throw InvalidProtocolBufferException.invalidUtf8();
                            }
                            l3 = l7 + 1L;
                            l5 = l3 + 1L;
                            n2 = n3 + 1;
                            DecodeUtil.handleThreeBytes((byte)n4, UnsafeUtil.getByte(l7), UnsafeUtil.getByte(l3), cArray, n3);
                            n3 = n2;
                            break block15;
                        } else {
                            if (l7 >= l2 + -2L) {
                                throw InvalidProtocolBufferException.invalidUtf8();
                            }
                            l3 = l7 + 1L;
                            long l8 = l3 + 1L;
                            l5 = l8 + 1L;
                            DecodeUtil.handleFourBytes((byte)n4, UnsafeUtil.getByte(l7), UnsafeUtil.getByte(l3), UnsafeUtil.getByte(l8), cArray, n3);
                            n3 += 2;
                        }
                        break block15;
                    }
                    n2 = n3 + 1;
                    DecodeUtil.handleOneByte((byte)n4, cArray, n3);
                    n4 = n2;
                    for (l6 = l7; l6 < l2; ++l6) {
                        n3 = UnsafeUtil.getByte(l6);
                        if (!DecodeUtil.isOneByte((byte)n3)) {
                            l5 = l6;
                            n3 = n4;
                            break block15;
                        }
                        n2 = n4 + 1;
                        DecodeUtil.handleOneByte((byte)n3, cArray, n4);
                        n4 = n2;
                    }
                    l5 = l6;
                    n3 = n4;
                }
                l = l5;
            }
        }

        UnsafeProcessor() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean isAvailable() {
            if (!UnsafeUtil.hasUnsafeArrayOperations()) return false;
            if (!UnsafeUtil.hasUnsafeByteBufferOperations()) return false;
            return true;
        }
    }

    static final class SafeProcessor
    extends Processor {
        /*
         * Enabled aggressive block sorting
         */
        @Override
        int encodeUtf8(CharSequence object, byte[] object2, int n, int n2) {
            int n3;
            int n4;
            block13: {
                block12: {
                    n4 = object.length();
                    int n5 = n + n2;
                    for (n3 = 0; n3 < n4 && n3 + n < n5 && (n2 = (int)object.charAt(n3)) < 128; ++n3) {
                        object2[n + n3] = (byte)n2;
                    }
                    if (n3 == n4) {
                        return n + n4;
                    }
                    n += n3;
                    n2 = n3;
                    while (true) {
                        int n6;
                        if (n2 >= n4) {
                            return n;
                        }
                        n3 = object.charAt(n2);
                        if (n3 < 128 && n < n5) {
                            n6 = n + 1;
                            object2[n] = (byte)n3;
                            n = n6;
                            n3 = n2;
                        } else if (n3 < 2048 && n <= n5 + -2) {
                            n6 = n + 1;
                            object2[n] = (byte)(n3 >>> 6 | 0x3C0);
                            n = n6 + 1;
                            object2[n6] = (byte)(n3 & 0x3F | 0x80);
                            n3 = n2;
                        } else if ((n3 < 55296 || n3 > 57343) && n <= n5 + -3) {
                            n6 = n + 1;
                            object2[n] = (byte)(n3 >>> 12 | 0x1E0);
                            n = n6 + 1;
                            object2[n6] = (byte)(n3 >>> 6 & 0x3F | 0x80);
                            n6 = n + 1;
                            object2[n] = (byte)(n3 & 0x3F | 0x80);
                            n = n6;
                            n3 = n2;
                        } else {
                            if (n > n5 + -4) break;
                            if (n2 + 1 == object.length()) break block12;
                            if (!Character.isSurrogatePair((char)n3, (char)(n6 = (int)object.charAt(++n2)))) {
                                n3 = n2;
                                break block13;
                            }
                            n3 = Character.toCodePoint((char)n3, (char)n6);
                            n6 = n + 1;
                            object2[n] = (byte)(n3 >>> 18 | 0xF0);
                            n = n6 + 1;
                            object2[n6] = (byte)(n3 >>> 12 & 0x3F | 0x80);
                            n6 = n + 1;
                            object2[n] = (byte)(n3 >>> 6 & 0x3F | 0x80);
                            n = n6 + 1;
                            object2[n6] = (byte)(n3 & 0x3F | 0x80);
                            n3 = n2;
                        }
                        n2 = n3 + 1;
                    }
                    if (!(n3 < 55296 || n3 > 57343 || n2 + 1 != object.length() && Character.isSurrogatePair((char)n3, object.charAt(n2 + 1)))) {
                        UnpairedSurrogateException unpairedSurrogateException = new UnpairedSurrogateException(n2, n4);
                        throw unpairedSurrogateException;
                    }
                    object2 = new StringBuilder();
                    object = new ArrayIndexOutOfBoundsException(((StringBuilder)object2).append("Failed writing ").append((char)n3).append(" at index ").append(n).toString());
                    throw object;
                }
                n3 = n2;
            }
            object = new UnpairedSurrogateException(n3 + -1, n4);
            throw object;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static int partialIsValidUtf8(byte[] byArray, int n, int n2) {
            while (n < n2 && byArray[n] >= 0) {
                ++n;
            }
            if (n < n2) return SafeProcessor.partialIsValidUtf8NonAscii(byArray, n, n2);
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        int partialIsValidUtf8(int n, byte[] byArray, int n2, int n3) {
            int n4;
            if (n == 0) {
                n4 = n2;
                return SafeProcessor.partialIsValidUtf8(byArray, n4, n3);
            }
            if (n2 >= n3) {
                return n;
            }
            byte by = (byte)n;
            if (by < -32) {
                if (by < -62) return -1;
                n4 = n2 + 1;
                if (byArray[n2] <= -65) return SafeProcessor.partialIsValidUtf8(byArray, n4, n3);
                return -1;
            }
            if (by < -16) {
                if ((n = (int)((byte)(~(n >> 8)))) == 0) {
                    n4 = n2 + 1;
                    n = byArray[n2];
                    if (n4 >= n3) return Utf8.incompleteStateFor(by, n);
                } else {
                    n4 = n2;
                }
                if (n > -65) return -1;
                if (by == -32) {
                    if (n < -96) return -1;
                }
                if (by == -19) {
                    if (n >= -96) return -1;
                }
                n = n4 + 1;
                if (byArray[n4] > -65) return -1;
                n4 = n;
                return SafeProcessor.partialIsValidUtf8(byArray, n4, n3);
            }
            int n5 = ~(n >> 8);
            if (n5 == 0) {
                n4 = n2 + 1;
                n = byArray[n2];
                if (n4 >= n3) return Utf8.incompleteStateFor(by, n);
                n2 = 0;
            } else {
                byte by2 = (byte)(n >> 16);
                n4 = n2;
                n = n5;
                n2 = by2;
            }
            if (n2 == 0) {
                n2 = n4 + 1;
                n5 = byArray[n4];
                if (n2 >= n3) return Utf8.incompleteStateFor(by, n, n5);
                n4 = n2;
            } else {
                n5 = n2;
            }
            if (n > -65) return -1;
            if ((by << 28) + (n + 112) >> 30 != 0) return -1;
            if (n5 > -65) return -1;
            n = n4 + 1;
            if (byArray[n4] > -65) return -1;
            n4 = n;
            return SafeProcessor.partialIsValidUtf8(byArray, n4, n3);
        }

        @Override
        int partialIsValidUtf8Direct(int n, ByteBuffer byteBuffer, int n2, int n3) {
            return this.partialIsValidUtf8Default(n, byteBuffer, n2, n3);
        }

        private static int partialIsValidUtf8NonAscii(byte[] byArray, int n, int n2) {
            while (n < n2) {
                int n3 = n + 1;
                if ((n = byArray[n]) < 0) {
                    int n4;
                    if (n < -32) {
                        if (n3 >= n2) {
                            return n;
                        }
                        if (n >= -62) {
                            n = n3 + 1;
                            if (byArray[n3] <= -65) continue;
                        }
                        return -1;
                    }
                    if (n < -16) {
                        if (n3 >= n2 + -1) {
                            return Utf8.incompleteStateFor(byArray, n3, n2);
                        }
                        n4 = n3 + 1;
                        if (!((n3 = byArray[n3]) > -65 || n == -32 && n3 < -96 || n == -19 && n3 >= -96)) {
                            n = n4 + 1;
                            if (byArray[n4] <= -65) continue;
                        }
                        return -1;
                    }
                    if (n3 >= n2 + -2) {
                        return Utf8.incompleteStateFor(byArray, n3, n2);
                    }
                    n4 = n3 + 1;
                    if ((n3 = byArray[n3]) <= -65 && (n << 28) + (n3 + 112) >> 30 == 0) {
                        n = n4 + 1;
                        if (byArray[n4] <= -65) {
                            n3 = n + 1;
                            if (byArray[n] <= -65) {
                                n = n3;
                                continue;
                            }
                        }
                    }
                    return -1;
                }
                n = n3;
            }
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        String decodeUtf8(byte[] byArray, int n, int n2) throws InvalidProtocolBufferException {
            int n3;
            int n4;
            char[] cArray;
            int n5;
            block14: {
                if ((n | n2 | byArray.length - n - n2) < 0) {
                    Object[] objectArray = new Object[]{byArray.length, n, n2};
                    Object object = new ArrayIndexOutOfBoundsException(String.format("buffer length=%d, index=%d, size=%d", objectArray));
                    throw object;
                }
                n5 = n + n2;
                cArray = new char[n2];
                n4 = n;
                n = 0;
                while (n4 < n5) {
                    n2 = byArray[n4];
                    if (!DecodeUtil.isOneByte((byte)n2)) {
                        n2 = n;
                        break block14;
                    }
                    ++n4;
                    n3 = n + 1;
                    DecodeUtil.handleOneByte((byte)n2, cArray, n);
                    n = n3;
                }
                n2 = n;
            }
            block1: while (n4 < n5) {
                n = n4 + 1;
                if (DecodeUtil.isOneByte((byte)(n4 = byArray[n4]))) {
                    n3 = n2 + 1;
                    DecodeUtil.handleOneByte((byte)n4, cArray, n2);
                    n4 = n;
                    n = n3;
                } else {
                    int n6;
                    int n7;
                    if (DecodeUtil.isTwoBytes((byte)n4)) {
                        if (n >= n5) {
                            throw InvalidProtocolBufferException.invalidUtf8();
                        }
                        n3 = n + 1;
                        n7 = n2 + 1;
                        DecodeUtil.handleTwoBytes((byte)n4, byArray[n], cArray, n2);
                        n4 = n3;
                        n2 = n7;
                        continue;
                    }
                    if (DecodeUtil.isThreeBytes((byte)n4)) {
                        if (n >= n5 + -1) {
                            throw InvalidProtocolBufferException.invalidUtf8();
                        }
                        n3 = n + 1;
                        n7 = n3 + 1;
                        n6 = n2 + 1;
                        DecodeUtil.handleThreeBytes((byte)n4, byArray[n], byArray[n3], cArray, n2);
                        n4 = n7;
                        n2 = n6;
                        continue;
                    }
                    if (n >= n5 + -2) {
                        throw InvalidProtocolBufferException.invalidUtf8();
                    }
                    n3 = n + 1;
                    n7 = n3 + 1;
                    n6 = n7 + 1;
                    DecodeUtil.handleFourBytes((byte)n4, byArray[n], byArray[n3], byArray[n7], cArray, n2);
                    n2 = n2 + 2;
                    n4 = n6;
                    continue;
                }
                while (n4 < n5) {
                    n2 = byArray[n4];
                    if (!DecodeUtil.isOneByte((byte)n2)) {
                        n2 = n;
                        continue block1;
                    }
                    ++n4;
                    n3 = n + 1;
                    DecodeUtil.handleOneByte((byte)n2, cArray, n);
                    n = n3;
                }
                n2 = n;
            }
            return new String(cArray, 0, n2);
        }

        @Override
        String decodeUtf8Direct(ByteBuffer byteBuffer, int n, int n2) throws InvalidProtocolBufferException {
            return this.decodeUtf8Default(byteBuffer, n, n2);
        }

        SafeProcessor() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class DecodeUtil {
        private static char highSurrogate(int n) {
            return (char)((n >>> 10) + 55232);
        }

        private static char lowSurrogate(int n) {
            return (char)((n & 0x3FF) + 56320);
        }

        private static int trailingByteValue(byte by) {
            return by & 0x3F;
        }

        private static void handleFourBytes(byte by, byte by2, byte by3, byte by4, char[] cArray, int n) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(by2) || (by << 28) + (by2 + 112) >> 30 != 0 || DecodeUtil.isNotTrailingByte(by3) || DecodeUtil.isNotTrailingByte(by4)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            by = (byte)((by & 7) << 18 | DecodeUtil.trailingByteValue(by2) << 12 | DecodeUtil.trailingByteValue(by3) << 6 | DecodeUtil.trailingByteValue(by4));
            cArray[n] = DecodeUtil.highSurrogate(by);
            cArray[n + 1] = DecodeUtil.lowSurrogate(by);
        }

        private static void handleOneByte(byte by, char[] cArray, int n) {
            cArray[n] = (char)by;
        }

        private static void handleThreeBytes(byte by, byte by2, byte by3, char[] cArray, int n) throws InvalidProtocolBufferException {
            if (DecodeUtil.isNotTrailingByte(by2) || by == -32 && by2 < -96 || by == -19 && by2 >= -96 || DecodeUtil.isNotTrailingByte(by3)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            cArray[n] = (char)((by & 0xF) << 12 | DecodeUtil.trailingByteValue(by2) << 6 | DecodeUtil.trailingByteValue(by3));
        }

        private static void handleTwoBytes(byte by, byte by2, char[] cArray, int n) throws InvalidProtocolBufferException {
            if (by < -62 || DecodeUtil.isNotTrailingByte(by2)) {
                throw InvalidProtocolBufferException.invalidUtf8();
            }
            cArray[n] = (char)((by & 0x1F) << 6 | DecodeUtil.trailingByteValue(by2));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isNotTrailingByte(byte by) {
            if (by <= -65) return 0 != 0;
            return 1 != 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isOneByte(byte by) {
            if (by < 0) return 0 != 0;
            return 1 != 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isThreeBytes(byte by) {
            if (by >= -16) return 0 != 0;
            return 1 != 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isTwoBytes(byte by) {
            if (by >= -32) return 0 != 0;
            return 1 != 0;
        }
    }
}

