/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.Android;
import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import libcore.io.Memory;
import sun.misc.Unsafe;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
final class UnsafeUtil {
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final Class MEMORY_CLASS = Android.getMemoryClass();
    private static final boolean IS_ANDROID_64 = UnsafeUtil.determineAndroidSupportByAddressSize(Long.TYPE);
    private static final boolean IS_ANDROID_32 = UnsafeUtil.determineAndroidSupportByAddressSize(Integer.TYPE);
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
    private static final long BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
    private static final long INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final long INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
    private static final long LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
    private static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
    private static final long FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
    private static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
    private static final long DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
    private static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
    private static final long OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());
    private static final int BYTE_ARRAY_ALIGNMENT = (int)(BYTE_ARRAY_BASE_OFFSET & 7L);
    static final boolean IS_BIG_ENDIAN;

    static byte getByte(long l) {
        return MEMORY_ACCESSOR.getByte(l);
    }

    static byte getByte(byte[] byArray, long l) {
        return MEMORY_ACCESSOR.getByte(byArray, BYTE_ARRAY_BASE_OFFSET + l);
    }

    private static byte getByteBigEndian(Object object, long l) {
        return (byte)(UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL) >>> (int)(((l ^ 0xFFFFFFFFFFFFFFFFL) & 3L) << 3) & 0xFF);
    }

    private static byte getByteLittleEndian(Object object, long l) {
        return (byte)(UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL) >>> (int)((l & 3L) << 3) & 0xFF);
    }

    static double getDouble(Object object, long l) {
        return MEMORY_ACCESSOR.getDouble(object, l);
    }

    static float getFloat(Object object, long l) {
        return MEMORY_ACCESSOR.getFloat(object, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int arrayBaseOffset(Class clazz) {
        if (!HAS_UNSAFE_ARRAY_OPERATIONS) return -1;
        return MEMORY_ACCESSOR.arrayBaseOffset(clazz);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int arrayIndexScale(Class clazz) {
        if (!HAS_UNSAFE_ARRAY_OPERATIONS) return -1;
        return MEMORY_ACCESSOR.arrayIndexScale(clazz);
    }

    static int getInt(Object object, long l) {
        return MEMORY_ACCESSOR.getInt(object, l);
    }

    static long addressOffset(ByteBuffer byteBuffer) {
        return MEMORY_ACCESSOR.getLong(byteBuffer, BUFFER_ADDRESS_OFFSET);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static long fieldOffset(Field field) {
        if (field == null) return -1L;
        if (MEMORY_ACCESSOR != null) return MEMORY_ACCESSOR.objectFieldOffset(field);
        return -1L;
    }

    static long getLong(long l) {
        return MEMORY_ACCESSOR.getLong(l);
    }

    static long getLong(Object object, long l) {
        return MEMORY_ACCESSOR.getLong(object, l);
    }

    static long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        if (Android.isOnAndroidDevice()) {
            if (IS_ANDROID_64) {
                Android64MemoryAccessor android64MemoryAccessor = new Android64MemoryAccessor(UNSAFE);
                return android64MemoryAccessor;
            }
            if (IS_ANDROID_32) {
                Android32MemoryAccessor android32MemoryAccessor = new Android32MemoryAccessor(UNSAFE);
                return android32MemoryAccessor;
            }
            return null;
        }
        JvmMemoryAccessor jvmMemoryAccessor = new JvmMemoryAccessor(UNSAFE);
        return jvmMemoryAccessor;
    }

    static Object allocateInstance(Class object) {
        try {
            object = UNSAFE.allocateInstance((Class<?>)object);
        }
        catch (InstantiationException instantiationException) {
            IllegalStateException illegalStateException = new IllegalStateException(instantiationException);
            throw illegalStateException;
        }
        return object;
    }

    static Object getObject(Object object, long l) {
        return MEMORY_ACCESSOR.getObject(object, l);
    }

    private static Field bufferAddressField() {
        Field field;
        if (Android.isOnAndroidDevice() && (field = UnsafeUtil.field(Buffer.class, "effectiveDirectAddress")) != null) {
            return field;
        }
        field = UnsafeUtil.field(Buffer.class, "address");
        if (field != null && field.getType() == Long.TYPE) {
            return field;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Field field(Class annotatedElement, String string) {
        void var0_2;
        try {
            void var1_4;
            Field field = ((Class)annotatedElement).getDeclaredField((String)var1_4);
            return var0_2;
        }
        catch (Throwable throwable) {
            return var0_2;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Unsafe getUnsafe() {
        try {
            PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                public Unsafe run() throws Exception {
                    Class<Unsafe> clazz = Unsafe.class;
                    for (Field field : clazz.getDeclaredFields()) {
                        field.setAccessible(true);
                        Object object = field.get(null);
                        if (!clazz.isInstance(object)) continue;
                        return (Unsafe)clazz.cast(object);
                    }
                    return null;
                }
            };
            return (Unsafe)AccessController.doPrivileged(privilegedExceptionAction);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        IS_BIG_ENDIAN = bl;
    }

    private UnsafeUtil() {
    }

    static void copyMemory(long l, byte[] byArray, long l2, long l3) {
        MEMORY_ACCESSOR.copyMemory(l, byArray, l2, l3);
    }

    private static void logMissingMethod(Throwable object) {
        Object object2 = UnsafeUtil.class;
        object2 = ((Class)object2).getName();
        object2 = Logger.getLogger((String)object2);
        Level level = Level.WARNING;
        object = String.valueOf(object);
        StringBuilder stringBuilder = new StringBuilder();
        ((Logger)object2).logp(level, "androidx.test.espresso.remote.internal.deps.protobuf.UnsafeUtil", "logMissingMethod", stringBuilder.append("platform method missing - proto runtime falling back to safer methods: ").append((String)object).toString());
    }

    static void putBoolean(Object object, long l, boolean bl) {
        MEMORY_ACCESSOR.putBoolean(object, l, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void putBooleanBigEndian(Object object, long l, boolean bl) {
        bl = bl;
        UnsafeUtil.putByteBigEndian(object, l, (byte)(bl ? 1 : 0));
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void putBooleanLittleEndian(Object object, long l, boolean bl) {
        bl = bl;
        UnsafeUtil.putByteLittleEndian(object, l, (byte)(bl ? 1 : 0));
    }

    static void putByte(byte[] byArray, long l, byte by) {
        MEMORY_ACCESSOR.putByte(byArray, BYTE_ARRAY_BASE_OFFSET + l, by);
    }

    private static void putByteBigEndian(Object object, long l, byte by) {
        int n = (~((int)l) & 3) << 3;
        UnsafeUtil.putInt(object, l & 0xFFFFFFFFFFFFFFFCL, UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL) & ~(255 << n) | (by & 0xFF) << n);
    }

    private static void putByteLittleEndian(Object object, long l, byte by) {
        int n = ((int)l & 3) << 3;
        UnsafeUtil.putInt(object, l & 0xFFFFFFFFFFFFFFFCL, UnsafeUtil.getInt(object, l & 0xFFFFFFFFFFFFFFFCL) & ~(255 << n) | (by & 0xFF) << n);
    }

    static void putDouble(Object object, long l, double d) {
        MEMORY_ACCESSOR.putDouble(object, l, d);
    }

    static void putFloat(Object object, long l, float f) {
        MEMORY_ACCESSOR.putFloat(object, l, f);
    }

    static void putInt(Object object, long l, int n) {
        MEMORY_ACCESSOR.putInt(object, l, n);
    }

    static void putLong(Object object, long l, long l2) {
        MEMORY_ACCESSOR.putLong(object, l, l2);
    }

    static void putObject(Object object, long l, Object object2) {
        MEMORY_ACCESSOR.putObject(object, l, object2);
    }

    static boolean determineAndroidSupportByAddressSize(Class clazz) {
        if (!Android.isOnAndroidDevice()) {
            return false;
        }
        try {
            Class clazz2 = MEMORY_CLASS;
            Object object = "peekLong";
            Class[] classArray = new Class[]{clazz, Boolean.TYPE};
            clazz2.getMethod((String)object, classArray);
            object = "pokeLong";
            classArray = new Class[]{clazz, Long.TYPE, Boolean.TYPE};
            clazz2.getMethod((String)object, classArray);
            object = "pokeInt";
            classArray = new Class[]{clazz, Integer.TYPE, Boolean.TYPE};
            clazz2.getMethod((String)object, classArray);
            object = "peekInt";
            classArray = new Class[]{clazz, Boolean.TYPE};
            clazz2.getMethod((String)object, classArray);
            object = "pokeByte";
            classArray = new Class[]{clazz, Byte.TYPE};
            clazz2.getMethod((String)object, classArray);
            object = new Class[]{clazz};
            clazz2.getMethod("peekByte", (Class<?>)object);
            object = "pokeByteArray";
            classArray = new Class[]{clazz, byte[].class, Integer.TYPE, Integer.TYPE};
            clazz2.getMethod((String)object, classArray);
            object = "peekByteArray";
            classArray = new Class[]{clazz, byte[].class, Integer.TYPE, Integer.TYPE};
            clazz2.getMethod((String)object, classArray);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    static boolean getBoolean(Object object, long l) {
        return MEMORY_ACCESSOR.getBoolean(object, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getBooleanBigEndian(Object object, long l) {
        if (UnsafeUtil.getByteBigEndian(object, l) == 0) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean getBooleanLittleEndian(Object object, long l) {
        if (UnsafeUtil.getByteLittleEndian(object, l) == 0) return false;
        return true;
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (MEMORY_ACCESSOR == null) {
            return false;
        }
        return MEMORY_ACCESSOR.supportsUnsafeArrayOperations();
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (MEMORY_ACCESSOR == null) {
            return false;
        }
        return MEMORY_ACCESSOR.supportsUnsafeByteBufferOperations();
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        public abstract byte getByte(long var1);

        public abstract byte getByte(Object var1, long var2);

        public abstract double getDouble(Object var1, long var2);

        public abstract float getFloat(Object var1, long var2);

        public final int arrayBaseOffset(Class clazz) {
            return this.unsafe.arrayBaseOffset(clazz);
        }

        public final int arrayIndexScale(Class clazz) {
            return this.unsafe.arrayIndexScale(clazz);
        }

        public final int getInt(Object object, long l) {
            return this.unsafe.getInt(object, l);
        }

        public abstract long getLong(long var1);

        public final long getLong(Object object, long l) {
            return this.unsafe.getLong(object, l);
        }

        public final long objectFieldOffset(Field field) {
            return this.unsafe.objectFieldOffset(field);
        }

        public final Object getObject(Object object, long l) {
            return this.unsafe.getObject(object, l);
        }

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public abstract void copyMemory(long var1, byte[] var3, long var4, long var6);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract void putByte(Object var1, long var2, byte var4);

        public abstract void putDouble(Object var1, long var2, double var4);

        public abstract void putFloat(Object var1, long var2, float var4);

        public final void putInt(Object object, long l, int n) {
            this.unsafe.putInt(object, l, n);
        }

        public final void putLong(Object object, long l, long l2) {
            this.unsafe.putLong(object, l, l2);
        }

        public final void putObject(Object object, long l, Object object2) {
            this.unsafe.putObject(object, l, object2);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public boolean supportsUnsafeArrayOperations() {
            if (((MemoryAccessor)((Object)clazz)).unsafe == null) {
                return false;
            }
            try {
                Class<?> clazz = ((MemoryAccessor)((Object)clazz)).unsafe.getClass();
                String string = "objectFieldOffset";
                Class[] classArray = new Class[]{Field.class};
                clazz.getMethod(string, classArray);
                string = "arrayBaseOffset";
                classArray = new Class[]{Class.class};
                clazz.getMethod(string, classArray);
                string = "arrayIndexScale";
                classArray = new Class[]{Class.class};
                clazz.getMethod(string, classArray);
                string = "getInt";
                classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putInt";
                classArray = new Class[]{Object.class, Long.TYPE, Integer.TYPE};
                clazz.getMethod(string, classArray);
                string = "getLong";
                classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putLong";
                classArray = new Class[]{Object.class, Long.TYPE, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "getObject";
                classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putObject";
                classArray = new Class[]{Object.class, Long.TYPE, Object.class};
                clazz.getMethod(string, classArray);
                return true;
            }
            catch (Throwable throwable) {
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }

        public boolean supportsUnsafeByteBufferOperations() {
            if (((MemoryAccessor)object).unsafe == null) {
                return false;
            }
            try {
                Object object = ((MemoryAccessor)object).unsafe.getClass();
                String string = "objectFieldOffset";
                Class[] classArray = new Class[]{Field.class};
                ((Class)object).getMethod(string, classArray);
                string = "getLong";
                classArray = new Class[]{Object.class, Long.TYPE};
                ((Class)object).getMethod(string, classArray);
                object = UnsafeUtil.bufferAddressField();
                return object != null;
            }
            catch (Throwable throwable) {
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }
    }

    private static final class Android64MemoryAccessor
    extends MemoryAccessor {
        @Override
        public byte getByte(long l) {
            return Memory.peekByte((long)l);
        }

        @Override
        public byte getByte(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getByteBigEndian(object, l);
            }
            return UnsafeUtil.getByteLittleEndian(object, l);
        }

        @Override
        public double getDouble(Object object, long l) {
            return Double.longBitsToDouble(this.getLong(object, l));
        }

        @Override
        public float getFloat(Object object, long l) {
            return Float.intBitsToFloat(this.getInt(object, l));
        }

        @Override
        public long getLong(long l) {
            return Memory.peekLong((long)l, (boolean)false);
        }

        Android64MemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            Memory.peekByteArray((long)l, (byte[])byArray, (int)((int)l2), (int)((int)l3));
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putBooleanBigEndian(object, l, bl);
                return;
            }
            UnsafeUtil.putBooleanLittleEndian(object, l, bl);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putByteBigEndian(object, l, by);
                return;
            }
            UnsafeUtil.putByteLittleEndian(object, l, by);
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.putLong(object, l, Double.doubleToLongBits(d));
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.putInt(object, l, Float.floatToIntBits(f));
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getBooleanBigEndian(object, l);
            }
            return UnsafeUtil.getBooleanLittleEndian(object, l);
        }

        @Override
        public boolean supportsUnsafeByteBufferOperations() {
            return super.supportsUnsafeByteBufferOperations();
        }
    }

    private static final class Android32MemoryAccessor
    extends MemoryAccessor {
        @Override
        public byte getByte(long l) {
            return Memory.peekByte((int)Android32MemoryAccessor.smallAddress(l));
        }

        @Override
        public byte getByte(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getByteBigEndian(object, l);
            }
            return UnsafeUtil.getByteLittleEndian(object, l);
        }

        @Override
        public double getDouble(Object object, long l) {
            return Double.longBitsToDouble(this.getLong(object, l));
        }

        @Override
        public float getFloat(Object object, long l) {
            return Float.intBitsToFloat(this.getInt(object, l));
        }

        private static int smallAddress(long l) {
            return (int)l;
        }

        @Override
        public long getLong(long l) {
            return Memory.peekLong((int)Android32MemoryAccessor.smallAddress(l), (boolean)false);
        }

        Android32MemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            Memory.peekByteArray((int)Android32MemoryAccessor.smallAddress(l), (byte[])byArray, (int)((int)l2), (int)((int)l3));
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putBooleanBigEndian(object, l, bl);
                return;
            }
            UnsafeUtil.putBooleanLittleEndian(object, l, bl);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            if (IS_BIG_ENDIAN) {
                UnsafeUtil.putByteBigEndian(object, l, by);
                return;
            }
            UnsafeUtil.putByteLittleEndian(object, l, by);
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.putLong(object, l, Double.doubleToLongBits(d));
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.putInt(object, l, Float.floatToIntBits(f));
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            if (IS_BIG_ENDIAN) {
                return UnsafeUtil.getBooleanBigEndian(object, l);
            }
            return UnsafeUtil.getBooleanLittleEndian(object, l);
        }

        @Override
        public boolean supportsUnsafeByteBufferOperations() {
            return super.supportsUnsafeByteBufferOperations();
        }
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        @Override
        public byte getByte(long l) {
            return this.unsafe.getByte(l);
        }

        @Override
        public byte getByte(Object object, long l) {
            return this.unsafe.getByte(object, l);
        }

        @Override
        public double getDouble(Object object, long l) {
            return this.unsafe.getDouble(object, l);
        }

        @Override
        public float getFloat(Object object, long l) {
            return this.unsafe.getFloat(object, l);
        }

        @Override
        public long getLong(long l) {
            return this.unsafe.getLong(l);
        }

        JvmMemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public void copyMemory(long l, byte[] byArray, long l2, long l3) {
            this.unsafe.copyMemory(null, l, byArray, BYTE_ARRAY_BASE_OFFSET + l2, l3);
        }

        @Override
        public void putBoolean(Object object, long l, boolean bl) {
            this.unsafe.putBoolean(object, l, bl);
        }

        @Override
        public void putByte(Object object, long l, byte by) {
            this.unsafe.putByte(object, l, by);
        }

        @Override
        public void putDouble(Object object, long l, double d) {
            this.unsafe.putDouble(object, l, d);
        }

        @Override
        public void putFloat(Object object, long l, float f) {
            this.unsafe.putFloat(object, l, f);
        }

        @Override
        public boolean getBoolean(Object object, long l) {
            return this.unsafe.getBoolean(object, l);
        }

        @Override
        public boolean supportsUnsafeArrayOperations() {
            if (!super.supportsUnsafeArrayOperations()) {
                return false;
            }
            try {
                Class<?> clazz = ((JvmMemoryAccessor)((Object)clazz)).unsafe.getClass();
                String string = "getByte";
                Class[] classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putByte";
                classArray = new Class[]{Object.class, Long.TYPE, Byte.TYPE};
                clazz.getMethod(string, classArray);
                string = "getBoolean";
                classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putBoolean";
                classArray = new Class[]{Object.class, Long.TYPE, Boolean.TYPE};
                clazz.getMethod(string, classArray);
                string = "getFloat";
                classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putFloat";
                classArray = new Class[]{Object.class, Long.TYPE, Float.TYPE};
                clazz.getMethod(string, classArray);
                string = "getDouble";
                classArray = new Class[]{Object.class, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putDouble";
                classArray = new Class[]{Object.class, Long.TYPE, Double.TYPE};
                clazz.getMethod(string, classArray);
                return true;
            }
            catch (Throwable throwable) {
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }

        @Override
        public boolean supportsUnsafeByteBufferOperations() {
            if (!super.supportsUnsafeByteBufferOperations()) {
                return false;
            }
            try {
                Class<?> clazz = ((JvmMemoryAccessor)((Object)clazz)).unsafe.getClass();
                String string = "getByte";
                Class[] classArray = new Class[]{Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putByte";
                classArray = new Class[]{Long.TYPE, Byte.TYPE};
                clazz.getMethod(string, classArray);
                string = "getInt";
                classArray = new Class[]{Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putInt";
                classArray = new Class[]{Long.TYPE, Integer.TYPE};
                clazz.getMethod(string, classArray);
                string = "getLong";
                classArray = new Class[]{Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "putLong";
                classArray = new Class[]{Long.TYPE, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "copyMemory";
                classArray = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE};
                clazz.getMethod(string, classArray);
                string = "copyMemory";
                classArray = new Class[]{Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE};
                clazz.getMethod(string, classArray);
                return true;
            }
            catch (Throwable throwable) {
                UnsafeUtil.logMissingMethod(throwable);
                return false;
            }
        }
    }
}

