/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedInputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.CodedOutputStream;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.MessageLiteToString;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import androidx.test.espresso.remote.internal.deps.protobuf.Writer;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final UnknownFieldSetLite DEFAULT_INSTANCE;
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    /*
     * Unable to fully structure code
     */
    public int getSerializedSize() {
        var1_1 = this.memoizedSerializedSize;
        if (var1_1 != -1) {
            return var1_1;
        }
        var1_1 = 0;
        block7: for (var2_2 = 0; var2_2 < this.count; ++var2_2) {
            var3_3 = this.tags[var2_2];
            var4_4 = WireFormat.getTagFieldNumber(var3_3);
            switch (WireFormat.getTagWireType(var3_3)) {
                case 5: {
                    var1_1 += CodedOutputStream.computeFixed32Size(var4_4, (Integer)this.objects[var2_2]);
lbl11:
                    // 5 sources

                    continue block7;
                }
                case 3: {
                    var3_3 = CodedOutputStream.computeTagSize(var4_4);
                    var1_1 += var3_3 + var3_3 + ((UnknownFieldSetLite)this.objects[var2_2]).getSerializedSize();
                    ** GOTO lbl11
                }
                case 2: {
                    var1_1 += CodedOutputStream.computeBytesSize(var4_4, (ByteString)this.objects[var2_2]);
                    ** GOTO lbl11
                }
                case 1: {
                    var1_1 += CodedOutputStream.computeFixed64Size(var4_4, (Long)this.objects[var2_2]);
                    ** GOTO lbl11
                }
                case 0: {
                    var1_1 += CodedOutputStream.computeUInt64Size(var4_4, (Long)this.objects[var2_2]);
                    ** continue;
                }
            }
            this = new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
            throw this;
        }
        this.memoizedSerializedSize = var1_1;
        return var1_1;
    }

    public int getSerializedSizeAsMessageSet() {
        int n = this.memoizedSerializedSize;
        if (n != -1) {
            return n;
        }
        n = 0;
        for (int i = 0; i < this.count; ++i) {
            n += CodedOutputStream.computeRawMessageSetExtensionSize(WireFormat.getTagFieldNumber(this.tags[i]), (ByteString)this.objects[i]);
        }
        this.memoizedSerializedSize = n;
        return n;
    }

    public int hashCode() {
        return ((this.count + 527) * 31 + UnknownFieldSetLite.hashCode(this.tags, this.count)) * 31 + UnknownFieldSetLite.hashCode(this.objects, this.count);
    }

    private static int hashCode(int[] nArray, int n) {
        int n2 = 17;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + nArray[i];
        }
        return n2;
    }

    private static int hashCode(Object[] objectArray, int n) {
        int n2 = 17;
        for (int i = 0; i < n; ++i) {
            n2 = n2 * 31 + objectArray[i].hashCode();
        }
        return n2;
    }

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    private UnknownFieldSetLite mergeFrom(CodedInputStream codedInputStream) throws IOException {
        int n;
        while ((n = codedInputStream.readTag()) != 0 && this.mergeFieldFrom(n, codedInputStream)) {
        }
        return this;
    }

    UnknownFieldSetLite mergeLengthDelimitedField(int n, ByteString byteString) {
        ((UnknownFieldSetLite)object).checkMutable();
        if (n == 0) {
            Object object = new IllegalArgumentException("Zero is not a valid field number.");
            throw object;
        }
        ((UnknownFieldSetLite)object).storeField(WireFormat.makeTag(n, 2), byteString);
        return object;
    }

    UnknownFieldSetLite mergeVarintField(int n, int n2) {
        ((UnknownFieldSetLite)object).checkMutable();
        if (n == 0) {
            Object object = new IllegalArgumentException("Zero is not a valid field number.");
            throw object;
        }
        ((UnknownFieldSetLite)object).storeField(WireFormat.makeTag(n, 0), n2);
        return object;
    }

    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite unknownFieldSetLite, UnknownFieldSetLite unknownFieldSetLite2) {
        int n = unknownFieldSetLite.count + unknownFieldSetLite2.count;
        int[] nArray = Arrays.copyOf(unknownFieldSetLite.tags, n);
        System.arraycopy(unknownFieldSetLite2.tags, 0, nArray, unknownFieldSetLite.count, unknownFieldSetLite2.count);
        Object[] objectArray = Arrays.copyOf(unknownFieldSetLite.objects, n);
        System.arraycopy(unknownFieldSetLite2.objects, 0, objectArray, unknownFieldSetLite.count, unknownFieldSetLite2.count);
        unknownFieldSetLite = new UnknownFieldSetLite(n, nArray, objectArray, true);
        return unknownFieldSetLite;
    }

    static UnknownFieldSetLite newInstance() {
        UnknownFieldSetLite unknownFieldSetLite = new UnknownFieldSetLite();
        return unknownFieldSetLite;
    }

    static {
        UnknownFieldSetLite unknownFieldSetLite;
        DEFAULT_INSTANCE = unknownFieldSetLite = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    private UnknownFieldSetLite(int n, int[] nArray, Object[] objectArray, boolean bl) {
        this.count = n;
        this.tags = nArray;
        this.objects = objectArray;
        this.isMutable = bl;
    }

    void checkMutable() {
        if (!((UnknownFieldSetLite)object).isMutable) {
            Object object = new UnsupportedOperationException();
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void ensureCapacity() {
        if (this.count != this.tags.length) {
            return;
        }
        int n = this.count < 4 ? 8 : this.count >> 1;
        n = this.count + n;
        this.tags = Arrays.copyOf(this.tags, n);
        this.objects = Arrays.copyOf(this.objects, n);
    }

    public void makeImmutable() {
        this.isMutable = false;
    }

    final void printWithIndent(StringBuilder stringBuilder, int n) {
        for (int i = 0; i < this.count; ++i) {
            MessageLiteToString.printField(stringBuilder, n, String.valueOf(WireFormat.getTagFieldNumber(this.tags[i])), this.objects[i]);
        }
    }

    void storeField(int n, Object object) {
        this.checkMutable();
        this.ensureCapacity();
        this.tags[this.count] = n;
        this.objects[this.count] = object;
        ++this.count;
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeAsMessageSetTo(Writer writer) throws IOException {
        if (writer.fieldOrder() == Writer.FieldOrder.DESCENDING) {
            for (int i = this.count + -1; i >= 0; --i) {
                writer.writeMessageSetItem(WireFormat.getTagFieldNumber(this.tags[i]), this.objects[i]);
            }
            return;
        } else {
            for (int i = 0; i < this.count; ++i) {
                writer.writeMessageSetItem(WireFormat.getTagFieldNumber(this.tags[i]), this.objects[i]);
            }
        }
    }

    private static void writeField(int n, Object object, Writer writer) throws IOException {
        int n2 = WireFormat.getTagFieldNumber(n);
        switch (WireFormat.getTagWireType(n)) {
            case 5: {
                writer.writeFixed32(n2, (Integer)object);
                return;
            }
            case 3: {
                if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
                    writer.writeStartGroup(n2);
                    ((UnknownFieldSetLite)object).writeTo(writer);
                    writer.writeEndGroup(n2);
                    return;
                }
                writer.writeEndGroup(n2);
                ((UnknownFieldSetLite)object).writeTo(writer);
                writer.writeStartGroup(n2);
                return;
            }
            case 2: {
                writer.writeBytes(n2, (ByteString)object);
                return;
            }
            case 1: {
                writer.writeFixed64(n2, (Long)object);
                return;
            }
            default: {
                RuntimeException runtimeException = new RuntimeException(InvalidProtocolBufferException.invalidWireType());
                throw runtimeException;
            }
            case 0: 
        }
        writer.writeInt64(n2, (Long)object);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void writeTo(Writer writer) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (writer.fieldOrder() == Writer.FieldOrder.ASCENDING) {
            for (int i = 0; i < this.count; ++i) {
                UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
            }
            return;
        } else {
            for (int i = this.count + -1; i >= 0; --i) {
                UnknownFieldSetLite.writeField(this.tags[i], this.objects[i], writer);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof UnknownFieldSetLite)) {
            return false;
        }
        object = (UnknownFieldSetLite)object;
        return this.count == ((UnknownFieldSetLite)object).count && UnknownFieldSetLite.tagsEquals(this.tags, ((UnknownFieldSetLite)object).tags, this.count) && UnknownFieldSetLite.objectsEquals(this.objects, ((UnknownFieldSetLite)object).objects, this.count);
    }

    boolean mergeFieldFrom(int n, CodedInputStream codedInputStream) throws IOException {
        this.checkMutable();
        int n2 = WireFormat.getTagFieldNumber(n);
        switch (WireFormat.getTagWireType(n)) {
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            case 5: {
                this.storeField(n, codedInputStream.readFixed32());
                return true;
            }
            case 4: {
                return false;
            }
            case 3: {
                UnknownFieldSetLite unknownFieldSetLite = new UnknownFieldSetLite();
                unknownFieldSetLite.mergeFrom(codedInputStream);
                codedInputStream.checkLastTagWas(WireFormat.makeTag(n2, 4));
                this.storeField(n, unknownFieldSetLite);
                return true;
            }
            case 2: {
                this.storeField(n, codedInputStream.readBytes());
                return true;
            }
            case 1: {
                this.storeField(n, codedInputStream.readFixed64());
                return true;
            }
            case 0: 
        }
        this.storeField(n, codedInputStream.readInt64());
        return true;
    }

    private static boolean objectsEquals(Object[] objectArray, Object[] objectArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean tagsEquals(int[] nArray, int[] nArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }
}

