/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.espresso.remote.internal.deps.protobuf;

import androidx.test.espresso.remote.internal.deps.protobuf.ByteString;
import androidx.test.espresso.remote.internal.deps.protobuf.InvalidProtocolBufferException;
import androidx.test.espresso.remote.internal.deps.protobuf.Reader;
import androidx.test.espresso.remote.internal.deps.protobuf.WireFormat;
import androidx.test.espresso.remote.internal.deps.protobuf.Writer;
import java.io.IOException;

abstract class UnknownFieldSchema {
    abstract int getSerializedSize(Object var1);

    abstract int getSerializedSizeAsMessageSet(Object var1);

    abstract Object getBuilderFromMessage(Object var1);

    abstract Object getFromMessage(Object var1);

    abstract Object merge(Object var1, Object var2);

    abstract Object newBuilder();

    abstract Object toImmutable(Object var1);

    UnknownFieldSchema() {
    }

    abstract void addFixed32(Object var1, int var2, int var3);

    abstract void addFixed64(Object var1, int var2, long var3);

    abstract void addGroup(Object var1, int var2, Object var3);

    abstract void addLengthDelimited(Object var1, int var2, ByteString var3);

    abstract void addVarint(Object var1, int var2, long var3);

    abstract void makeImmutable(Object var1);

    final void mergeFrom(Object object, Reader reader) throws IOException {
        while (reader.getFieldNumber() != Integer.MAX_VALUE && this.mergeOneFieldFrom(object, reader)) {
        }
    }

    abstract void setBuilderToMessage(Object var1, Object var2);

    abstract void setToMessage(Object var1, Object var2);

    abstract void writeAsMessageSetTo(Object var1, Writer var2) throws IOException;

    abstract void writeTo(Object var1, Writer var2) throws IOException;

    final boolean mergeOneFieldFrom(Object object, Reader reader) throws IOException {
        int n = reader.getTag();
        int n2 = WireFormat.getTagFieldNumber(n);
        switch (WireFormat.getTagWireType(n)) {
            case 5: {
                this.addFixed32(object, n2, reader.readFixed32());
                return true;
            }
            case 4: {
                return false;
            }
            case 3: {
                Object object2 = this.newBuilder();
                int n3 = WireFormat.makeTag(n2, 4);
                this.mergeFrom(object2, reader);
                if (n3 != reader.getTag()) {
                    throw InvalidProtocolBufferException.invalidEndTag();
                }
                this.addGroup(object, n2, this.toImmutable(object2));
                return true;
            }
            case 2: {
                this.addLengthDelimited(object, n2, reader.readBytes());
                return true;
            }
            case 1: {
                this.addFixed64(object, n2, reader.readFixed64());
                return true;
            }
            default: {
                throw InvalidProtocolBufferException.invalidWireType();
            }
            case 0: 
        }
        this.addVarint(object, n2, reader.readInt64());
        return true;
    }

    abstract boolean shouldDiscardUnknownFields(Reader var1);
}

